/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of the lifecycle policy preview.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicyPreviewResult implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicyPreviewResult.Builder, LifecyclePolicyPreviewResult> {
    private static final SdkField<List<String>> IMAGE_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("imageTags")
            .getter(getter(LifecyclePolicyPreviewResult::imageTags))
            .setter(setter(Builder::imageTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageDigest").getter(getter(LifecyclePolicyPreviewResult::imageDigest))
            .setter(setter(Builder::imageDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()).build();

    private static final SdkField<Instant> IMAGE_PUSHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("imagePushedAt").getter(getter(LifecyclePolicyPreviewResult::imagePushedAt))
            .setter(setter(Builder::imagePushedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePushedAt").build()).build();

    private static final SdkField<LifecyclePolicyRuleAction> ACTION_FIELD = SdkField
            .<LifecyclePolicyRuleAction> builder(MarshallingType.SDK_POJO).memberName("action")
            .getter(getter(LifecyclePolicyPreviewResult::action)).setter(setter(Builder::action))
            .constructor(LifecyclePolicyRuleAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Integer> APPLIED_RULE_PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("appliedRulePriority").getter(getter(LifecyclePolicyPreviewResult::appliedRulePriority))
            .setter(setter(Builder::appliedRulePriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedRulePriority").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_TAGS_FIELD,
            IMAGE_DIGEST_FIELD, IMAGE_PUSHED_AT_FIELD, ACTION_FIELD, APPLIED_RULE_PRIORITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> imageTags;

    private final String imageDigest;

    private final Instant imagePushedAt;

    private final LifecyclePolicyRuleAction action;

    private final Integer appliedRulePriority;

    private LifecyclePolicyPreviewResult(BuilderImpl builder) {
        this.imageTags = builder.imageTags;
        this.imageDigest = builder.imageDigest;
        this.imagePushedAt = builder.imagePushedAt;
        this.action = builder.action;
        this.appliedRulePriority = builder.appliedRulePriority;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImageTags() {
        return imageTags != null && !(imageTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags associated with this image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageTags} method.
     * </p>
     * 
     * @return The list of tags associated with this image.
     */
    public final List<String> imageTags() {
        return imageTags;
    }

    /**
     * <p>
     * The <code>sha256</code> digest of the image manifest.
     * </p>
     * 
     * @return The <code>sha256</code> digest of the image manifest.
     */
    public final String imageDigest() {
        return imageDigest;
    }

    /**
     * <p>
     * The date and time, expressed in standard JavaScript date format, at which the current image was pushed to the
     * repository.
     * </p>
     * 
     * @return The date and time, expressed in standard JavaScript date format, at which the current image was pushed to
     *         the repository.
     */
    public final Instant imagePushedAt() {
        return imagePushedAt;
    }

    /**
     * <p>
     * The type of action to be taken.
     * </p>
     * 
     * @return The type of action to be taken.
     */
    public final LifecyclePolicyRuleAction action() {
        return action;
    }

    /**
     * <p>
     * The priority of the applied rule.
     * </p>
     * 
     * @return The priority of the applied rule.
     */
    public final Integer appliedRulePriority() {
        return appliedRulePriority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasImageTags() ? imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(imagePushedAt());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(appliedRulePriority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyPreviewResult)) {
            return false;
        }
        LifecyclePolicyPreviewResult other = (LifecyclePolicyPreviewResult) obj;
        return hasImageTags() == other.hasImageTags() && Objects.equals(imageTags(), other.imageTags())
                && Objects.equals(imageDigest(), other.imageDigest()) && Objects.equals(imagePushedAt(), other.imagePushedAt())
                && Objects.equals(action(), other.action()) && Objects.equals(appliedRulePriority(), other.appliedRulePriority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicyPreviewResult").add("ImageTags", hasImageTags() ? imageTags() : null)
                .add("ImageDigest", imageDigest()).add("ImagePushedAt", imagePushedAt()).add("Action", action())
                .add("AppliedRulePriority", appliedRulePriority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageTags":
            return Optional.ofNullable(clazz.cast(imageTags()));
        case "imageDigest":
            return Optional.ofNullable(clazz.cast(imageDigest()));
        case "imagePushedAt":
            return Optional.ofNullable(clazz.cast(imagePushedAt()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "appliedRulePriority":
            return Optional.ofNullable(clazz.cast(appliedRulePriority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyPreviewResult, T> g) {
        return obj -> g.apply((LifecyclePolicyPreviewResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicyPreviewResult> {
        /**
         * <p>
         * The list of tags associated with this image.
         * </p>
         * 
         * @param imageTags
         *        The list of tags associated with this image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTags(Collection<String> imageTags);

        /**
         * <p>
         * The list of tags associated with this image.
         * </p>
         * 
         * @param imageTags
         *        The list of tags associated with this image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTags(String... imageTags);

        /**
         * <p>
         * The <code>sha256</code> digest of the image manifest.
         * </p>
         * 
         * @param imageDigest
         *        The <code>sha256</code> digest of the image manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDigest(String imageDigest);

        /**
         * <p>
         * The date and time, expressed in standard JavaScript date format, at which the current image was pushed to the
         * repository.
         * </p>
         * 
         * @param imagePushedAt
         *        The date and time, expressed in standard JavaScript date format, at which the current image was pushed
         *        to the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePushedAt(Instant imagePushedAt);

        /**
         * <p>
         * The type of action to be taken.
         * </p>
         * 
         * @param action
         *        The type of action to be taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(LifecyclePolicyRuleAction action);

        /**
         * <p>
         * The type of action to be taken.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecyclePolicyRuleAction.Builder}
         * avoiding the need to create one manually via {@link LifecyclePolicyRuleAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifecyclePolicyRuleAction.Builder#build()} is called immediately
         * and its result is passed to {@link #action(LifecyclePolicyRuleAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link LifecyclePolicyRuleAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(LifecyclePolicyRuleAction)
         */
        default Builder action(Consumer<LifecyclePolicyRuleAction.Builder> action) {
            return action(LifecyclePolicyRuleAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * The priority of the applied rule.
         * </p>
         * 
         * @param appliedRulePriority
         *        The priority of the applied rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedRulePriority(Integer appliedRulePriority);
    }

    static final class BuilderImpl implements Builder {
        private List<String> imageTags = DefaultSdkAutoConstructList.getInstance();

        private String imageDigest;

        private Instant imagePushedAt;

        private LifecyclePolicyRuleAction action;

        private Integer appliedRulePriority;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyPreviewResult model) {
            imageTags(model.imageTags);
            imageDigest(model.imageDigest);
            imagePushedAt(model.imagePushedAt);
            action(model.action);
            appliedRulePriority(model.appliedRulePriority);
        }

        public final Collection<String> getImageTags() {
            if (imageTags instanceof SdkAutoConstructList) {
                return null;
            }
            return imageTags;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String... imageTags) {
            imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final String getImageDigest() {
            return imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final Instant getImagePushedAt() {
            return imagePushedAt;
        }

        public final void setImagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
        }

        @Override
        public final Builder imagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
            return this;
        }

        public final LifecyclePolicyRuleAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(LifecyclePolicyRuleAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(LifecyclePolicyRuleAction action) {
            this.action = action;
            return this;
        }

        public final Integer getAppliedRulePriority() {
            return appliedRulePriority;
        }

        public final void setAppliedRulePriority(Integer appliedRulePriority) {
            this.appliedRulePriority = appliedRulePriority;
        }

        @Override
        public final Builder appliedRulePriority(Integer appliedRulePriority) {
            this.appliedRulePriority = appliedRulePriority;
            return this;
        }

        @Override
        public LifecyclePolicyPreviewResult build() {
            return new LifecyclePolicyPreviewResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
