/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImagesRequest extends EcrRequest implements
        ToCopyableBuilder<ListImagesRequest.Builder, ListImagesRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(ListImagesRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(ListImagesRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListImagesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListImagesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<ListImagesFilter> FILTER_FIELD = SdkField.<ListImagesFilter> builder(MarshallingType.SDK_POJO)
            .memberName("filter").getter(getter(ListImagesRequest::filter)).setter(setter(Builder::filter))
            .constructor(ListImagesFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTER_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final String nextToken;

    private final Integer maxResults;

    private final ListImagesFilter filter;

    private ListImagesRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry that contains the repository in which to list
     * images. If you do not specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry that contains the repository in which to
     *         list images. If you do not specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The repository with image IDs to be listed.
     * </p>
     * 
     * @return The repository with image IDs to be listed.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListImages</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListImages</code> request where
     *         <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. This value
     *         is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of image results returned by <code>ListImages</code> in paginated output. When this parameter
     * is used, <code>ListImages</code> only returns <code>maxResults</code> results in a single page along with a
     * <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending
     * another <code>ListImages</code> request with the returned <code>nextToken</code> value. This value can be between
     * 1 and 1000. If this parameter is not used, then <code>ListImages</code> returns up to 100 results and a
     * <code>nextToken</code> value, if applicable.
     * </p>
     * 
     * @return The maximum number of image results returned by <code>ListImages</code> in paginated output. When this
     *         parameter is used, <code>ListImages</code> only returns <code>maxResults</code> results in a single page
     *         along with a <code>nextToken</code> response element. The remaining results of the initial request can be
     *         seen by sending another <code>ListImages</code> request with the returned <code>nextToken</code> value.
     *         This value can be between 1 and 1000. If this parameter is not used, then <code>ListImages</code> returns
     *         up to 100 results and a <code>nextToken</code> value, if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The filter key and value with which to filter your <code>ListImages</code> results.
     * </p>
     * 
     * @return The filter key and value with which to filter your <code>ListImages</code> results.
     */
    public final ListImagesFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesRequest)) {
            return false;
        }
        ListImagesRequest other = (ListImagesRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImagesRequest").add("RegistryId", registryId()).add("RepositoryName", repositoryName())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("Filter", filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImagesRequest, T> g) {
        return obj -> g.apply((ListImagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListImagesRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry that contains the repository in which to list
         * images. If you do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry that contains the repository in which
         *        to list images. If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The repository with image IDs to be listed.
         * </p>
         * 
         * @param repositoryName
         *        The repository with image IDs to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListImages</code> request where
         * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
         * from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListImages</code> request
         *        where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of image results returned by <code>ListImages</code> in paginated output. When this
         * parameter is used, <code>ListImages</code> only returns <code>maxResults</code> results in a single page
         * along with a <code>nextToken</code> response element. The remaining results of the initial request can be
         * seen by sending another <code>ListImages</code> request with the returned <code>nextToken</code> value. This
         * value can be between 1 and 1000. If this parameter is not used, then <code>ListImages</code> returns up to
         * 100 results and a <code>nextToken</code> value, if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of image results returned by <code>ListImages</code> in paginated output. When this
         *        parameter is used, <code>ListImages</code> only returns <code>maxResults</code> results in a single
         *        page along with a <code>nextToken</code> response element. The remaining results of the initial
         *        request can be seen by sending another <code>ListImages</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used,
         *        then <code>ListImages</code> returns up to 100 results and a <code>nextToken</code> value, if
         *        applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The filter key and value with which to filter your <code>ListImages</code> results.
         * </p>
         * 
         * @param filter
         *        The filter key and value with which to filter your <code>ListImages</code> results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ListImagesFilter filter);

        /**
         * <p>
         * The filter key and value with which to filter your <code>ListImages</code> results.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListImagesFilter.Builder} avoiding the
         * need to create one manually via {@link ListImagesFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ListImagesFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(ListImagesFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ListImagesFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ListImagesFilter)
         */
        default Builder filter(Consumer<ListImagesFilter.Builder> filter) {
            return filter(ListImagesFilter.builder().applyMutation(filter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String nextToken;

        private Integer maxResults;

        private ListImagesFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagesRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filter(model.filter);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ListImagesFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(ListImagesFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ListImagesFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListImagesRequest build() {
            return new ListImagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
