/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRegistryScanningConfigurationResponse extends EcrResponse implements
        ToCopyableBuilder<PutRegistryScanningConfigurationResponse.Builder, PutRegistryScanningConfigurationResponse> {
    private static final SdkField<RegistryScanningConfiguration> REGISTRY_SCANNING_CONFIGURATION_FIELD = SdkField
            .<RegistryScanningConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("registryScanningConfiguration")
            .getter(getter(PutRegistryScanningConfigurationResponse::registryScanningConfiguration))
            .setter(setter(Builder::registryScanningConfiguration))
            .constructor(RegistryScanningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryScanningConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REGISTRY_SCANNING_CONFIGURATION_FIELD));

    private final RegistryScanningConfiguration registryScanningConfiguration;

    private PutRegistryScanningConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.registryScanningConfiguration = builder.registryScanningConfiguration;
    }

    /**
     * <p>
     * The scanning configuration for your registry.
     * </p>
     * 
     * @return The scanning configuration for your registry.
     */
    public final RegistryScanningConfiguration registryScanningConfiguration() {
        return registryScanningConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryScanningConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRegistryScanningConfigurationResponse)) {
            return false;
        }
        PutRegistryScanningConfigurationResponse other = (PutRegistryScanningConfigurationResponse) obj;
        return Objects.equals(registryScanningConfiguration(), other.registryScanningConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRegistryScanningConfigurationResponse")
                .add("RegistryScanningConfiguration", registryScanningConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryScanningConfiguration":
            return Optional.ofNullable(clazz.cast(registryScanningConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRegistryScanningConfigurationResponse, T> g) {
        return obj -> g.apply((PutRegistryScanningConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutRegistryScanningConfigurationResponse> {
        /**
         * <p>
         * The scanning configuration for your registry.
         * </p>
         * 
         * @param registryScanningConfiguration
         *        The scanning configuration for your registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryScanningConfiguration(RegistryScanningConfiguration registryScanningConfiguration);

        /**
         * <p>
         * The scanning configuration for your registry.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegistryScanningConfiguration.Builder}
         * avoiding the need to create one manually via {@link RegistryScanningConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegistryScanningConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #registryScanningConfiguration(RegistryScanningConfiguration)}
         * .
         * 
         * @param registryScanningConfiguration
         *        a consumer that will call methods on {@link RegistryScanningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registryScanningConfiguration(RegistryScanningConfiguration)
         */
        default Builder registryScanningConfiguration(
                Consumer<RegistryScanningConfiguration.Builder> registryScanningConfiguration) {
            return registryScanningConfiguration(RegistryScanningConfiguration.builder()
                    .applyMutation(registryScanningConfiguration).build());
        }
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private RegistryScanningConfiguration registryScanningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRegistryScanningConfigurationResponse model) {
            super(model);
            registryScanningConfiguration(model.registryScanningConfiguration);
        }

        public final RegistryScanningConfiguration.Builder getRegistryScanningConfiguration() {
            return registryScanningConfiguration != null ? registryScanningConfiguration.toBuilder() : null;
        }

        public final void setRegistryScanningConfiguration(RegistryScanningConfiguration.BuilderImpl registryScanningConfiguration) {
            this.registryScanningConfiguration = registryScanningConfiguration != null ? registryScanningConfiguration.build()
                    : null;
        }

        @Override
        public final Builder registryScanningConfiguration(RegistryScanningConfiguration registryScanningConfiguration) {
            this.registryScanningConfiguration = registryScanningConfiguration;
            return this;
        }

        @Override
        public PutRegistryScanningConfigurationResponse build() {
            return new PutRegistryScanningConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
