/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an image scan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageScanFindings implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageScanFindings.Builder, ImageScanFindings> {
    private static final SdkField<Instant> IMAGE_SCAN_COMPLETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("imageScanCompletedAt").getter(getter(ImageScanFindings::imageScanCompletedAt))
            .setter(setter(Builder::imageScanCompletedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanCompletedAt").build())
            .build();

    private static final SdkField<Instant> VULNERABILITY_SOURCE_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("vulnerabilitySourceUpdatedAt")
            .getter(getter(ImageScanFindings::vulnerabilitySourceUpdatedAt))
            .setter(setter(Builder::vulnerabilitySourceUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilitySourceUpdatedAt")
                    .build()).build();

    private static final SdkField<List<ImageScanFinding>> FINDINGS_FIELD = SdkField
            .<List<ImageScanFinding>> builder(MarshallingType.LIST)
            .memberName("findings")
            .getter(getter(ImageScanFindings::findings))
            .setter(setter(Builder::findings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageScanFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageScanFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> FINDING_SEVERITY_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("findingSeverityCounts")
            .getter(getter(ImageScanFindings::findingSeverityCountsAsStrings))
            .setter(setter(Builder::findingSeverityCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingSeverityCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SCAN_COMPLETED_AT_FIELD,
            VULNERABILITY_SOURCE_UPDATED_AT_FIELD, FINDINGS_FIELD, FINDING_SEVERITY_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant imageScanCompletedAt;

    private final Instant vulnerabilitySourceUpdatedAt;

    private final List<ImageScanFinding> findings;

    private final Map<String, Integer> findingSeverityCounts;

    private ImageScanFindings(BuilderImpl builder) {
        this.imageScanCompletedAt = builder.imageScanCompletedAt;
        this.vulnerabilitySourceUpdatedAt = builder.vulnerabilitySourceUpdatedAt;
        this.findings = builder.findings;
        this.findingSeverityCounts = builder.findingSeverityCounts;
    }

    /**
     * <p>
     * The time of the last completed image scan.
     * </p>
     * 
     * @return The time of the last completed image scan.
     */
    public final Instant imageScanCompletedAt() {
        return imageScanCompletedAt;
    }

    /**
     * <p>
     * The time when the vulnerability data was last scanned.
     * </p>
     * 
     * @return The time when the vulnerability data was last scanned.
     */
    public final Instant vulnerabilitySourceUpdatedAt() {
        return vulnerabilitySourceUpdatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Findings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFindings() {
        return findings != null && !(findings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The findings from the image scan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindings} method.
     * </p>
     * 
     * @return The findings from the image scan.
     */
    public final List<ImageScanFinding> findings() {
        return findings;
    }

    /**
     * <p>
     * The image vulnerability counts, sorted by severity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingSeverityCounts} method.
     * </p>
     * 
     * @return The image vulnerability counts, sorted by severity.
     */
    public final Map<FindingSeverity, Integer> findingSeverityCounts() {
        return FindingSeverityCountsCopier.copyStringToEnum(findingSeverityCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingSeverityCounts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFindingSeverityCounts() {
        return findingSeverityCounts != null && !(findingSeverityCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The image vulnerability counts, sorted by severity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingSeverityCounts} method.
     * </p>
     * 
     * @return The image vulnerability counts, sorted by severity.
     */
    public final Map<String, Integer> findingSeverityCountsAsStrings() {
        return findingSeverityCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageScanCompletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(vulnerabilitySourceUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasFindings() ? findings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingSeverityCounts() ? findingSeverityCountsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanFindings)) {
            return false;
        }
        ImageScanFindings other = (ImageScanFindings) obj;
        return Objects.equals(imageScanCompletedAt(), other.imageScanCompletedAt())
                && Objects.equals(vulnerabilitySourceUpdatedAt(), other.vulnerabilitySourceUpdatedAt())
                && hasFindings() == other.hasFindings() && Objects.equals(findings(), other.findings())
                && hasFindingSeverityCounts() == other.hasFindingSeverityCounts()
                && Objects.equals(findingSeverityCountsAsStrings(), other.findingSeverityCountsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageScanFindings").add("ImageScanCompletedAt", imageScanCompletedAt())
                .add("VulnerabilitySourceUpdatedAt", vulnerabilitySourceUpdatedAt())
                .add("Findings", hasFindings() ? findings() : null)
                .add("FindingSeverityCounts", hasFindingSeverityCounts() ? findingSeverityCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageScanCompletedAt":
            return Optional.ofNullable(clazz.cast(imageScanCompletedAt()));
        case "vulnerabilitySourceUpdatedAt":
            return Optional.ofNullable(clazz.cast(vulnerabilitySourceUpdatedAt()));
        case "findings":
            return Optional.ofNullable(clazz.cast(findings()));
        case "findingSeverityCounts":
            return Optional.ofNullable(clazz.cast(findingSeverityCountsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageScanFindings, T> g) {
        return obj -> g.apply((ImageScanFindings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageScanFindings> {
        /**
         * <p>
         * The time of the last completed image scan.
         * </p>
         * 
         * @param imageScanCompletedAt
         *        The time of the last completed image scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanCompletedAt(Instant imageScanCompletedAt);

        /**
         * <p>
         * The time when the vulnerability data was last scanned.
         * </p>
         * 
         * @param vulnerabilitySourceUpdatedAt
         *        The time when the vulnerability data was last scanned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilitySourceUpdatedAt(Instant vulnerabilitySourceUpdatedAt);

        /**
         * <p>
         * The findings from the image scan.
         * </p>
         * 
         * @param findings
         *        The findings from the image scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(Collection<ImageScanFinding> findings);

        /**
         * <p>
         * The findings from the image scan.
         * </p>
         * 
         * @param findings
         *        The findings from the image scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(ImageScanFinding... findings);

        /**
         * <p>
         * The findings from the image scan.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImageScanFinding>.Builder} avoiding the
         * need to create one manually via {@link List<ImageScanFinding>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImageScanFinding>.Builder#build()} is called immediately and
         * its result is passed to {@link #findings(List<ImageScanFinding>)}.
         * 
         * @param findings
         *        a consumer that will call methods on {@link List<ImageScanFinding>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findings(List<ImageScanFinding>)
         */
        Builder findings(Consumer<ImageScanFinding.Builder>... findings);

        /**
         * <p>
         * The image vulnerability counts, sorted by severity.
         * </p>
         * 
         * @param findingSeverityCounts
         *        The image vulnerability counts, sorted by severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingSeverityCountsWithStrings(Map<String, Integer> findingSeverityCounts);

        /**
         * <p>
         * The image vulnerability counts, sorted by severity.
         * </p>
         * 
         * @param findingSeverityCounts
         *        The image vulnerability counts, sorted by severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingSeverityCounts(Map<FindingSeverity, Integer> findingSeverityCounts);
    }

    static final class BuilderImpl implements Builder {
        private Instant imageScanCompletedAt;

        private Instant vulnerabilitySourceUpdatedAt;

        private List<ImageScanFinding> findings = DefaultSdkAutoConstructList.getInstance();

        private Map<String, Integer> findingSeverityCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageScanFindings model) {
            imageScanCompletedAt(model.imageScanCompletedAt);
            vulnerabilitySourceUpdatedAt(model.vulnerabilitySourceUpdatedAt);
            findings(model.findings);
            findingSeverityCountsWithStrings(model.findingSeverityCounts);
        }

        public final Instant getImageScanCompletedAt() {
            return imageScanCompletedAt;
        }

        public final void setImageScanCompletedAt(Instant imageScanCompletedAt) {
            this.imageScanCompletedAt = imageScanCompletedAt;
        }

        @Override
        @Transient
        public final Builder imageScanCompletedAt(Instant imageScanCompletedAt) {
            this.imageScanCompletedAt = imageScanCompletedAt;
            return this;
        }

        public final Instant getVulnerabilitySourceUpdatedAt() {
            return vulnerabilitySourceUpdatedAt;
        }

        public final void setVulnerabilitySourceUpdatedAt(Instant vulnerabilitySourceUpdatedAt) {
            this.vulnerabilitySourceUpdatedAt = vulnerabilitySourceUpdatedAt;
        }

        @Override
        @Transient
        public final Builder vulnerabilitySourceUpdatedAt(Instant vulnerabilitySourceUpdatedAt) {
            this.vulnerabilitySourceUpdatedAt = vulnerabilitySourceUpdatedAt;
            return this;
        }

        public final List<ImageScanFinding.Builder> getFindings() {
            List<ImageScanFinding.Builder> result = ImageScanFindingListCopier.copyToBuilder(this.findings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindings(Collection<ImageScanFinding.BuilderImpl> findings) {
            this.findings = ImageScanFindingListCopier.copyFromBuilder(findings);
        }

        @Override
        @Transient
        public final Builder findings(Collection<ImageScanFinding> findings) {
            this.findings = ImageScanFindingListCopier.copy(findings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder findings(ImageScanFinding... findings) {
            findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder findings(Consumer<ImageScanFinding.Builder>... findings) {
            findings(Stream.of(findings).map(c -> ImageScanFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Integer> getFindingSeverityCounts() {
            if (findingSeverityCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return findingSeverityCounts;
        }

        public final void setFindingSeverityCounts(Map<String, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copy(findingSeverityCounts);
        }

        @Override
        @Transient
        public final Builder findingSeverityCountsWithStrings(Map<String, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copy(findingSeverityCounts);
            return this;
        }

        @Override
        @Transient
        public final Builder findingSeverityCounts(Map<FindingSeverity, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copyEnumToString(findingSeverityCounts);
            return this;
        }

        @Override
        public ImageScanFindings build() {
            return new ImageScanFindings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
