/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter settings used with image replication. Specifying a repository filter to a replication rule provides a
 * method for controlling which repositories in a private registry are replicated. If no repository filter is specified,
 * all images in the repository are replicated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryFilter.Builder, RepositoryFilter> {
    private static final SdkField<String> FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("filter")
            .getter(getter(RepositoryFilter::filter)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterType").getter(getter(RepositoryFilter::filterTypeAsString)).setter(setter(Builder::filterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            FILTER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filter;

    private final String filterType;

    private RepositoryFilter(BuilderImpl builder) {
        this.filter = builder.filter;
        this.filterType = builder.filterType;
    }

    /**
     * <p>
     * The repository filter details. When the <code>PREFIX_MATCH</code> filter type is specified, this value is
     * required and should be the repository name prefix to configure replication for.
     * </p>
     * 
     * @return The repository filter details. When the <code>PREFIX_MATCH</code> filter type is specified, this value is
     *         required and should be the repository name prefix to configure replication for.
     */
    public final String filter() {
        return filter;
    }

    /**
     * <p>
     * The repository filter type. The only supported value is <code>PREFIX_MATCH</code>, which is a repository name
     * prefix specified with the <code>filter</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link RepositoryFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The repository filter type. The only supported value is <code>PREFIX_MATCH</code>, which is a repository
     *         name prefix specified with the <code>filter</code> parameter.
     * @see RepositoryFilterType
     */
    public final RepositoryFilterType filterType() {
        return RepositoryFilterType.fromValue(filterType);
    }

    /**
     * <p>
     * The repository filter type. The only supported value is <code>PREFIX_MATCH</code>, which is a repository name
     * prefix specified with the <code>filter</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link RepositoryFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The repository filter type. The only supported value is <code>PREFIX_MATCH</code>, which is a repository
     *         name prefix specified with the <code>filter</code> parameter.
     * @see RepositoryFilterType
     */
    public final String filterTypeAsString() {
        return filterType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(filterTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryFilter)) {
            return false;
        }
        RepositoryFilter other = (RepositoryFilter) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(filterTypeAsString(), other.filterTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryFilter").add("Filter", filter()).add("FilterType", filterTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "filterType":
            return Optional.ofNullable(clazz.cast(filterTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryFilter, T> g) {
        return obj -> g.apply((RepositoryFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryFilter> {
        /**
         * <p>
         * The repository filter details. When the <code>PREFIX_MATCH</code> filter type is specified, this value is
         * required and should be the repository name prefix to configure replication for.
         * </p>
         * 
         * @param filter
         *        The repository filter details. When the <code>PREFIX_MATCH</code> filter type is specified, this value
         *        is required and should be the repository name prefix to configure replication for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(String filter);

        /**
         * <p>
         * The repository filter type. The only supported value is <code>PREFIX_MATCH</code>, which is a repository name
         * prefix specified with the <code>filter</code> parameter.
         * </p>
         * 
         * @param filterType
         *        The repository filter type. The only supported value is <code>PREFIX_MATCH</code>, which is a
         *        repository name prefix specified with the <code>filter</code> parameter.
         * @see RepositoryFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryFilterType
         */
        Builder filterType(String filterType);

        /**
         * <p>
         * The repository filter type. The only supported value is <code>PREFIX_MATCH</code>, which is a repository name
         * prefix specified with the <code>filter</code> parameter.
         * </p>
         * 
         * @param filterType
         *        The repository filter type. The only supported value is <code>PREFIX_MATCH</code>, which is a
         *        repository name prefix specified with the <code>filter</code> parameter.
         * @see RepositoryFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RepositoryFilterType
         */
        Builder filterType(RepositoryFilterType filterType);
    }

    static final class BuilderImpl implements Builder {
        private String filter;

        private String filterType;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryFilter model) {
            filter(model.filter);
            filterType(model.filterType);
        }

        public final String getFilter() {
            return filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        @Transient
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final String getFilterType() {
            return filterType;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        @Transient
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        @Transient
        public final Builder filterType(RepositoryFilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        @Override
        public RepositoryFilter build() {
            return new RepositoryFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
