/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.ecr.EcrAsyncClient;
import software.amazon.awssdk.services.ecr.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse;
import software.amazon.awssdk.services.ecr.waiters.EcrAsyncWaiter;
import software.amazon.awssdk.services.ecr.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultEcrAsyncWaiter
implements EcrAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final EcrAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeImageScanFindingsResponse> imageScanCompleteWaiter;
    private final AsyncWaiter<GetLifecyclePolicyPreviewResponse> lifecyclePolicyPreviewCompleteWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultEcrAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (EcrAsyncClient)EcrAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.imageScanCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeImageScanFindingsResponse.class).acceptors(DefaultEcrAsyncWaiter.imageScanCompleteWaiterAcceptors())).overrideConfiguration(DefaultEcrAsyncWaiter.imageScanCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.lifecyclePolicyPreviewCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetLifecyclePolicyPreviewResponse.class).acceptors(DefaultEcrAsyncWaiter.lifecyclePolicyPreviewCompleteWaiterAcceptors())).overrideConfiguration(DefaultEcrAsyncWaiter.lifecyclePolicyPreviewCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageScanFindingsResponse>> waitUntilImageScanComplete(DescribeImageScanFindingsRequest describeImageScanFindingsRequest) {
        return this.imageScanCompleteWaiter.runAsync(() -> this.client.describeImageScanFindings(this.applyWaitersUserAgent(describeImageScanFindingsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImageScanFindingsResponse>> waitUntilImageScanComplete(DescribeImageScanFindingsRequest describeImageScanFindingsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageScanCompleteWaiter.runAsync(() -> this.client.describeImageScanFindings(this.applyWaitersUserAgent(describeImageScanFindingsRequest)), DefaultEcrAsyncWaiter.imageScanCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLifecyclePolicyPreviewResponse>> waitUntilLifecyclePolicyPreviewComplete(GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest) {
        return this.lifecyclePolicyPreviewCompleteWaiter.runAsync(() -> this.client.getLifecyclePolicyPreview(this.applyWaitersUserAgent(getLifecyclePolicyPreviewRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLifecyclePolicyPreviewResponse>> waitUntilLifecyclePolicyPreviewComplete(GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.lifecyclePolicyPreviewCompleteWaiter.runAsync(() -> this.client.getLifecyclePolicyPreview(this.applyWaitersUserAgent(getLifecyclePolicyPreviewRequest)), DefaultEcrAsyncWaiter.lifecyclePolicyPreviewCompleteWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeImageScanFindingsResponse>> imageScanCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageScanFindingsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageScanFindingsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("imageScanStatus").field("status").value(), "COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("imageScanStatus").field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (imageScanStatus.status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLifecyclePolicyPreviewResponse>> lifecyclePolicyPreviewCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLifecyclePolicyPreviewResponse>> result = new ArrayList<WaiterAcceptor<? super GetLifecyclePolicyPreviewResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration imageScanCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration lifecyclePolicyPreviewCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static EcrAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends EcrRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EcrRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements EcrAsyncWaiter.Builder {
        private EcrAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public EcrAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public EcrAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public EcrAsyncWaiter.Builder client(EcrAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public EcrAsyncWaiter build() {
            return new DefaultEcrAsyncWaiter(this);
        }
    }
}

