/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRepositoryCreationTemplateResponse extends EcrResponse implements
        ToCopyableBuilder<CreateRepositoryCreationTemplateResponse.Builder, CreateRepositoryCreationTemplateResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(CreateRepositoryCreationTemplateResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<RepositoryCreationTemplate> REPOSITORY_CREATION_TEMPLATE_FIELD = SdkField
            .<RepositoryCreationTemplate> builder(MarshallingType.SDK_POJO)
            .memberName("repositoryCreationTemplate")
            .getter(getter(CreateRepositoryCreationTemplateResponse::repositoryCreationTemplate))
            .setter(setter(Builder::repositoryCreationTemplate))
            .constructor(RepositoryCreationTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCreationTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_CREATION_TEMPLATE_FIELD));

    private final String registryId;

    private final RepositoryCreationTemplate repositoryCreationTemplate;

    private CreateRepositoryCreationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryCreationTemplate = builder.repositoryCreationTemplate;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The details of the repository creation template associated with the request.
     * </p>
     * 
     * @return The details of the repository creation template associated with the request.
     */
    public final RepositoryCreationTemplate repositoryCreationTemplate() {
        return repositoryCreationTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryCreationTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryCreationTemplateResponse)) {
            return false;
        }
        CreateRepositoryCreationTemplateResponse other = (CreateRepositoryCreationTemplateResponse) obj;
        return Objects.equals(registryId(), other.registryId())
                && Objects.equals(repositoryCreationTemplate(), other.repositoryCreationTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRepositoryCreationTemplateResponse").add("RegistryId", registryId())
                .add("RepositoryCreationTemplate", repositoryCreationTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryCreationTemplate":
            return Optional.ofNullable(clazz.cast(repositoryCreationTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRepositoryCreationTemplateResponse, T> g) {
        return obj -> g.apply((CreateRepositoryCreationTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRepositoryCreationTemplateResponse> {
        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The details of the repository creation template associated with the request.
         * </p>
         * 
         * @param repositoryCreationTemplate
         *        The details of the repository creation template associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryCreationTemplate(RepositoryCreationTemplate repositoryCreationTemplate);

        /**
         * <p>
         * The details of the repository creation template associated with the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepositoryCreationTemplate.Builder}
         * avoiding the need to create one manually via {@link RepositoryCreationTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RepositoryCreationTemplate.Builder#build()} is called immediately
         * and its result is passed to {@link #repositoryCreationTemplate(RepositoryCreationTemplate)}.
         * 
         * @param repositoryCreationTemplate
         *        a consumer that will call methods on {@link RepositoryCreationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryCreationTemplate(RepositoryCreationTemplate)
         */
        default Builder repositoryCreationTemplate(Consumer<RepositoryCreationTemplate.Builder> repositoryCreationTemplate) {
            return repositoryCreationTemplate(RepositoryCreationTemplate.builder().applyMutation(repositoryCreationTemplate)
                    .build());
        }
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String registryId;

        private RepositoryCreationTemplate repositoryCreationTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryCreationTemplateResponse model) {
            super(model);
            registryId(model.registryId);
            repositoryCreationTemplate(model.repositoryCreationTemplate);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final RepositoryCreationTemplate.Builder getRepositoryCreationTemplate() {
            return repositoryCreationTemplate != null ? repositoryCreationTemplate.toBuilder() : null;
        }

        public final void setRepositoryCreationTemplate(RepositoryCreationTemplate.BuilderImpl repositoryCreationTemplate) {
            this.repositoryCreationTemplate = repositoryCreationTemplate != null ? repositoryCreationTemplate.build() : null;
        }

        @Override
        public final Builder repositoryCreationTemplate(RepositoryCreationTemplate repositoryCreationTemplate) {
            this.repositoryCreationTemplate = repositoryCreationTemplate;
            return this;
        }

        @Override
        public CreateRepositoryCreationTemplateResponse build() {
            return new CreateRepositoryCreationTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
