/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageReplicationStatusResponse extends EcrResponse implements
        ToCopyableBuilder<DescribeImageReplicationStatusResponse.Builder, DescribeImageReplicationStatusResponse> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(DescribeImageReplicationStatusResponse::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.<ImageIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("imageId").getter(getter(DescribeImageReplicationStatusResponse::imageId))
            .setter(setter(Builder::imageId)).constructor(ImageIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final SdkField<List<ImageReplicationStatus>> REPLICATION_STATUSES_FIELD = SdkField
            .<List<ImageReplicationStatus>> builder(MarshallingType.LIST)
            .memberName("replicationStatuses")
            .getter(getter(DescribeImageReplicationStatusResponse::replicationStatuses))
            .setter(setter(Builder::replicationStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageReplicationStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageReplicationStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            IMAGE_ID_FIELD, REPLICATION_STATUSES_FIELD));

    private final String repositoryName;

    private final ImageIdentifier imageId;

    private final List<ImageReplicationStatus> replicationStatuses;

    private DescribeImageReplicationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.replicationStatuses = builder.replicationStatuses;
    }

    /**
     * <p>
     * The repository name associated with the request.
     * </p>
     * 
     * @return The repository name associated with the request.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * Returns the value of the ImageId property for this object.
     * 
     * @return The value of the ImageId property for this object.
     */
    public final ImageIdentifier imageId() {
        return imageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationStatuses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationStatuses() {
        return replicationStatuses != null && !(replicationStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replication status details for the images in the specified repository.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationStatuses} method.
     * </p>
     * 
     * @return The replication status details for the images in the specified repository.
     */
    public final List<ImageReplicationStatus> replicationStatuses() {
        return replicationStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationStatuses() ? replicationStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageReplicationStatusResponse)) {
            return false;
        }
        DescribeImageReplicationStatusResponse other = (DescribeImageReplicationStatusResponse) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(imageId(), other.imageId())
                && hasReplicationStatuses() == other.hasReplicationStatuses()
                && Objects.equals(replicationStatuses(), other.replicationStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageReplicationStatusResponse").add("RepositoryName", repositoryName())
                .add("ImageId", imageId()).add("ReplicationStatuses", hasReplicationStatuses() ? replicationStatuses() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "replicationStatuses":
            return Optional.ofNullable(clazz.cast(replicationStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageReplicationStatusResponse, T> g) {
        return obj -> g.apply((DescribeImageReplicationStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeImageReplicationStatusResponse> {
        /**
         * <p>
         * The repository name associated with the request.
         * </p>
         * 
         * @param repositoryName
         *        The repository name associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * Sets the value of the ImageId property for this object.
         *
         * @param imageId
         *        The new value for the ImageId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(ImageIdentifier imageId);

        /**
         * Sets the value of the ImageId property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImageIdentifier.Builder} avoiding the
         * need to create one manually via {@link ImageIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #imageId(ImageIdentifier)}.
         * 
         * @param imageId
         *        a consumer that will call methods on {@link ImageIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageId(ImageIdentifier)
         */
        default Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return imageId(ImageIdentifier.builder().applyMutation(imageId).build());
        }

        /**
         * <p>
         * The replication status details for the images in the specified repository.
         * </p>
         * 
         * @param replicationStatuses
         *        The replication status details for the images in the specified repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatuses(Collection<ImageReplicationStatus> replicationStatuses);

        /**
         * <p>
         * The replication status details for the images in the specified repository.
         * </p>
         * 
         * @param replicationStatuses
         *        The replication status details for the images in the specified repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatuses(ImageReplicationStatus... replicationStatuses);

        /**
         * <p>
         * The replication status details for the images in the specified repository.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.ImageReplicationStatus.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ecr.model.ImageReplicationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.ImageReplicationStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationStatuses(List<ImageReplicationStatus>)}.
         * 
         * @param replicationStatuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.ImageReplicationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationStatuses(java.util.Collection<ImageReplicationStatus>)
         */
        Builder replicationStatuses(Consumer<ImageReplicationStatus.Builder>... replicationStatuses);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String repositoryName;

        private ImageIdentifier imageId;

        private List<ImageReplicationStatus> replicationStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageReplicationStatusResponse model) {
            super(model);
            repositoryName(model.repositoryName);
            imageId(model.imageId);
            replicationStatuses(model.replicationStatuses);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageIdentifier.Builder getImageId() {
            return imageId != null ? imageId.toBuilder() : null;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final List<ImageReplicationStatus.Builder> getReplicationStatuses() {
            List<ImageReplicationStatus.Builder> result = ImageReplicationStatusListCopier
                    .copyToBuilder(this.replicationStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationStatuses(Collection<ImageReplicationStatus.BuilderImpl> replicationStatuses) {
            this.replicationStatuses = ImageReplicationStatusListCopier.copyFromBuilder(replicationStatuses);
        }

        @Override
        public final Builder replicationStatuses(Collection<ImageReplicationStatus> replicationStatuses) {
            this.replicationStatuses = ImageReplicationStatusListCopier.copy(replicationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatuses(ImageReplicationStatus... replicationStatuses) {
            replicationStatuses(Arrays.asList(replicationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatuses(Consumer<ImageReplicationStatus.Builder>... replicationStatuses) {
            replicationStatuses(Stream.of(replicationStatuses)
                    .map(c -> ImageReplicationStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeImageReplicationStatusResponse build() {
            return new DescribeImageReplicationStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
