/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a scanning rule for a private registry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistryScanningRule implements SdkPojo, Serializable,
        ToCopyableBuilder<RegistryScanningRule.Builder, RegistryScanningRule> {
    private static final SdkField<String> SCAN_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanFrequency").getter(getter(RegistryScanningRule::scanFrequencyAsString))
            .setter(setter(Builder::scanFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanFrequency").build()).build();

    private static final SdkField<List<ScanningRepositoryFilter>> REPOSITORY_FILTERS_FIELD = SdkField
            .<List<ScanningRepositoryFilter>> builder(MarshallingType.LIST)
            .memberName("repositoryFilters")
            .getter(getter(RegistryScanningRule::repositoryFilters))
            .setter(setter(Builder::repositoryFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScanningRepositoryFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanningRepositoryFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_FREQUENCY_FIELD,
            REPOSITORY_FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scanFrequency;

    private final List<ScanningRepositoryFilter> repositoryFilters;

    private RegistryScanningRule(BuilderImpl builder) {
        this.scanFrequency = builder.scanFrequency;
        this.repositoryFilters = builder.repositoryFilters;
    }

    /**
     * <p>
     * The frequency that scans are performed at for a private registry. When the <code>ENHANCED</code> scan type is
     * specified, the supported scan frequencies are <code>CONTINUOUS_SCAN</code> and <code>SCAN_ON_PUSH</code>. When
     * the <code>BASIC</code> scan type is specified, the <code>SCAN_ON_PUSH</code> scan frequency is supported. If scan
     * on push is not specified, then the <code>MANUAL</code> scan frequency is set by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanFrequency}
     * will return {@link ScanFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanFrequencyAsString}.
     * </p>
     * 
     * @return The frequency that scans are performed at for a private registry. When the <code>ENHANCED</code> scan
     *         type is specified, the supported scan frequencies are <code>CONTINUOUS_SCAN</code> and
     *         <code>SCAN_ON_PUSH</code>. When the <code>BASIC</code> scan type is specified, the
     *         <code>SCAN_ON_PUSH</code> scan frequency is supported. If scan on push is not specified, then the
     *         <code>MANUAL</code> scan frequency is set by default.
     * @see ScanFrequency
     */
    public final ScanFrequency scanFrequency() {
        return ScanFrequency.fromValue(scanFrequency);
    }

    /**
     * <p>
     * The frequency that scans are performed at for a private registry. When the <code>ENHANCED</code> scan type is
     * specified, the supported scan frequencies are <code>CONTINUOUS_SCAN</code> and <code>SCAN_ON_PUSH</code>. When
     * the <code>BASIC</code> scan type is specified, the <code>SCAN_ON_PUSH</code> scan frequency is supported. If scan
     * on push is not specified, then the <code>MANUAL</code> scan frequency is set by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanFrequency}
     * will return {@link ScanFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanFrequencyAsString}.
     * </p>
     * 
     * @return The frequency that scans are performed at for a private registry. When the <code>ENHANCED</code> scan
     *         type is specified, the supported scan frequencies are <code>CONTINUOUS_SCAN</code> and
     *         <code>SCAN_ON_PUSH</code>. When the <code>BASIC</code> scan type is specified, the
     *         <code>SCAN_ON_PUSH</code> scan frequency is supported. If scan on push is not specified, then the
     *         <code>MANUAL</code> scan frequency is set by default.
     * @see ScanFrequency
     */
    public final String scanFrequencyAsString() {
        return scanFrequency;
    }

    /**
     * For responses, this returns true if the service returned a value for the RepositoryFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepositoryFilters() {
        return repositoryFilters != null && !(repositoryFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The repository filters associated with the scanning configuration for a private registry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositoryFilters} method.
     * </p>
     * 
     * @return The repository filters associated with the scanning configuration for a private registry.
     */
    public final List<ScanningRepositoryFilter> repositoryFilters() {
        return repositoryFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositoryFilters() ? repositoryFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistryScanningRule)) {
            return false;
        }
        RegistryScanningRule other = (RegistryScanningRule) obj;
        return Objects.equals(scanFrequencyAsString(), other.scanFrequencyAsString())
                && hasRepositoryFilters() == other.hasRepositoryFilters()
                && Objects.equals(repositoryFilters(), other.repositoryFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistryScanningRule").add("ScanFrequency", scanFrequencyAsString())
                .add("RepositoryFilters", hasRepositoryFilters() ? repositoryFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanFrequency":
            return Optional.ofNullable(clazz.cast(scanFrequencyAsString()));
        case "repositoryFilters":
            return Optional.ofNullable(clazz.cast(repositoryFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegistryScanningRule, T> g) {
        return obj -> g.apply((RegistryScanningRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistryScanningRule> {
        /**
         * <p>
         * The frequency that scans are performed at for a private registry. When the <code>ENHANCED</code> scan type is
         * specified, the supported scan frequencies are <code>CONTINUOUS_SCAN</code> and <code>SCAN_ON_PUSH</code>.
         * When the <code>BASIC</code> scan type is specified, the <code>SCAN_ON_PUSH</code> scan frequency is
         * supported. If scan on push is not specified, then the <code>MANUAL</code> scan frequency is set by default.
         * </p>
         * 
         * @param scanFrequency
         *        The frequency that scans are performed at for a private registry. When the <code>ENHANCED</code> scan
         *        type is specified, the supported scan frequencies are <code>CONTINUOUS_SCAN</code> and
         *        <code>SCAN_ON_PUSH</code>. When the <code>BASIC</code> scan type is specified, the
         *        <code>SCAN_ON_PUSH</code> scan frequency is supported. If scan on push is not specified, then the
         *        <code>MANUAL</code> scan frequency is set by default.
         * @see ScanFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanFrequency
         */
        Builder scanFrequency(String scanFrequency);

        /**
         * <p>
         * The frequency that scans are performed at for a private registry. When the <code>ENHANCED</code> scan type is
         * specified, the supported scan frequencies are <code>CONTINUOUS_SCAN</code> and <code>SCAN_ON_PUSH</code>.
         * When the <code>BASIC</code> scan type is specified, the <code>SCAN_ON_PUSH</code> scan frequency is
         * supported. If scan on push is not specified, then the <code>MANUAL</code> scan frequency is set by default.
         * </p>
         * 
         * @param scanFrequency
         *        The frequency that scans are performed at for a private registry. When the <code>ENHANCED</code> scan
         *        type is specified, the supported scan frequencies are <code>CONTINUOUS_SCAN</code> and
         *        <code>SCAN_ON_PUSH</code>. When the <code>BASIC</code> scan type is specified, the
         *        <code>SCAN_ON_PUSH</code> scan frequency is supported. If scan on push is not specified, then the
         *        <code>MANUAL</code> scan frequency is set by default.
         * @see ScanFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanFrequency
         */
        Builder scanFrequency(ScanFrequency scanFrequency);

        /**
         * <p>
         * The repository filters associated with the scanning configuration for a private registry.
         * </p>
         * 
         * @param repositoryFilters
         *        The repository filters associated with the scanning configuration for a private registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryFilters(Collection<ScanningRepositoryFilter> repositoryFilters);

        /**
         * <p>
         * The repository filters associated with the scanning configuration for a private registry.
         * </p>
         * 
         * @param repositoryFilters
         *        The repository filters associated with the scanning configuration for a private registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryFilters(ScanningRepositoryFilter... repositoryFilters);

        /**
         * <p>
         * The repository filters associated with the scanning configuration for a private registry.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #repositoryFilters(List<ScanningRepositoryFilter>)}.
         * 
         * @param repositoryFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryFilters(java.util.Collection<ScanningRepositoryFilter>)
         */
        Builder repositoryFilters(Consumer<ScanningRepositoryFilter.Builder>... repositoryFilters);
    }

    static final class BuilderImpl implements Builder {
        private String scanFrequency;

        private List<ScanningRepositoryFilter> repositoryFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegistryScanningRule model) {
            scanFrequency(model.scanFrequency);
            repositoryFilters(model.repositoryFilters);
        }

        public final String getScanFrequency() {
            return scanFrequency;
        }

        public final void setScanFrequency(String scanFrequency) {
            this.scanFrequency = scanFrequency;
        }

        @Override
        public final Builder scanFrequency(String scanFrequency) {
            this.scanFrequency = scanFrequency;
            return this;
        }

        @Override
        public final Builder scanFrequency(ScanFrequency scanFrequency) {
            this.scanFrequency(scanFrequency == null ? null : scanFrequency.toString());
            return this;
        }

        public final List<ScanningRepositoryFilter.Builder> getRepositoryFilters() {
            List<ScanningRepositoryFilter.Builder> result = ScanningRepositoryFilterListCopier
                    .copyToBuilder(this.repositoryFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositoryFilters(Collection<ScanningRepositoryFilter.BuilderImpl> repositoryFilters) {
            this.repositoryFilters = ScanningRepositoryFilterListCopier.copyFromBuilder(repositoryFilters);
        }

        @Override
        public final Builder repositoryFilters(Collection<ScanningRepositoryFilter> repositoryFilters) {
            this.repositoryFilters = ScanningRepositoryFilterListCopier.copy(repositoryFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryFilters(ScanningRepositoryFilter... repositoryFilters) {
            repositoryFilters(Arrays.asList(repositoryFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryFilters(Consumer<ScanningRepositoryFilter.Builder>... repositoryFilters) {
            repositoryFilters(Stream.of(repositoryFilters).map(c -> ScanningRepositoryFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RegistryScanningRule build() {
            return new RegistryScanningRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
