/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The encryption configuration to associate with the repository creation template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionConfigurationForRepositoryCreationTemplate
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<EncryptionConfigurationForRepositoryCreationTemplate.Builder, EncryptionConfigurationForRepositoryCreationTemplate> {
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionType")
            .getter(getter(EncryptionConfigurationForRepositoryCreationTemplate::encryptionTypeAsString))
            .setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kmsKey")
            .getter(getter(EncryptionConfigurationForRepositoryCreationTemplate::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_TYPE_FIELD,
            KMS_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String encryptionType;

    private final String kmsKey;

    private EncryptionConfigurationForRepositoryCreationTemplate(BuilderImpl builder) {
        this.encryptionType = builder.encryptionType;
        this.kmsKey = builder.kmsKey;
    }

    /**
     * <p>
     * The encryption type to use.
     * </p>
     * <p>
     * If you use the <code>KMS</code> encryption type, the contents of the repository will be encrypted using
     * server-side encryption with Key Management Service key stored in KMS. When you use KMS to encrypt your data, you
     * can either use the default Amazon Web Services managed KMS key for Amazon ECR, or specify your own KMS key, which
     * you already created. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting data using server-side
     * encryption with an KMS key stored in Key Management Service (SSE-KMS)</a> in the <i>Amazon Simple Storage Service
     * Console Developer Guide</i>.
     * </p>
     * <p>
     * If you use the <code>AES256</code> encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed
     * encryption keys which encrypts the images in the repository using an AES256 encryption algorithm. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Protecting data using
     * server-side encryption with Amazon S3-managed encryption keys (SSE-S3)</a> in the <i>Amazon Simple Storage
     * Service Console Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The encryption type to use.</p>
     *         <p>
     *         If you use the <code>KMS</code> encryption type, the contents of the repository will be encrypted using
     *         server-side encryption with Key Management Service key stored in KMS. When you use KMS to encrypt your
     *         data, you can either use the default Amazon Web Services managed KMS key for Amazon ECR, or specify your
     *         own KMS key, which you already created. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting data using
     *         server-side encryption with an KMS key stored in Key Management Service (SSE-KMS)</a> in the <i>Amazon
     *         Simple Storage Service Console Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you use the <code>AES256</code> encryption type, Amazon ECR uses server-side encryption with Amazon
     *         S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption
     *         algorithm. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Protecting data
     *         using server-side encryption with Amazon S3-managed encryption keys (SSE-S3)</a> in the <i>Amazon Simple
     *         Storage Service Console Developer Guide</i>.
     * @see EncryptionType
     */
    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(encryptionType);
    }

    /**
     * <p>
     * The encryption type to use.
     * </p>
     * <p>
     * If you use the <code>KMS</code> encryption type, the contents of the repository will be encrypted using
     * server-side encryption with Key Management Service key stored in KMS. When you use KMS to encrypt your data, you
     * can either use the default Amazon Web Services managed KMS key for Amazon ECR, or specify your own KMS key, which
     * you already created. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting data using server-side
     * encryption with an KMS key stored in Key Management Service (SSE-KMS)</a> in the <i>Amazon Simple Storage Service
     * Console Developer Guide</i>.
     * </p>
     * <p>
     * If you use the <code>AES256</code> encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed
     * encryption keys which encrypts the images in the repository using an AES256 encryption algorithm. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Protecting data using
     * server-side encryption with Amazon S3-managed encryption keys (SSE-S3)</a> in the <i>Amazon Simple Storage
     * Service Console Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The encryption type to use.</p>
     *         <p>
     *         If you use the <code>KMS</code> encryption type, the contents of the repository will be encrypted using
     *         server-side encryption with Key Management Service key stored in KMS. When you use KMS to encrypt your
     *         data, you can either use the default Amazon Web Services managed KMS key for Amazon ECR, or specify your
     *         own KMS key, which you already created. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting data using
     *         server-side encryption with an KMS key stored in Key Management Service (SSE-KMS)</a> in the <i>Amazon
     *         Simple Storage Service Console Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you use the <code>AES256</code> encryption type, Amazon ECR uses server-side encryption with Amazon
     *         S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption
     *         algorithm. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Protecting data
     *         using server-side encryption with Amazon S3-managed encryption keys (SSE-S3)</a> in the <i>Amazon Simple
     *         Storage Service Console Developer Guide</i>.
     * @see EncryptionType
     */
    public final String encryptionTypeAsString() {
        return encryptionType;
    }

    /**
     * <p>
     * If you use the <code>KMS</code> encryption type, specify the KMS key to use for encryption. The full ARN of the
     * KMS key must be specified. The key must exist in the same Region as the repository. If no key is specified, the
     * default Amazon Web Services managed KMS key for Amazon ECR will be used.
     * </p>
     * 
     * @return If you use the <code>KMS</code> encryption type, specify the KMS key to use for encryption. The full ARN
     *         of the KMS key must be specified. The key must exist in the same Region as the repository. If no key is
     *         specified, the default Amazon Web Services managed KMS key for Amazon ECR will be used.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfigurationForRepositoryCreationTemplate)) {
            return false;
        }
        EncryptionConfigurationForRepositoryCreationTemplate other = (EncryptionConfigurationForRepositoryCreationTemplate) obj;
        return Objects.equals(encryptionTypeAsString(), other.encryptionTypeAsString())
                && Objects.equals(kmsKey(), other.kmsKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionConfigurationForRepositoryCreationTemplate")
                .add("EncryptionType", encryptionTypeAsString()).add("KmsKey", kmsKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encryptionType":
            return Optional.ofNullable(clazz.cast(encryptionTypeAsString()));
        case "kmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfigurationForRepositoryCreationTemplate, T> g) {
        return obj -> g.apply((EncryptionConfigurationForRepositoryCreationTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionConfigurationForRepositoryCreationTemplate> {
        /**
         * <p>
         * The encryption type to use.
         * </p>
         * <p>
         * If you use the <code>KMS</code> encryption type, the contents of the repository will be encrypted using
         * server-side encryption with Key Management Service key stored in KMS. When you use KMS to encrypt your data,
         * you can either use the default Amazon Web Services managed KMS key for Amazon ECR, or specify your own KMS
         * key, which you already created. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting data using
         * server-side encryption with an KMS key stored in Key Management Service (SSE-KMS)</a> in the <i>Amazon Simple
         * Storage Service Console Developer Guide</i>.
         * </p>
         * <p>
         * If you use the <code>AES256</code> encryption type, Amazon ECR uses server-side encryption with Amazon
         * S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Protecting data using
         * server-side encryption with Amazon S3-managed encryption keys (SSE-S3)</a> in the <i>Amazon Simple Storage
         * Service Console Developer Guide</i>.
         * </p>
         * 
         * @param encryptionType
         *        The encryption type to use.</p>
         *        <p>
         *        If you use the <code>KMS</code> encryption type, the contents of the repository will be encrypted
         *        using server-side encryption with Key Management Service key stored in KMS. When you use KMS to
         *        encrypt your data, you can either use the default Amazon Web Services managed KMS key for Amazon ECR,
         *        or specify your own KMS key, which you already created. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting data using
         *        server-side encryption with an KMS key stored in Key Management Service (SSE-KMS)</a> in the <i>Amazon
         *        Simple Storage Service Console Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you use the <code>AES256</code> encryption type, Amazon ECR uses server-side encryption with Amazon
         *        S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption
         *        algorithm. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Protecting data
         *        using server-side encryption with Amazon S3-managed encryption keys (SSE-S3)</a> in the <i>Amazon
         *        Simple Storage Service Console Developer Guide</i>.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * The encryption type to use.
         * </p>
         * <p>
         * If you use the <code>KMS</code> encryption type, the contents of the repository will be encrypted using
         * server-side encryption with Key Management Service key stored in KMS. When you use KMS to encrypt your data,
         * you can either use the default Amazon Web Services managed KMS key for Amazon ECR, or specify your own KMS
         * key, which you already created. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting data using
         * server-side encryption with an KMS key stored in Key Management Service (SSE-KMS)</a> in the <i>Amazon Simple
         * Storage Service Console Developer Guide</i>.
         * </p>
         * <p>
         * If you use the <code>AES256</code> encryption type, Amazon ECR uses server-side encryption with Amazon
         * S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Protecting data using
         * server-side encryption with Amazon S3-managed encryption keys (SSE-S3)</a> in the <i>Amazon Simple Storage
         * Service Console Developer Guide</i>.
         * </p>
         * 
         * @param encryptionType
         *        The encryption type to use.</p>
         *        <p>
         *        If you use the <code>KMS</code> encryption type, the contents of the repository will be encrypted
         *        using server-side encryption with Key Management Service key stored in KMS. When you use KMS to
         *        encrypt your data, you can either use the default Amazon Web Services managed KMS key for Amazon ECR,
         *        or specify your own KMS key, which you already created. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Protecting data using
         *        server-side encryption with an KMS key stored in Key Management Service (SSE-KMS)</a> in the <i>Amazon
         *        Simple Storage Service Console Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you use the <code>AES256</code> encryption type, Amazon ECR uses server-side encryption with Amazon
         *        S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption
         *        algorithm. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">Protecting data
         *        using server-side encryption with Amazon S3-managed encryption keys (SSE-S3)</a> in the <i>Amazon
         *        Simple Storage Service Console Developer Guide</i>.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(EncryptionType encryptionType);

        /**
         * <p>
         * If you use the <code>KMS</code> encryption type, specify the KMS key to use for encryption. The full ARN of
         * the KMS key must be specified. The key must exist in the same Region as the repository. If no key is
         * specified, the default Amazon Web Services managed KMS key for Amazon ECR will be used.
         * </p>
         * 
         * @param kmsKey
         *        If you use the <code>KMS</code> encryption type, specify the KMS key to use for encryption. The full
         *        ARN of the KMS key must be specified. The key must exist in the same Region as the repository. If no
         *        key is specified, the default Amazon Web Services managed KMS key for Amazon ECR will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);
    }

    static final class BuilderImpl implements Builder {
        private String encryptionType;

        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfigurationForRepositoryCreationTemplate model) {
            encryptionType(model.encryptionType);
            kmsKey(model.kmsKey);
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        @Override
        public EncryptionConfigurationForRepositoryCreationTemplate build() {
            return new EncryptionConfigurationForRepositoryCreationTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
