/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRepositoryRequest extends EcrRequest implements
        ToCopyableBuilder<CreateRepositoryRequest.Builder, CreateRepositoryRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(CreateRepositoryRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(CreateRepositoryRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateRepositoryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMAGE_TAG_MUTABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageTagMutability").getter(getter(CreateRepositoryRequest::imageTagMutabilityAsString))
            .setter(setter(Builder::imageTagMutability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTagMutability").build())
            .build();

    private static final SdkField<ImageScanningConfiguration> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField
            .<ImageScanningConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("imageScanningConfiguration")
            .getter(getter(CreateRepositoryRequest::imageScanningConfiguration))
            .setter(setter(Builder::imageScanningConfiguration))
            .constructor(ImageScanningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningConfiguration").build())
            .build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(CreateRepositoryRequest::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, TAGS_FIELD, IMAGE_TAG_MUTABILITY_FIELD, IMAGE_SCANNING_CONFIGURATION_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final List<Tag> tags;

    private final String imageTagMutability;

    private final ImageScanningConfiguration imageScanningConfiguration;

    private final EncryptionConfiguration encryptionConfiguration;

    private CreateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.tags = builder.tags;
        this.imageTagMutability = builder.imageTagMutability;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry to create the repository. If you do not specify a
     * registry, the default registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry to create the repository. If you do not
     *         specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name to use for the repository. The repository name may be specified on its own (such as
     * <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a category (such
     * as <code>project-a/nginx-web-app</code>).
     * </p>
     * <p>
     * The repository name must start with a letter and can only contain lowercase letters, numbers, hyphens,
     * underscores, and forward slashes.
     * </p>
     * 
     * @return The name to use for the repository. The repository name may be specified on its own (such as
     *         <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a
     *         category (such as <code>project-a/nginx-web-app</code>).</p>
     *         <p>
     *         The repository name must start with a letter and can only contain lowercase letters, numbers, hyphens,
     *         underscores, and forward slashes.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of a
     * key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
     * characters, and tag values can have a maximum length of 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata that you apply to the repository to help you categorize and organize them. Each tag consists
     *         of a key and an optional value, both of which you define. Tag keys can have a maximum character length of
     *         128 characters, and tag values can have a maximum length of 256 characters.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The tag mutability setting for the repository. If this parameter is omitted, the default setting of
     * <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is
     * specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageTagMutability} will return {@link ImageTagMutability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageTagMutabilityAsString}.
     * </p>
     * 
     * @return The tag mutability setting for the repository. If this parameter is omitted, the default setting of
     *         <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If
     *         <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will
     *         prevent them from being overwritten.
     * @see ImageTagMutability
     */
    public final ImageTagMutability imageTagMutability() {
        return ImageTagMutability.fromValue(imageTagMutability);
    }

    /**
     * <p>
     * The tag mutability setting for the repository. If this parameter is omitted, the default setting of
     * <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is
     * specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageTagMutability} will return {@link ImageTagMutability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageTagMutabilityAsString}.
     * </p>
     * 
     * @return The tag mutability setting for the repository. If this parameter is omitted, the default setting of
     *         <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If
     *         <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will
     *         prevent them from being overwritten.
     * @see ImageTagMutability
     */
    public final String imageTagMutabilityAsString() {
        return imageTagMutability;
    }

    /**
     * <p>
     * The image scanning configuration for the repository. This determines whether images are scanned for known
     * vulnerabilities after being pushed to the repository.
     * </p>
     * 
     * @return The image scanning configuration for the repository. This determines whether images are scanned for known
     *         vulnerabilities after being pushed to the repository.
     */
    public final ImageScanningConfiguration imageScanningConfiguration() {
        return imageScanningConfiguration;
    }

    /**
     * <p>
     * The encryption configuration for the repository. This determines how the contents of your repository are
     * encrypted at rest.
     * </p>
     * 
     * @return The encryption configuration for the repository. This determines how the contents of your repository are
     *         encrypted at rest.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageTagMutabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageScanningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryRequest)) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(imageTagMutabilityAsString(), other.imageTagMutabilityAsString())
                && Objects.equals(imageScanningConfiguration(), other.imageScanningConfiguration())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRepositoryRequest").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("Tags", hasTags() ? tags() : null)
                .add("ImageTagMutability", imageTagMutabilityAsString())
                .add("ImageScanningConfiguration", imageScanningConfiguration())
                .add("EncryptionConfiguration", encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "imageTagMutability":
            return Optional.ofNullable(clazz.cast(imageTagMutabilityAsString()));
        case "imageScanningConfiguration":
            return Optional.ofNullable(clazz.cast(imageScanningConfiguration()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRepositoryRequest, T> g) {
        return obj -> g.apply((CreateRepositoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRepositoryRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry to create the repository. If you do not
         * specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry to create the repository. If you do
         *        not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name to use for the repository. The repository name may be specified on its own (such as
         * <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a category
         * (such as <code>project-a/nginx-web-app</code>).
         * </p>
         * <p>
         * The repository name must start with a letter and can only contain lowercase letters, numbers, hyphens,
         * underscores, and forward slashes.
         * </p>
         * 
         * @param repositoryName
         *        The name to use for the repository. The repository name may be specified on its own (such as
         *        <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a
         *        category (such as <code>project-a/nginx-web-app</code>).</p>
         *        <p>
         *        The repository name must start with a letter and can only contain lowercase letters, numbers, hyphens,
         *        underscores, and forward slashes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of
         * a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
         * characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to the repository to help you categorize and organize them. Each tag
         *        consists of a key and an optional value, both of which you define. Tag keys can have a maximum
         *        character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of
         * a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
         * characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to the repository to help you categorize and organize them. Each tag
         *        consists of a key and an optional value, both of which you define. Tag keys can have a maximum
         *        character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of
         * a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
         * characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ecr.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ecr.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecr.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The tag mutability setting for the repository. If this parameter is omitted, the default setting of
         * <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is
         * specified, all image tags within the repository will be immutable which will prevent them from being
         * overwritten.
         * </p>
         * 
         * @param imageTagMutability
         *        The tag mutability setting for the repository. If this parameter is omitted, the default setting of
         *        <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If
         *        <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will
         *        prevent them from being overwritten.
         * @see ImageTagMutability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutability
         */
        Builder imageTagMutability(String imageTagMutability);

        /**
         * <p>
         * The tag mutability setting for the repository. If this parameter is omitted, the default setting of
         * <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is
         * specified, all image tags within the repository will be immutable which will prevent them from being
         * overwritten.
         * </p>
         * 
         * @param imageTagMutability
         *        The tag mutability setting for the repository. If this parameter is omitted, the default setting of
         *        <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If
         *        <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will
         *        prevent them from being overwritten.
         * @see ImageTagMutability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutability
         */
        Builder imageTagMutability(ImageTagMutability imageTagMutability);

        /**
         * <p>
         * The image scanning configuration for the repository. This determines whether images are scanned for known
         * vulnerabilities after being pushed to the repository.
         * </p>
         * 
         * @param imageScanningConfiguration
         *        The image scanning configuration for the repository. This determines whether images are scanned for
         *        known vulnerabilities after being pushed to the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration);

        /**
         * <p>
         * The image scanning configuration for the repository. This determines whether images are scanned for known
         * vulnerabilities after being pushed to the repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageScanningConfiguration.Builder}
         * avoiding the need to create one manually via {@link ImageScanningConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageScanningConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #imageScanningConfiguration(ImageScanningConfiguration)}.
         * 
         * @param imageScanningConfiguration
         *        a consumer that will call methods on {@link ImageScanningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageScanningConfiguration(ImageScanningConfiguration)
         */
        default Builder imageScanningConfiguration(Consumer<ImageScanningConfiguration.Builder> imageScanningConfiguration) {
            return imageScanningConfiguration(ImageScanningConfiguration.builder().applyMutation(imageScanningConfiguration)
                    .build());
        }

        /**
         * <p>
         * The encryption configuration for the repository. This determines how the contents of your repository are
         * encrypted at rest.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption configuration for the repository. This determines how the contents of your repository
         *        are encrypted at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The encryption configuration for the repository. This determines how the contents of your repository are
         * encrypted at rest.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String imageTagMutability;

        private ImageScanningConfiguration imageScanningConfiguration;

        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            tags(model.tags);
            imageTagMutability(model.imageTagMutability);
            imageScanningConfiguration(model.imageScanningConfiguration);
            encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImageTagMutability() {
            return imageTagMutability;
        }

        public final void setImageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
        }

        @Override
        public final Builder imageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        @Override
        public final Builder imageTagMutability(ImageTagMutability imageTagMutability) {
            this.imageTagMutability(imageTagMutability == null ? null : imageTagMutability.toString());
            return this;
        }

        public final ImageScanningConfiguration.Builder getImageScanningConfiguration() {
            return imageScanningConfiguration != null ? imageScanningConfiguration.toBuilder() : null;
        }

        public final void setImageScanningConfiguration(ImageScanningConfiguration.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        public final Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRepositoryRequest build() {
            return new CreateRepositoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
