/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the last completed image scan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageScanFindingsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageScanFindingsSummary.Builder, ImageScanFindingsSummary> {
    private static final SdkField<Instant> IMAGE_SCAN_COMPLETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("imageScanCompletedAt").getter(getter(ImageScanFindingsSummary::imageScanCompletedAt))
            .setter(setter(Builder::imageScanCompletedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanCompletedAt").build())
            .build();

    private static final SdkField<Instant> VULNERABILITY_SOURCE_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("vulnerabilitySourceUpdatedAt")
            .getter(getter(ImageScanFindingsSummary::vulnerabilitySourceUpdatedAt))
            .setter(setter(Builder::vulnerabilitySourceUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilitySourceUpdatedAt")
                    .build()).build();

    private static final SdkField<Map<String, Integer>> FINDING_SEVERITY_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("findingSeverityCounts")
            .getter(getter(ImageScanFindingsSummary::findingSeverityCountsAsStrings))
            .setter(setter(Builder::findingSeverityCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingSeverityCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SCAN_COMPLETED_AT_FIELD,
            VULNERABILITY_SOURCE_UPDATED_AT_FIELD, FINDING_SEVERITY_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("imageScanCompletedAt", IMAGE_SCAN_COMPLETED_AT_FIELD);
                    put("vulnerabilitySourceUpdatedAt", VULNERABILITY_SOURCE_UPDATED_AT_FIELD);
                    put("findingSeverityCounts", FINDING_SEVERITY_COUNTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant imageScanCompletedAt;

    private final Instant vulnerabilitySourceUpdatedAt;

    private final Map<String, Integer> findingSeverityCounts;

    private ImageScanFindingsSummary(BuilderImpl builder) {
        this.imageScanCompletedAt = builder.imageScanCompletedAt;
        this.vulnerabilitySourceUpdatedAt = builder.vulnerabilitySourceUpdatedAt;
        this.findingSeverityCounts = builder.findingSeverityCounts;
    }

    /**
     * <p>
     * The time of the last completed image scan.
     * </p>
     * 
     * @return The time of the last completed image scan.
     */
    public final Instant imageScanCompletedAt() {
        return imageScanCompletedAt;
    }

    /**
     * <p>
     * The time when the vulnerability data was last scanned.
     * </p>
     * 
     * @return The time when the vulnerability data was last scanned.
     */
    public final Instant vulnerabilitySourceUpdatedAt() {
        return vulnerabilitySourceUpdatedAt;
    }

    /**
     * <p>
     * The image vulnerability counts, sorted by severity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingSeverityCounts} method.
     * </p>
     * 
     * @return The image vulnerability counts, sorted by severity.
     */
    public final Map<FindingSeverity, Integer> findingSeverityCounts() {
        return FindingSeverityCountsCopier.copyStringToEnum(findingSeverityCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingSeverityCounts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFindingSeverityCounts() {
        return findingSeverityCounts != null && !(findingSeverityCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The image vulnerability counts, sorted by severity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingSeverityCounts} method.
     * </p>
     * 
     * @return The image vulnerability counts, sorted by severity.
     */
    public final Map<String, Integer> findingSeverityCountsAsStrings() {
        return findingSeverityCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageScanCompletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(vulnerabilitySourceUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingSeverityCounts() ? findingSeverityCountsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanFindingsSummary)) {
            return false;
        }
        ImageScanFindingsSummary other = (ImageScanFindingsSummary) obj;
        return Objects.equals(imageScanCompletedAt(), other.imageScanCompletedAt())
                && Objects.equals(vulnerabilitySourceUpdatedAt(), other.vulnerabilitySourceUpdatedAt())
                && hasFindingSeverityCounts() == other.hasFindingSeverityCounts()
                && Objects.equals(findingSeverityCountsAsStrings(), other.findingSeverityCountsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageScanFindingsSummary").add("ImageScanCompletedAt", imageScanCompletedAt())
                .add("VulnerabilitySourceUpdatedAt", vulnerabilitySourceUpdatedAt())
                .add("FindingSeverityCounts", hasFindingSeverityCounts() ? findingSeverityCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageScanCompletedAt":
            return Optional.ofNullable(clazz.cast(imageScanCompletedAt()));
        case "vulnerabilitySourceUpdatedAt":
            return Optional.ofNullable(clazz.cast(vulnerabilitySourceUpdatedAt()));
        case "findingSeverityCounts":
            return Optional.ofNullable(clazz.cast(findingSeverityCountsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImageScanFindingsSummary, T> g) {
        return obj -> g.apply((ImageScanFindingsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageScanFindingsSummary> {
        /**
         * <p>
         * The time of the last completed image scan.
         * </p>
         * 
         * @param imageScanCompletedAt
         *        The time of the last completed image scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanCompletedAt(Instant imageScanCompletedAt);

        /**
         * <p>
         * The time when the vulnerability data was last scanned.
         * </p>
         * 
         * @param vulnerabilitySourceUpdatedAt
         *        The time when the vulnerability data was last scanned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilitySourceUpdatedAt(Instant vulnerabilitySourceUpdatedAt);

        /**
         * <p>
         * The image vulnerability counts, sorted by severity.
         * </p>
         * 
         * @param findingSeverityCounts
         *        The image vulnerability counts, sorted by severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingSeverityCountsWithStrings(Map<String, Integer> findingSeverityCounts);

        /**
         * <p>
         * The image vulnerability counts, sorted by severity.
         * </p>
         * 
         * @param findingSeverityCounts
         *        The image vulnerability counts, sorted by severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingSeverityCounts(Map<FindingSeverity, Integer> findingSeverityCounts);
    }

    static final class BuilderImpl implements Builder {
        private Instant imageScanCompletedAt;

        private Instant vulnerabilitySourceUpdatedAt;

        private Map<String, Integer> findingSeverityCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageScanFindingsSummary model) {
            imageScanCompletedAt(model.imageScanCompletedAt);
            vulnerabilitySourceUpdatedAt(model.vulnerabilitySourceUpdatedAt);
            findingSeverityCountsWithStrings(model.findingSeverityCounts);
        }

        public final Instant getImageScanCompletedAt() {
            return imageScanCompletedAt;
        }

        public final void setImageScanCompletedAt(Instant imageScanCompletedAt) {
            this.imageScanCompletedAt = imageScanCompletedAt;
        }

        @Override
        public final Builder imageScanCompletedAt(Instant imageScanCompletedAt) {
            this.imageScanCompletedAt = imageScanCompletedAt;
            return this;
        }

        public final Instant getVulnerabilitySourceUpdatedAt() {
            return vulnerabilitySourceUpdatedAt;
        }

        public final void setVulnerabilitySourceUpdatedAt(Instant vulnerabilitySourceUpdatedAt) {
            this.vulnerabilitySourceUpdatedAt = vulnerabilitySourceUpdatedAt;
        }

        @Override
        public final Builder vulnerabilitySourceUpdatedAt(Instant vulnerabilitySourceUpdatedAt) {
            this.vulnerabilitySourceUpdatedAt = vulnerabilitySourceUpdatedAt;
            return this;
        }

        public final Map<String, Integer> getFindingSeverityCounts() {
            if (findingSeverityCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return findingSeverityCounts;
        }

        public final void setFindingSeverityCounts(Map<String, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copy(findingSeverityCounts);
        }

        @Override
        public final Builder findingSeverityCountsWithStrings(Map<String, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copy(findingSeverityCounts);
            return this;
        }

        @Override
        public final Builder findingSeverityCounts(Map<FindingSeverity, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copyEnumToString(findingSeverityCounts);
            return this;
        }

        @Override
        public ImageScanFindingsSummary build() {
            return new ImageScanFindingsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
