/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of objects representing the replication destinations and repository filters for a replication configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationRule implements SdkPojo, Serializable, ToCopyableBuilder<ReplicationRule.Builder, ReplicationRule> {
    private static final SdkField<List<ReplicationDestination>> DESTINATIONS_FIELD = SdkField
            .<List<ReplicationDestination>> builder(MarshallingType.LIST)
            .memberName("destinations")
            .getter(getter(ReplicationRule::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RepositoryFilter>> REPOSITORY_FILTERS_FIELD = SdkField
            .<List<RepositoryFilter>> builder(MarshallingType.LIST)
            .memberName("repositoryFilters")
            .getter(getter(ReplicationRule::repositoryFilters))
            .setter(setter(Builder::repositoryFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD,
            REPOSITORY_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("destinations", DESTINATIONS_FIELD);
                    put("repositoryFilters", REPOSITORY_FILTERS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<ReplicationDestination> destinations;

    private final List<RepositoryFilter> repositoryFilters;

    private ReplicationRule(BuilderImpl builder) {
        this.destinations = builder.destinations;
        this.repositoryFilters = builder.repositoryFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects representing the destination for a replication rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return An array of objects representing the destination for a replication rule.
     */
    public final List<ReplicationDestination> destinations() {
        return destinations;
    }

    /**
     * For responses, this returns true if the service returned a value for the RepositoryFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepositoryFilters() {
        return repositoryFilters != null && !(repositoryFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects representing the filters for a replication rule. Specifying a repository filter for a
     * replication rule provides a method for controlling which repositories in a private registry are replicated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositoryFilters} method.
     * </p>
     * 
     * @return An array of objects representing the filters for a replication rule. Specifying a repository filter for a
     *         replication rule provides a method for controlling which repositories in a private registry are
     *         replicated.
     */
    public final List<RepositoryFilter> repositoryFilters() {
        return repositoryFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositoryFilters() ? repositoryFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRule)) {
            return false;
        }
        ReplicationRule other = (ReplicationRule) obj;
        return hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations())
                && hasRepositoryFilters() == other.hasRepositoryFilters()
                && Objects.equals(repositoryFilters(), other.repositoryFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationRule").add("Destinations", hasDestinations() ? destinations() : null)
                .add("RepositoryFilters", hasRepositoryFilters() ? repositoryFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "repositoryFilters":
            return Optional.ofNullable(clazz.cast(repositoryFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationRule, T> g) {
        return obj -> g.apply((ReplicationRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationRule> {
        /**
         * <p>
         * An array of objects representing the destination for a replication rule.
         * </p>
         * 
         * @param destinations
         *        An array of objects representing the destination for a replication rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<ReplicationDestination> destinations);

        /**
         * <p>
         * An array of objects representing the destination for a replication rule.
         * </p>
         * 
         * @param destinations
         *        An array of objects representing the destination for a replication rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(ReplicationDestination... destinations);

        /**
         * <p>
         * An array of objects representing the destination for a replication rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.ReplicationDestination.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ecr.model.ReplicationDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.ReplicationDestination.Builder#build()} is called
         * immediately and its result is passed to {@link #destinations(List<ReplicationDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.ReplicationDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<ReplicationDestination>)
         */
        Builder destinations(Consumer<ReplicationDestination.Builder>... destinations);

        /**
         * <p>
         * An array of objects representing the filters for a replication rule. Specifying a repository filter for a
         * replication rule provides a method for controlling which repositories in a private registry are replicated.
         * </p>
         * 
         * @param repositoryFilters
         *        An array of objects representing the filters for a replication rule. Specifying a repository filter
         *        for a replication rule provides a method for controlling which repositories in a private registry are
         *        replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryFilters(Collection<RepositoryFilter> repositoryFilters);

        /**
         * <p>
         * An array of objects representing the filters for a replication rule. Specifying a repository filter for a
         * replication rule provides a method for controlling which repositories in a private registry are replicated.
         * </p>
         * 
         * @param repositoryFilters
         *        An array of objects representing the filters for a replication rule. Specifying a repository filter
         *        for a replication rule provides a method for controlling which repositories in a private registry are
         *        replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryFilters(RepositoryFilter... repositoryFilters);

        /**
         * <p>
         * An array of objects representing the filters for a replication rule. Specifying a repository filter for a
         * replication rule provides a method for controlling which repositories in a private registry are replicated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.RepositoryFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecr.model.RepositoryFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.RepositoryFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #repositoryFilters(List<RepositoryFilter>)}.
         * 
         * @param repositoryFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.RepositoryFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryFilters(java.util.Collection<RepositoryFilter>)
         */
        Builder repositoryFilters(Consumer<RepositoryFilter.Builder>... repositoryFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<ReplicationDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private List<RepositoryFilter> repositoryFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRule model) {
            destinations(model.destinations);
            repositoryFilters(model.repositoryFilters);
        }

        public final List<ReplicationDestination.Builder> getDestinations() {
            List<ReplicationDestination.Builder> result = ReplicationDestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<ReplicationDestination.BuilderImpl> destinations) {
            this.destinations = ReplicationDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<ReplicationDestination> destinations) {
            this.destinations = ReplicationDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(ReplicationDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<ReplicationDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> ReplicationDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RepositoryFilter.Builder> getRepositoryFilters() {
            List<RepositoryFilter.Builder> result = RepositoryFilterListCopier.copyToBuilder(this.repositoryFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositoryFilters(Collection<RepositoryFilter.BuilderImpl> repositoryFilters) {
            this.repositoryFilters = RepositoryFilterListCopier.copyFromBuilder(repositoryFilters);
        }

        @Override
        public final Builder repositoryFilters(Collection<RepositoryFilter> repositoryFilters) {
            this.repositoryFilters = RepositoryFilterListCopier.copy(repositoryFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryFilters(RepositoryFilter... repositoryFilters) {
            repositoryFilters(Arrays.asList(repositoryFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryFilters(Consumer<RepositoryFilter.Builder>... repositoryFilters) {
            repositoryFilters(Stream.of(repositoryFilters).map(c -> RepositoryFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReplicationRule build() {
            return new ReplicationRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
