/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePullThroughCacheRuleResponse extends EcrResponse implements
        ToCopyableBuilder<UpdatePullThroughCacheRuleResponse.Builder, UpdatePullThroughCacheRuleResponse> {
    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ecrRepositoryPrefix").getter(getter(UpdatePullThroughCacheRuleResponse::ecrRepositoryPrefix))
            .setter(setter(Builder::ecrRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build())
            .build();

    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(UpdatePullThroughCacheRuleResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(UpdatePullThroughCacheRuleResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialArn").getter(getter(UpdatePullThroughCacheRuleResponse::credentialArn))
            .setter(setter(Builder::credentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_REPOSITORY_PREFIX_FIELD,
            REGISTRY_ID_FIELD, UPDATED_AT_FIELD, CREDENTIAL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ecrRepositoryPrefix", ECR_REPOSITORY_PREFIX_FIELD);
                    put("registryId", REGISTRY_ID_FIELD);
                    put("updatedAt", UPDATED_AT_FIELD);
                    put("credentialArn", CREDENTIAL_ARN_FIELD);
                }
            });

    private final String ecrRepositoryPrefix;

    private final String registryId;

    private final Instant updatedAt;

    private final String credentialArn;

    private UpdatePullThroughCacheRuleResponse(BuilderImpl builder) {
        super(builder);
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.registryId = builder.registryId;
        this.updatedAt = builder.updatedAt;
        this.credentialArn = builder.credentialArn;
    }

    /**
     * <p>
     * The Amazon ECR repository prefix associated with the pull through cache rule.
     * </p>
     * 
     * @return The Amazon ECR repository prefix associated with the pull through cache rule.
     */
    public final String ecrRepositoryPrefix() {
        return ecrRepositoryPrefix;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The date and time, in JavaScript date format, when the pull through cache rule was updated.
     * </p>
     * 
     * @return The date and time, in JavaScript date format, when the pull through cache rule was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the pull through
     * cache rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the pull
     *         through cache rule.
     */
    public final String credentialArn() {
        return credentialArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(credentialArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePullThroughCacheRuleResponse)) {
            return false;
        }
        UpdatePullThroughCacheRuleResponse other = (UpdatePullThroughCacheRuleResponse) obj;
        return Objects.equals(ecrRepositoryPrefix(), other.ecrRepositoryPrefix())
                && Objects.equals(registryId(), other.registryId()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(credentialArn(), other.credentialArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePullThroughCacheRuleResponse").add("EcrRepositoryPrefix", ecrRepositoryPrefix())
                .add("RegistryId", registryId()).add("UpdatedAt", updatedAt()).add("CredentialArn", credentialArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ecrRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(ecrRepositoryPrefix()));
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "credentialArn":
            return Optional.ofNullable(clazz.cast(credentialArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePullThroughCacheRuleResponse, T> g) {
        return obj -> g.apply((UpdatePullThroughCacheRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePullThroughCacheRuleResponse> {
        /**
         * <p>
         * The Amazon ECR repository prefix associated with the pull through cache rule.
         * </p>
         * 
         * @param ecrRepositoryPrefix
         *        The Amazon ECR repository prefix associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryPrefix(String ecrRepositoryPrefix);

        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The date and time, in JavaScript date format, when the pull through cache rule was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time, in JavaScript date format, when the pull through cache rule was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the pull
         * through cache rule.
         * </p>
         * 
         * @param credentialArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the
         *        pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialArn(String credentialArn);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String ecrRepositoryPrefix;

        private String registryId;

        private Instant updatedAt;

        private String credentialArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePullThroughCacheRuleResponse model) {
            super(model);
            ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            registryId(model.registryId);
            updatedAt(model.updatedAt);
            credentialArn(model.credentialArn);
        }

        public final String getEcrRepositoryPrefix() {
            return ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getCredentialArn() {
            return credentialArn;
        }

        public final void setCredentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
        }

        @Override
        public final Builder credentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
            return this;
        }

        @Override
        public UpdatePullThroughCacheRuleResponse build() {
            return new UpdatePullThroughCacheRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
