/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRepositoryCreationTemplatesRequest extends EcrRequest implements
        ToCopyableBuilder<DescribeRepositoryCreationTemplatesRequest.Builder, DescribeRepositoryCreationTemplatesRequest> {
    private static final SdkField<List<String>> PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("prefixes")
            .getter(getter(DescribeRepositoryCreationTemplatesRequest::prefixes))
            .setter(setter(Builder::prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeRepositoryCreationTemplatesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeRepositoryCreationTemplatesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIXES_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("prefixes", PREFIXES_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                    put("maxResults", MAX_RESULTS_FIELD);
                }
            });

    private final List<String> prefixes;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeRepositoryCreationTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.prefixes = builder.prefixes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Prefixes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrefixes() {
        return prefixes != null && !(prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The repository namespace prefixes associated with the repository creation templates to describe. If this value is
     * not specified, all repository creation templates are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrefixes} method.
     * </p>
     * 
     * @return The repository namespace prefixes associated with the repository creation templates to describe. If this
     *         value is not specified, all repository creation templates are returned.
     */
    public final List<String> prefixes() {
        return prefixes;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated
     * <code>DescribeRepositoryCreationTemplates</code> request where <code>maxResults</code> was used and the results
     * exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the
     * <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated
     *         <code>DescribeRepositoryCreationTemplates</code> request where <code>maxResults</code> was used and the
     *         results exceeded the value of that parameter. Pagination continues from the end of the previous results
     *         that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more
     *         results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of repository results returned by <code>DescribeRepositoryCreationTemplatesRequest</code> in
     * paginated output. When this parameter is used, <code>DescribeRepositoryCreationTemplatesRequest</code> only
     * returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
     * The remaining results of the initial request can be seen by sending another
     * <code>DescribeRepositoryCreationTemplatesRequest</code> request with the returned <code>nextToken</code> value.
     * This value can be between 1 and 1000. If this parameter is not used, then
     * <code>DescribeRepositoryCreationTemplatesRequest</code> returns up to 100 results and a <code>nextToken</code>
     * value, if applicable.
     * </p>
     * 
     * @return The maximum number of repository results returned by
     *         <code>DescribeRepositoryCreationTemplatesRequest</code> in paginated output. When this parameter is used,
     *         <code>DescribeRepositoryCreationTemplatesRequest</code> only returns <code>maxResults</code> results in a
     *         single page along with a <code>nextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>DescribeRepositoryCreationTemplatesRequest</code> request
     *         with the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter
     *         is not used, then <code>DescribeRepositoryCreationTemplatesRequest</code> returns up to 100 results and a
     *         <code>nextToken</code> value, if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPrefixes() ? prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRepositoryCreationTemplatesRequest)) {
            return false;
        }
        DescribeRepositoryCreationTemplatesRequest other = (DescribeRepositoryCreationTemplatesRequest) obj;
        return hasPrefixes() == other.hasPrefixes() && Objects.equals(prefixes(), other.prefixes())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRepositoryCreationTemplatesRequest").add("Prefixes", hasPrefixes() ? prefixes() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "prefixes":
            return Optional.ofNullable(clazz.cast(prefixes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRepositoryCreationTemplatesRequest, T> g) {
        return obj -> g.apply((DescribeRepositoryCreationTemplatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRepositoryCreationTemplatesRequest> {
        /**
         * <p>
         * The repository namespace prefixes associated with the repository creation templates to describe. If this
         * value is not specified, all repository creation templates are returned.
         * </p>
         * 
         * @param prefixes
         *        The repository namespace prefixes associated with the repository creation templates to describe. If
         *        this value is not specified, all repository creation templates are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixes(Collection<String> prefixes);

        /**
         * <p>
         * The repository namespace prefixes associated with the repository creation templates to describe. If this
         * value is not specified, all repository creation templates are returned.
         * </p>
         * 
         * @param prefixes
         *        The repository namespace prefixes associated with the repository creation templates to describe. If
         *        this value is not specified, all repository creation templates are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixes(String... prefixes);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated
         * <code>DescribeRepositoryCreationTemplates</code> request where <code>maxResults</code> was used and the
         * results exceeded the value of that parameter. Pagination continues from the end of the previous results that
         * returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to
         * return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>DescribeRepositoryCreationTemplates</code> request where <code>maxResults</code> was used and
         *        the results exceeded the value of that parameter. Pagination continues from the end of the previous
         *        results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are
         *        no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of repository results returned by <code>DescribeRepositoryCreationTemplatesRequest</code>
         * in paginated output. When this parameter is used, <code>DescribeRepositoryCreationTemplatesRequest</code>
         * only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response
         * element. The remaining results of the initial request can be seen by sending another
         * <code>DescribeRepositoryCreationTemplatesRequest</code> request with the returned <code>nextToken</code>
         * value. This value can be between 1 and 1000. If this parameter is not used, then
         * <code>DescribeRepositoryCreationTemplatesRequest</code> returns up to 100 results and a
         * <code>nextToken</code> value, if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of repository results returned by
         *        <code>DescribeRepositoryCreationTemplatesRequest</code> in paginated output. When this parameter is
         *        used, <code>DescribeRepositoryCreationTemplatesRequest</code> only returns <code>maxResults</code>
         *        results in a single page along with a <code>nextToken</code> response element. The remaining results
         *        of the initial request can be seen by sending another
         *        <code>DescribeRepositoryCreationTemplatesRequest</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used,
         *        then <code>DescribeRepositoryCreationTemplatesRequest</code> returns up to 100 results and a
         *        <code>nextToken</code> value, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private List<String> prefixes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRepositoryCreationTemplatesRequest model) {
            super(model);
            prefixes(model.prefixes);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getPrefixes() {
            if (prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return prefixes;
        }

        public final void setPrefixes(Collection<String> prefixes) {
            this.prefixes = PrefixListCopier.copy(prefixes);
        }

        @Override
        public final Builder prefixes(Collection<String> prefixes) {
            this.prefixes = PrefixListCopier.copy(prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixes(String... prefixes) {
            prefixes(Arrays.asList(prefixes));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRepositoryCreationTemplatesRequest build() {
            return new DescribeRepositoryCreationTemplatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
