/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLifecyclePolicyResponse extends EcrResponse implements
        ToCopyableBuilder<GetLifecyclePolicyResponse.Builder, GetLifecyclePolicyResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(GetLifecyclePolicyResponse::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(GetLifecyclePolicyResponse::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> LIFECYCLE_POLICY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecyclePolicyText").getter(getter(GetLifecyclePolicyResponse::lifecyclePolicyText))
            .setter(setter(Builder::lifecyclePolicyText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyText").build())
            .build();

    private static final SdkField<Instant> LAST_EVALUATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastEvaluatedAt").getter(getter(GetLifecyclePolicyResponse::lastEvaluatedAt))
            .setter(setter(Builder::lastEvaluatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastEvaluatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, LIFECYCLE_POLICY_TEXT_FIELD, LAST_EVALUATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("registryId", REGISTRY_ID_FIELD);
                    put("repositoryName", REPOSITORY_NAME_FIELD);
                    put("lifecyclePolicyText", LIFECYCLE_POLICY_TEXT_FIELD);
                    put("lastEvaluatedAt", LAST_EVALUATED_AT_FIELD);
                }
            });

    private final String registryId;

    private final String repositoryName;

    private final String lifecyclePolicyText;

    private final Instant lastEvaluatedAt;

    private GetLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.lifecyclePolicyText = builder.lifecyclePolicyText;
        this.lastEvaluatedAt = builder.lastEvaluatedAt;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The repository name associated with the request.
     * </p>
     * 
     * @return The repository name associated with the request.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The JSON lifecycle policy text.
     * </p>
     * 
     * @return The JSON lifecycle policy text.
     */
    public final String lifecyclePolicyText() {
        return lifecyclePolicyText;
    }

    /**
     * <p>
     * The time stamp of the last time that the lifecycle policy was run.
     * </p>
     * 
     * @return The time stamp of the last time that the lifecycle policy was run.
     */
    public final Instant lastEvaluatedAt() {
        return lastEvaluatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicyText());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePolicyResponse)) {
            return false;
        }
        GetLifecyclePolicyResponse other = (GetLifecyclePolicyResponse) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(lifecyclePolicyText(), other.lifecyclePolicyText())
                && Objects.equals(lastEvaluatedAt(), other.lastEvaluatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLifecyclePolicyResponse").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("LifecyclePolicyText", lifecyclePolicyText())
                .add("LastEvaluatedAt", lastEvaluatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "lifecyclePolicyText":
            return Optional.ofNullable(clazz.cast(lifecyclePolicyText()));
        case "lastEvaluatedAt":
            return Optional.ofNullable(clazz.cast(lastEvaluatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((GetLifecyclePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLifecyclePolicyResponse> {
        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The repository name associated with the request.
         * </p>
         * 
         * @param repositoryName
         *        The repository name associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The JSON lifecycle policy text.
         * </p>
         * 
         * @param lifecyclePolicyText
         *        The JSON lifecycle policy text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyText(String lifecyclePolicyText);

        /**
         * <p>
         * The time stamp of the last time that the lifecycle policy was run.
         * </p>
         * 
         * @param lastEvaluatedAt
         *        The time stamp of the last time that the lifecycle policy was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedAt(Instant lastEvaluatedAt);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String lifecyclePolicyText;

        private Instant lastEvaluatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePolicyResponse model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            lifecyclePolicyText(model.lifecyclePolicyText);
            lastEvaluatedAt(model.lastEvaluatedAt);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getLifecyclePolicyText() {
            return lifecyclePolicyText;
        }

        public final void setLifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
        }

        @Override
        public final Builder lifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
            return this;
        }

        public final Instant getLastEvaluatedAt() {
            return lastEvaluatedAt;
        }

        public final void setLastEvaluatedAt(Instant lastEvaluatedAt) {
            this.lastEvaluatedAt = lastEvaluatedAt;
        }

        @Override
        public final Builder lastEvaluatedAt(Instant lastEvaluatedAt) {
            this.lastEvaluatedAt = lastEvaluatedAt;
            return this;
        }

        @Override
        public GetLifecyclePolicyResponse build() {
            return new GetLifecyclePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
