/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutImageScanningConfigurationResponse extends EcrResponse implements
        ToCopyableBuilder<PutImageScanningConfigurationResponse.Builder, PutImageScanningConfigurationResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(PutImageScanningConfigurationResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(PutImageScanningConfigurationResponse::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<ImageScanningConfiguration> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField
            .<ImageScanningConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("imageScanningConfiguration")
            .getter(getter(PutImageScanningConfigurationResponse::imageScanningConfiguration))
            .setter(setter(Builder::imageScanningConfiguration))
            .constructor(ImageScanningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, IMAGE_SCANNING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("registryId", REGISTRY_ID_FIELD);
                    put("repositoryName", REPOSITORY_NAME_FIELD);
                    put("imageScanningConfiguration", IMAGE_SCANNING_CONFIGURATION_FIELD);
                }
            });

    private final String registryId;

    private final String repositoryName;

    private final ImageScanningConfiguration imageScanningConfiguration;

    private PutImageScanningConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The repository name associated with the request.
     * </p>
     * 
     * @return The repository name associated with the request.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The image scanning configuration setting for the repository.
     * </p>
     * 
     * @return The image scanning configuration setting for the repository.
     */
    public final ImageScanningConfiguration imageScanningConfiguration() {
        return imageScanningConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(imageScanningConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutImageScanningConfigurationResponse)) {
            return false;
        }
        PutImageScanningConfigurationResponse other = (PutImageScanningConfigurationResponse) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(imageScanningConfiguration(), other.imageScanningConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutImageScanningConfigurationResponse").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("ImageScanningConfiguration", imageScanningConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageScanningConfiguration":
            return Optional.ofNullable(clazz.cast(imageScanningConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutImageScanningConfigurationResponse, T> g) {
        return obj -> g.apply((PutImageScanningConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutImageScanningConfigurationResponse> {
        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The repository name associated with the request.
         * </p>
         * 
         * @param repositoryName
         *        The repository name associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The image scanning configuration setting for the repository.
         * </p>
         * 
         * @param imageScanningConfiguration
         *        The image scanning configuration setting for the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration);

        /**
         * <p>
         * The image scanning configuration setting for the repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageScanningConfiguration.Builder}
         * avoiding the need to create one manually via {@link ImageScanningConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageScanningConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #imageScanningConfiguration(ImageScanningConfiguration)}.
         * 
         * @param imageScanningConfiguration
         *        a consumer that will call methods on {@link ImageScanningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageScanningConfiguration(ImageScanningConfiguration)
         */
        default Builder imageScanningConfiguration(Consumer<ImageScanningConfiguration.Builder> imageScanningConfiguration) {
            return imageScanningConfiguration(ImageScanningConfiguration.builder().applyMutation(imageScanningConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private ImageScanningConfiguration imageScanningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutImageScanningConfigurationResponse model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            imageScanningConfiguration(model.imageScanningConfiguration);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageScanningConfiguration.Builder getImageScanningConfiguration() {
            return imageScanningConfiguration != null ? imageScanningConfiguration.toBuilder() : null;
        }

        public final void setImageScanningConfiguration(ImageScanningConfiguration.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        public final Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        @Override
        public PutImageScanningConfigurationResponse build() {
            return new PutImageScanningConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
