/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCheckLayerAvailabilityResponse extends EcrResponse implements
        ToCopyableBuilder<BatchCheckLayerAvailabilityResponse.Builder, BatchCheckLayerAvailabilityResponse> {
    private static final SdkField<List<Layer>> LAYERS_FIELD = SdkField
            .<List<Layer>> builder(MarshallingType.LIST)
            .memberName("layers")
            .getter(getter(BatchCheckLayerAvailabilityResponse::layers))
            .setter(setter(Builder::layers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Layer> builder(MarshallingType.SDK_POJO)
                                            .constructor(Layer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LayerFailure>> FAILURES_FIELD = SdkField
            .<List<LayerFailure>> builder(MarshallingType.LIST)
            .memberName("failures")
            .getter(getter(BatchCheckLayerAvailabilityResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LayerFailure> builder(MarshallingType.SDK_POJO)
                                            .constructor(LayerFailure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYERS_FIELD, FAILURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("layers", LAYERS_FIELD);
                    put("failures", FAILURES_FIELD);
                }
            });

    private final List<Layer> layers;

    private final List<LayerFailure> failures;

    private BatchCheckLayerAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.layers = builder.layers;
        this.failures = builder.failures;
    }

    /**
     * For responses, this returns true if the service returned a value for the Layers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLayers() {
        return layers != null && !(layers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of image layer objects corresponding to the image layer references in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLayers} method.
     * </p>
     * 
     * @return A list of image layer objects corresponding to the image layer references in the request.
     */
    public final List<Layer> layers() {
        return layers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any failures associated with the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailures} method.
     * </p>
     * 
     * @return Any failures associated with the call.
     */
    public final List<LayerFailure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLayers() ? layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCheckLayerAvailabilityResponse)) {
            return false;
        }
        BatchCheckLayerAvailabilityResponse other = (BatchCheckLayerAvailabilityResponse) obj;
        return hasLayers() == other.hasLayers() && Objects.equals(layers(), other.layers())
                && hasFailures() == other.hasFailures() && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCheckLayerAvailabilityResponse").add("Layers", hasLayers() ? layers() : null)
                .add("Failures", hasFailures() ? failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "layers":
            return Optional.ofNullable(clazz.cast(layers()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchCheckLayerAvailabilityResponse, T> g) {
        return obj -> g.apply((BatchCheckLayerAvailabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchCheckLayerAvailabilityResponse> {
        /**
         * <p>
         * A list of image layer objects corresponding to the image layer references in the request.
         * </p>
         * 
         * @param layers
         *        A list of image layer objects corresponding to the image layer references in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<Layer> layers);

        /**
         * <p>
         * A list of image layer objects corresponding to the image layer references in the request.
         * </p>
         * 
         * @param layers
         *        A list of image layer objects corresponding to the image layer references in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Layer... layers);

        /**
         * <p>
         * A list of image layer objects corresponding to the image layer references in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.Layer.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ecr.model.Layer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ecr.model.Layer.Builder#build()}
         * is called immediately and its result is passed to {@link #layers(List<Layer>)}.
         * 
         * @param layers
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecr.model.Layer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layers(java.util.Collection<Layer>)
         */
        Builder layers(Consumer<Layer.Builder>... layers);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<LayerFailure> failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(LayerFailure... failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.LayerFailure.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecr.model.LayerFailure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.LayerFailure.Builder#build()} is called immediately and its
         * result is passed to {@link #failures(List<LayerFailure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.LayerFailure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(java.util.Collection<LayerFailure>)
         */
        Builder failures(Consumer<LayerFailure.Builder>... failures);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private List<Layer> layers = DefaultSdkAutoConstructList.getInstance();

        private List<LayerFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCheckLayerAvailabilityResponse model) {
            super(model);
            layers(model.layers);
            failures(model.failures);
        }

        public final List<Layer.Builder> getLayers() {
            List<Layer.Builder> result = LayerListCopier.copyToBuilder(this.layers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayerListCopier.copyFromBuilder(layers);
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<Layer.Builder>... layers) {
            layers(Stream.of(layers).map(c -> Layer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LayerFailure.Builder> getFailures() {
            List<LayerFailure.Builder> result = LayerFailureListCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<LayerFailure.BuilderImpl> failures) {
            this.failures = LayerFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<LayerFailure> failures) {
            this.failures = LayerFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(LayerFailure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<LayerFailure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> LayerFailure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCheckLayerAvailabilityResponse build() {
            return new BatchCheckLayerAvailabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
