/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the CVSS score.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CvssScoreDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CvssScoreDetails.Builder, CvssScoreDetails> {
    private static final SdkField<List<CvssScoreAdjustment>> ADJUSTMENTS_FIELD = SdkField
            .<List<CvssScoreAdjustment>> builder(MarshallingType.LIST)
            .memberName("adjustments")
            .getter(getter(CvssScoreDetails::adjustments))
            .setter(setter(Builder::adjustments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adjustments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CvssScoreAdjustment> builder(MarshallingType.SDK_POJO)
                                            .constructor(CvssScoreAdjustment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("score")
            .getter(getter(CvssScoreDetails::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()).build();

    private static final SdkField<String> SCORE_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scoreSource").getter(getter(CvssScoreDetails::scoreSource)).setter(setter(Builder::scoreSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoreSource").build()).build();

    private static final SdkField<String> SCORING_VECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scoringVector").getter(getter(CvssScoreDetails::scoringVector)).setter(setter(Builder::scoringVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoringVector").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(CvssScoreDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADJUSTMENTS_FIELD,
            SCORE_FIELD, SCORE_SOURCE_FIELD, SCORING_VECTOR_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("adjustments", ADJUSTMENTS_FIELD);
                    put("score", SCORE_FIELD);
                    put("scoreSource", SCORE_SOURCE_FIELD);
                    put("scoringVector", SCORING_VECTOR_FIELD);
                    put("version", VERSION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<CvssScoreAdjustment> adjustments;

    private final Double score;

    private final String scoreSource;

    private final String scoringVector;

    private final String version;

    private CvssScoreDetails(BuilderImpl builder) {
        this.adjustments = builder.adjustments;
        this.score = builder.score;
        this.scoreSource = builder.scoreSource;
        this.scoringVector = builder.scoringVector;
        this.version = builder.version;
    }

    /**
     * For responses, this returns true if the service returned a value for the Adjustments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdjustments() {
        return adjustments != null && !(adjustments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains details about adjustment Amazon Inspector made to the CVSS score.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdjustments} method.
     * </p>
     * 
     * @return An object that contains details about adjustment Amazon Inspector made to the CVSS score.
     */
    public final List<CvssScoreAdjustment> adjustments() {
        return adjustments;
    }

    /**
     * <p>
     * The CVSS score.
     * </p>
     * 
     * @return The CVSS score.
     */
    public final Double score() {
        return score;
    }

    /**
     * <p>
     * The source for the CVSS score.
     * </p>
     * 
     * @return The source for the CVSS score.
     */
    public final String scoreSource() {
        return scoreSource;
    }

    /**
     * <p>
     * The vector for the CVSS score.
     * </p>
     * 
     * @return The vector for the CVSS score.
     */
    public final String scoringVector() {
        return scoringVector;
    }

    /**
     * <p>
     * The CVSS version used in scoring.
     * </p>
     * 
     * @return The CVSS version used in scoring.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdjustments() ? adjustments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(scoreSource());
        hashCode = 31 * hashCode + Objects.hashCode(scoringVector());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CvssScoreDetails)) {
            return false;
        }
        CvssScoreDetails other = (CvssScoreDetails) obj;
        return hasAdjustments() == other.hasAdjustments() && Objects.equals(adjustments(), other.adjustments())
                && Objects.equals(score(), other.score()) && Objects.equals(scoreSource(), other.scoreSource())
                && Objects.equals(scoringVector(), other.scoringVector()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CvssScoreDetails").add("Adjustments", hasAdjustments() ? adjustments() : null)
                .add("Score", score()).add("ScoreSource", scoreSource()).add("ScoringVector", scoringVector())
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adjustments":
            return Optional.ofNullable(clazz.cast(adjustments()));
        case "score":
            return Optional.ofNullable(clazz.cast(score()));
        case "scoreSource":
            return Optional.ofNullable(clazz.cast(scoreSource()));
        case "scoringVector":
            return Optional.ofNullable(clazz.cast(scoringVector()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CvssScoreDetails, T> g) {
        return obj -> g.apply((CvssScoreDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CvssScoreDetails> {
        /**
         * <p>
         * An object that contains details about adjustment Amazon Inspector made to the CVSS score.
         * </p>
         * 
         * @param adjustments
         *        An object that contains details about adjustment Amazon Inspector made to the CVSS score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustments(Collection<CvssScoreAdjustment> adjustments);

        /**
         * <p>
         * An object that contains details about adjustment Amazon Inspector made to the CVSS score.
         * </p>
         * 
         * @param adjustments
         *        An object that contains details about adjustment Amazon Inspector made to the CVSS score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustments(CvssScoreAdjustment... adjustments);

        /**
         * <p>
         * An object that contains details about adjustment Amazon Inspector made to the CVSS score.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.CvssScoreAdjustment.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecr.model.CvssScoreAdjustment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.CvssScoreAdjustment.Builder#build()} is called immediately
         * and its result is passed to {@link #adjustments(List<CvssScoreAdjustment>)}.
         * 
         * @param adjustments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.CvssScoreAdjustment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adjustments(java.util.Collection<CvssScoreAdjustment>)
         */
        Builder adjustments(Consumer<CvssScoreAdjustment.Builder>... adjustments);

        /**
         * <p>
         * The CVSS score.
         * </p>
         * 
         * @param score
         *        The CVSS score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Double score);

        /**
         * <p>
         * The source for the CVSS score.
         * </p>
         * 
         * @param scoreSource
         *        The source for the CVSS score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreSource(String scoreSource);

        /**
         * <p>
         * The vector for the CVSS score.
         * </p>
         * 
         * @param scoringVector
         *        The vector for the CVSS score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoringVector(String scoringVector);

        /**
         * <p>
         * The CVSS version used in scoring.
         * </p>
         * 
         * @param version
         *        The CVSS version used in scoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private List<CvssScoreAdjustment> adjustments = DefaultSdkAutoConstructList.getInstance();

        private Double score;

        private String scoreSource;

        private String scoringVector;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(CvssScoreDetails model) {
            adjustments(model.adjustments);
            score(model.score);
            scoreSource(model.scoreSource);
            scoringVector(model.scoringVector);
            version(model.version);
        }

        public final List<CvssScoreAdjustment.Builder> getAdjustments() {
            List<CvssScoreAdjustment.Builder> result = CvssScoreAdjustmentListCopier.copyToBuilder(this.adjustments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdjustments(Collection<CvssScoreAdjustment.BuilderImpl> adjustments) {
            this.adjustments = CvssScoreAdjustmentListCopier.copyFromBuilder(adjustments);
        }

        @Override
        public final Builder adjustments(Collection<CvssScoreAdjustment> adjustments) {
            this.adjustments = CvssScoreAdjustmentListCopier.copy(adjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustments(CvssScoreAdjustment... adjustments) {
            adjustments(Arrays.asList(adjustments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustments(Consumer<CvssScoreAdjustment.Builder>... adjustments) {
            adjustments(Stream.of(adjustments).map(c -> CvssScoreAdjustment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Double getScore() {
            return score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public final String getScoreSource() {
            return scoreSource;
        }

        public final void setScoreSource(String scoreSource) {
            this.scoreSource = scoreSource;
        }

        @Override
        public final Builder scoreSource(String scoreSource) {
            this.scoreSource = scoreSource;
            return this;
        }

        public final String getScoringVector() {
            return scoringVector;
        }

        public final void setScoringVector(String scoringVector) {
            this.scoringVector = scoringVector;
        }

        @Override
        public final Builder scoringVector(String scoringVector) {
            this.scoringVector = scoringVector;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public CvssScoreDetails build() {
            return new CvssScoreDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
