/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadLayerPartRequest extends EcrRequest implements
        ToCopyableBuilder<UploadLayerPartRequest.Builder, UploadLayerPartRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(UploadLayerPartRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(UploadLayerPartRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(UploadLayerPartRequest::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final SdkField<Long> PART_FIRST_BYTE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("partFirstByte").getter(getter(UploadLayerPartRequest::partFirstByte))
            .setter(setter(Builder::partFirstByte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partFirstByte").build()).build();

    private static final SdkField<Long> PART_LAST_BYTE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("partLastByte").getter(getter(UploadLayerPartRequest::partLastByte))
            .setter(setter(Builder::partLastByte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partLastByte").build()).build();

    private static final SdkField<SdkBytes> LAYER_PART_BLOB_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("layerPartBlob").getter(getter(UploadLayerPartRequest::layerPartBlob))
            .setter(setter(Builder::layerPartBlob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerPartBlob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, UPLOAD_ID_FIELD, PART_FIRST_BYTE_FIELD, PART_LAST_BYTE_FIELD, LAYER_PART_BLOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("registryId", REGISTRY_ID_FIELD);
                    put("repositoryName", REPOSITORY_NAME_FIELD);
                    put("uploadId", UPLOAD_ID_FIELD);
                    put("partFirstByte", PART_FIRST_BYTE_FIELD);
                    put("partLastByte", PART_LAST_BYTE_FIELD);
                    put("layerPartBlob", LAYER_PART_BLOB_FIELD);
                }
            });

    private final String registryId;

    private final String repositoryName;

    private final String uploadId;

    private final Long partFirstByte;

    private final Long partLastByte;

    private final SdkBytes layerPartBlob;

    private UploadLayerPartRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.partFirstByte = builder.partFirstByte;
        this.partLastByte = builder.partLastByte;
        this.layerPartBlob = builder.layerPartBlob;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry to which you are uploading layer parts. If you do
     * not specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry to which you are uploading layer parts.
     *         If you do not specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository to which you are uploading layer parts.
     * </p>
     * 
     * @return The name of the repository to which you are uploading layer parts.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the layer part upload.
     * </p>
     * 
     * @return The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the layer part
     *         upload.
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * The position of the first byte of the layer part witin the overall image layer.
     * </p>
     * 
     * @return The position of the first byte of the layer part witin the overall image layer.
     */
    public final Long partFirstByte() {
        return partFirstByte;
    }

    /**
     * <p>
     * The position of the last byte of the layer part within the overall image layer.
     * </p>
     * 
     * @return The position of the last byte of the layer part within the overall image layer.
     */
    public final Long partLastByte() {
        return partLastByte;
    }

    /**
     * <p>
     * The base64-encoded layer part payload.
     * </p>
     * 
     * @return The base64-encoded layer part payload.
     */
    public final SdkBytes layerPartBlob() {
        return layerPartBlob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(partFirstByte());
        hashCode = 31 * hashCode + Objects.hashCode(partLastByte());
        hashCode = 31 * hashCode + Objects.hashCode(layerPartBlob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadLayerPartRequest)) {
            return false;
        }
        UploadLayerPartRequest other = (UploadLayerPartRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(uploadId(), other.uploadId()) && Objects.equals(partFirstByte(), other.partFirstByte())
                && Objects.equals(partLastByte(), other.partLastByte()) && Objects.equals(layerPartBlob(), other.layerPartBlob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UploadLayerPartRequest").add("RegistryId", registryId()).add("RepositoryName", repositoryName())
                .add("UploadId", uploadId()).add("PartFirstByte", partFirstByte()).add("PartLastByte", partLastByte())
                .add("LayerPartBlob", layerPartBlob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "partFirstByte":
            return Optional.ofNullable(clazz.cast(partFirstByte()));
        case "partLastByte":
            return Optional.ofNullable(clazz.cast(partLastByte()));
        case "layerPartBlob":
            return Optional.ofNullable(clazz.cast(layerPartBlob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UploadLayerPartRequest, T> g) {
        return obj -> g.apply((UploadLayerPartRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, UploadLayerPartRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry to which you are uploading layer parts. If
         * you do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry to which you are uploading layer
         *        parts. If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository to which you are uploading layer parts.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository to which you are uploading layer parts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the layer part upload.
         * </p>
         * 
         * @param uploadId
         *        The upload ID from a previous <a>InitiateLayerUpload</a> operation to associate with the layer part
         *        upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The position of the first byte of the layer part witin the overall image layer.
         * </p>
         * 
         * @param partFirstByte
         *        The position of the first byte of the layer part witin the overall image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partFirstByte(Long partFirstByte);

        /**
         * <p>
         * The position of the last byte of the layer part within the overall image layer.
         * </p>
         * 
         * @param partLastByte
         *        The position of the last byte of the layer part within the overall image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partLastByte(Long partLastByte);

        /**
         * <p>
         * The base64-encoded layer part payload.
         * </p>
         * 
         * @param layerPartBlob
         *        The base64-encoded layer part payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerPartBlob(SdkBytes layerPartBlob);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String uploadId;

        private Long partFirstByte;

        private Long partLastByte;

        private SdkBytes layerPartBlob;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadLayerPartRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            uploadId(model.uploadId);
            partFirstByte(model.partFirstByte);
            partLastByte(model.partLastByte);
            layerPartBlob(model.layerPartBlob);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final Long getPartFirstByte() {
            return partFirstByte;
        }

        public final void setPartFirstByte(Long partFirstByte) {
            this.partFirstByte = partFirstByte;
        }

        @Override
        public final Builder partFirstByte(Long partFirstByte) {
            this.partFirstByte = partFirstByte;
            return this;
        }

        public final Long getPartLastByte() {
            return partLastByte;
        }

        public final void setPartLastByte(Long partLastByte) {
            this.partLastByte = partLastByte;
        }

        @Override
        public final Builder partLastByte(Long partLastByte) {
            this.partLastByte = partLastByte;
            return this;
        }

        public final ByteBuffer getLayerPartBlob() {
            return layerPartBlob == null ? null : layerPartBlob.asByteBuffer();
        }

        public final void setLayerPartBlob(ByteBuffer layerPartBlob) {
            layerPartBlob(layerPartBlob == null ? null : SdkBytes.fromByteBuffer(layerPartBlob));
        }

        @Override
        public final Builder layerPartBlob(SdkBytes layerPartBlob) {
            this.layerPartBlob = layerPartBlob;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UploadLayerPartRequest build() {
            return new UploadLayerPartRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
