/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageReplicationStatusRequest extends EcrRequest implements
        ToCopyableBuilder<DescribeImageReplicationStatusRequest.Builder, DescribeImageReplicationStatusRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(DescribeImageReplicationStatusRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.<ImageIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("imageId").getter(getter(DescribeImageReplicationStatusRequest::imageId))
            .setter(setter(Builder::imageId)).constructor(ImageIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(DescribeImageReplicationStatusRequest::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            IMAGE_ID_FIELD, REGISTRY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("repositoryName", REPOSITORY_NAME_FIELD);
                    put("imageId", IMAGE_ID_FIELD);
                    put("registryId", REGISTRY_ID_FIELD);
                }
            });

    private final String repositoryName;

    private final ImageIdentifier imageId;

    private final String registryId;

    private DescribeImageReplicationStatusRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.registryId = builder.registryId;
    }

    /**
     * <p>
     * The name of the repository that the image is in.
     * </p>
     * 
     * @return The name of the repository that the image is in.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * Returns the value of the ImageId property for this object.
     * 
     * @return The value of the ImageId property for this object.
     */
    public final ImageIdentifier imageId() {
        return imageId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the default
     * registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the
     *         default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageReplicationStatusRequest)) {
            return false;
        }
        DescribeImageReplicationStatusRequest other = (DescribeImageReplicationStatusRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(registryId(), other.registryId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageReplicationStatusRequest").add("RepositoryName", repositoryName())
                .add("ImageId", imageId()).add("RegistryId", registryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageReplicationStatusRequest, T> g) {
        return obj -> g.apply((DescribeImageReplicationStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageReplicationStatusRequest> {
        /**
         * <p>
         * The name of the repository that the image is in.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that the image is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * Sets the value of the ImageId property for this object.
         *
         * @param imageId
         *        The new value for the ImageId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(ImageIdentifier imageId);

        /**
         * Sets the value of the ImageId property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImageIdentifier.Builder} avoiding the
         * need to create one manually via {@link ImageIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #imageId(ImageIdentifier)}.
         * 
         * @param imageId
         *        a consumer that will call methods on {@link ImageIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageId(ImageIdentifier)
         */
        default Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return imageId(ImageIdentifier.builder().applyMutation(imageId).build());
        }

        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the
         * default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry. If you do not specify a registry, the
         *        default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private ImageIdentifier imageId;

        private String registryId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageReplicationStatusRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            imageId(model.imageId);
            registryId(model.registryId);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageIdentifier.Builder getImageId() {
            return imageId != null ? imageId.toBuilder() : null;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImageReplicationStatusRequest build() {
            return new DescribeImageReplicationStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
