/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.services.ecr.model.EncryptionConfiguration;
import software.amazon.awssdk.services.ecr.model.ImageScanningConfiguration;
import software.amazon.awssdk.services.ecr.model.ImageTagMutability;
import software.amazon.awssdk.services.ecr.model.Tag;
import software.amazon.awssdk.services.ecr.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRepositoryRequest
extends EcrRequest
implements ToCopyableBuilder<Builder, CreateRepositoryRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::registryId)).setter(CreateRepositoryRequest.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::repositoryName)).setter(CreateRepositoryRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::tags)).setter(CreateRepositoryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_TAG_MUTABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageTagMutability").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::imageTagMutabilityAsString)).setter(CreateRepositoryRequest.setter(Builder::imageTagMutability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTagMutability").build()}).build();
    private static final SdkField<ImageScanningConfiguration> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageScanningConfiguration").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::imageScanningConfiguration)).setter(CreateRepositoryRequest.setter(Builder::imageScanningConfiguration)).constructor(ImageScanningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningConfiguration").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::encryptionConfiguration)).setter(CreateRepositoryRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, TAGS_FIELD, IMAGE_TAG_MUTABILITY_FIELD, IMAGE_SCANNING_CONFIGURATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("registryId", REGISTRY_ID_FIELD);
            this.put("repositoryName", REPOSITORY_NAME_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("imageTagMutability", IMAGE_TAG_MUTABILITY_FIELD);
            this.put("imageScanningConfiguration", IMAGE_SCANNING_CONFIGURATION_FIELD);
            this.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        }
    });
    private final String registryId;
    private final String repositoryName;
    private final List<Tag> tags;
    private final String imageTagMutability;
    private final ImageScanningConfiguration imageScanningConfiguration;
    private final EncryptionConfiguration encryptionConfiguration;

    private CreateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.tags = builder.tags;
        this.imageTagMutability = builder.imageTagMutability;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ImageTagMutability imageTagMutability() {
        return ImageTagMutability.fromValue(this.imageTagMutability);
    }

    public final String imageTagMutabilityAsString() {
        return this.imageTagMutability;
    }

    public final ImageScanningConfiguration imageScanningConfiguration() {
        return this.imageScanningConfiguration;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTagMutabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryRequest)) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.imageTagMutabilityAsString(), other.imageTagMutabilityAsString()) && Objects.equals(this.imageScanningConfiguration(), other.imageScanningConfiguration()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRepositoryRequest").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("Tags", this.hasTags() ? this.tags() : null).add("ImageTagMutability", (Object)this.imageTagMutabilityAsString()).add("ImageScanningConfiguration", (Object)this.imageScanningConfiguration()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "imageTagMutability": {
                return Optional.ofNullable(clazz.cast(this.imageTagMutabilityAsString()));
            }
            case "imageScanningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageScanningConfiguration()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateRepositoryRequest, T> g) {
        return obj -> g.apply((CreateRepositoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrRequest.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String imageTagMutability;
        private ImageScanningConfiguration imageScanningConfiguration;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryRequest model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.tags(model.tags);
            this.imageTagMutability(model.imageTagMutability);
            this.imageScanningConfiguration(model.imageScanningConfiguration);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImageTagMutability() {
            return this.imageTagMutability;
        }

        public final void setImageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
        }

        @Override
        public final Builder imageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        @Override
        public final Builder imageTagMutability(ImageTagMutability imageTagMutability) {
            this.imageTagMutability(imageTagMutability == null ? null : imageTagMutability.toString());
            return this;
        }

        public final ImageScanningConfiguration.Builder getImageScanningConfiguration() {
            return this.imageScanningConfiguration != null ? this.imageScanningConfiguration.toBuilder() : null;
        }

        public final void setImageScanningConfiguration(ImageScanningConfiguration.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        public final Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRepositoryRequest build() {
            return new CreateRepositoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRepositoryRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder imageTagMutability(String var1);

        public Builder imageTagMutability(ImageTagMutability var1);

        public Builder imageScanningConfiguration(ImageScanningConfiguration var1);

        default public Builder imageScanningConfiguration(Consumer<ImageScanningConfiguration.Builder> imageScanningConfiguration) {
            return this.imageScanningConfiguration((ImageScanningConfiguration)((ImageScanningConfiguration.Builder)ImageScanningConfiguration.builder().applyMutation(imageScanningConfiguration)).build());
        }

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

