/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class RepositoryCreationTemplateListCopier {
    static List<RepositoryCreationTemplate> copy(
            Collection<? extends RepositoryCreationTemplate> repositoryCreationTemplateListParam) {
        List<RepositoryCreationTemplate> list;
        if (repositoryCreationTemplateListParam == null || repositoryCreationTemplateListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RepositoryCreationTemplate> modifiableList = new ArrayList<>(repositoryCreationTemplateListParam.size());
            repositoryCreationTemplateListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RepositoryCreationTemplate> copyFromBuilder(
            Collection<? extends RepositoryCreationTemplate.Builder> repositoryCreationTemplateListParam) {
        List<RepositoryCreationTemplate> list;
        if (repositoryCreationTemplateListParam == null || repositoryCreationTemplateListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RepositoryCreationTemplate> modifiableList = new ArrayList<>(repositoryCreationTemplateListParam.size());
            repositoryCreationTemplateListParam.forEach(entry -> {
                RepositoryCreationTemplate member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RepositoryCreationTemplate.Builder> copyToBuilder(
            Collection<? extends RepositoryCreationTemplate> repositoryCreationTemplateListParam) {
        List<RepositoryCreationTemplate.Builder> list;
        if (repositoryCreationTemplateListParam == null || repositoryCreationTemplateListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RepositoryCreationTemplate.Builder> modifiableList = new ArrayList<>(repositoryCreationTemplateListParam.size());
            repositoryCreationTemplateListParam.forEach(entry -> {
                RepositoryCreationTemplate.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
