/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an Amazon ECR image layer failure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LayerFailure implements SdkPojo, Serializable, ToCopyableBuilder<LayerFailure.Builder, LayerFailure> {
    private static final SdkField<String> LAYER_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layerDigest").getter(getter(LayerFailure::layerDigest)).setter(setter(Builder::layerDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerDigest").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(LayerFailure::failureCodeAsString)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(LayerFailure::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_DIGEST_FIELD,
            FAILURE_CODE_FIELD, FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String layerDigest;

    private final String failureCode;

    private final String failureReason;

    private LayerFailure(BuilderImpl builder) {
        this.layerDigest = builder.layerDigest;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The layer digest associated with the failure.
     * </p>
     * 
     * @return The layer digest associated with the failure.
     */
    public final String layerDigest() {
        return layerDigest;
    }

    /**
     * <p>
     * The failure code associated with the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link LayerFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code associated with the failure.
     * @see LayerFailureCode
     */
    public final LayerFailureCode failureCode() {
        return LayerFailureCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The failure code associated with the failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link LayerFailureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code associated with the failure.
     * @see LayerFailureCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * The reason for the failure.
     * </p>
     * 
     * @return The reason for the failure.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layerDigest());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerFailure)) {
            return false;
        }
        LayerFailure other = (LayerFailure) obj;
        return Objects.equals(layerDigest(), other.layerDigest())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LayerFailure").add("LayerDigest", layerDigest()).add("FailureCode", failureCodeAsString())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "layerDigest":
            return Optional.ofNullable(clazz.cast(layerDigest()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("layerDigest", LAYER_DIGEST_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LayerFailure, T> g) {
        return obj -> g.apply((LayerFailure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LayerFailure> {
        /**
         * <p>
         * The layer digest associated with the failure.
         * </p>
         * 
         * @param layerDigest
         *        The layer digest associated with the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerDigest(String layerDigest);

        /**
         * <p>
         * The failure code associated with the failure.
         * </p>
         * 
         * @param failureCode
         *        The failure code associated with the failure.
         * @see LayerFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerFailureCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure code associated with the failure.
         * </p>
         * 
         * @param failureCode
         *        The failure code associated with the failure.
         * @see LayerFailureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerFailureCode
         */
        Builder failureCode(LayerFailureCode failureCode);

        /**
         * <p>
         * The reason for the failure.
         * </p>
         * 
         * @param failureReason
         *        The reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String layerDigest;

        private String failureCode;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(LayerFailure model) {
            layerDigest(model.layerDigest);
            failureCode(model.failureCode);
            failureReason(model.failureReason);
        }

        public final String getLayerDigest() {
            return layerDigest;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(LayerFailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public LayerFailure build() {
            return new LayerFailure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
