/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageReplicationStatus;
import software.amazon.awssdk.services.ecr.model.ImageReplicationStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageReplicationStatusResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, DescribeImageReplicationStatusResponse> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(DescribeImageReplicationStatusResponse.getter(DescribeImageReplicationStatusResponse::repositoryName)).setter(DescribeImageReplicationStatusResponse.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageId").getter(DescribeImageReplicationStatusResponse.getter(DescribeImageReplicationStatusResponse::imageId)).setter(DescribeImageReplicationStatusResponse.setter(Builder::imageId)).constructor(ImageIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<List<ImageReplicationStatus>> REPLICATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicationStatuses").getter(DescribeImageReplicationStatusResponse.getter(DescribeImageReplicationStatusResponse::replicationStatuses)).setter(DescribeImageReplicationStatusResponse.setter(Builder::replicationStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageReplicationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, IMAGE_ID_FIELD, REPLICATION_STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImageReplicationStatusResponse.memberNameToFieldInitializer();
    private final String repositoryName;
    private final ImageIdentifier imageId;
    private final List<ImageReplicationStatus> replicationStatuses;

    private DescribeImageReplicationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.replicationStatuses = builder.replicationStatuses;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final ImageIdentifier imageId() {
        return this.imageId;
    }

    public final boolean hasReplicationStatuses() {
        return this.replicationStatuses != null && !(this.replicationStatuses instanceof SdkAutoConstructList);
    }

    public final List<ImageReplicationStatus> replicationStatuses() {
        return this.replicationStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationStatuses() ? this.replicationStatuses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageReplicationStatusResponse)) {
            return false;
        }
        DescribeImageReplicationStatusResponse other = (DescribeImageReplicationStatusResponse)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageId(), other.imageId()) && this.hasReplicationStatuses() == other.hasReplicationStatuses() && Objects.equals(this.replicationStatuses(), other.replicationStatuses());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageReplicationStatusResponse").add("RepositoryName", (Object)this.repositoryName()).add("ImageId", (Object)this.imageId()).add("ReplicationStatuses", this.hasReplicationStatuses() ? this.replicationStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "replicationStatuses": {
                return Optional.ofNullable(clazz.cast(this.replicationStatuses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("imageId", IMAGE_ID_FIELD);
        map.put("replicationStatuses", REPLICATION_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageReplicationStatusResponse, T> g) {
        return obj -> g.apply((DescribeImageReplicationStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String repositoryName;
        private ImageIdentifier imageId;
        private List<ImageReplicationStatus> replicationStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageReplicationStatusResponse model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.imageId(model.imageId);
            this.replicationStatuses(model.replicationStatuses);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageIdentifier.Builder getImageId() {
            return this.imageId != null ? this.imageId.toBuilder() : null;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final List<ImageReplicationStatus.Builder> getReplicationStatuses() {
            List<ImageReplicationStatus.Builder> result = ImageReplicationStatusListCopier.copyToBuilder(this.replicationStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationStatuses(Collection<ImageReplicationStatus.BuilderImpl> replicationStatuses) {
            this.replicationStatuses = ImageReplicationStatusListCopier.copyFromBuilder(replicationStatuses);
        }

        @Override
        public final Builder replicationStatuses(Collection<ImageReplicationStatus> replicationStatuses) {
            this.replicationStatuses = ImageReplicationStatusListCopier.copy(replicationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatuses(ImageReplicationStatus ... replicationStatuses) {
            this.replicationStatuses(Arrays.asList(replicationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatuses(Consumer<ImageReplicationStatus.Builder> ... replicationStatuses) {
            this.replicationStatuses(Stream.of(replicationStatuses).map(c -> (ImageReplicationStatus)((ImageReplicationStatus.Builder)ImageReplicationStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeImageReplicationStatusResponse build() {
            return new DescribeImageReplicationStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageReplicationStatusResponse> {
        public Builder repositoryName(String var1);

        public Builder imageId(ImageIdentifier var1);

        default public Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return this.imageId((ImageIdentifier)((ImageIdentifier.Builder)ImageIdentifier.builder().applyMutation(imageId)).build());
        }

        public Builder replicationStatuses(Collection<ImageReplicationStatus> var1);

        public Builder replicationStatuses(ImageReplicationStatus ... var1);

        public Builder replicationStatuses(Consumer<ImageReplicationStatus.Builder> ... var1);
    }
}

