/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetImageRequest extends EcrRequest implements
        ToCopyableBuilder<BatchGetImageRequest.Builder, BatchGetImageRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(BatchGetImageRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(BatchGetImageRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<List<ImageIdentifier>> IMAGE_IDS_FIELD = SdkField
            .<List<ImageIdentifier>> builder(MarshallingType.LIST)
            .memberName("imageIds")
            .getter(getter(BatchGetImageRequest::imageIds))
            .setter(setter(Builder::imageIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCEPTED_MEDIA_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("acceptedMediaTypes")
            .getter(getter(BatchGetImageRequest::acceptedMediaTypes))
            .setter(setter(Builder::acceptedMediaTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptedMediaTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, IMAGE_IDS_FIELD, ACCEPTED_MEDIA_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registryId;

    private final String repositoryName;

    private final List<ImageIdentifier> imageIds;

    private final List<String> acceptedMediaTypes;

    private BatchGetImageRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageIds = builder.imageIds;
        this.acceptedMediaTypes = builder.acceptedMediaTypes;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry that contains the images to describe. If you do
     * not specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry that contains the images to describe. If
     *         you do not specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The repository that contains the images to describe.
     * </p>
     * 
     * @return The repository that contains the images to describe.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImageIds() {
        return imageIds != null && !(imageIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of image ID references that correspond to images to describe. The format of the <code>imageIds</code>
     * reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageIds} method.
     * </p>
     * 
     * @return A list of image ID references that correspond to images to describe. The format of the
     *         <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.
     */
    public final List<ImageIdentifier> imageIds() {
        return imageIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceptedMediaTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceptedMediaTypes() {
        return acceptedMediaTypes != null && !(acceptedMediaTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The accepted media types for the request.
     * </p>
     * <p>
     * Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
     * <code>application/vnd.docker.distribution.manifest.v2+json</code> |
     * <code>application/vnd.oci.image.manifest.v1+json</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceptedMediaTypes} method.
     * </p>
     * 
     * @return The accepted media types for the request.</p>
     *         <p>
     *         Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
     *         <code>application/vnd.docker.distribution.manifest.v2+json</code> |
     *         <code>application/vnd.oci.image.manifest.v1+json</code>
     */
    public final List<String> acceptedMediaTypes() {
        return acceptedMediaTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(hasImageIds() ? imageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceptedMediaTypes() ? acceptedMediaTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetImageRequest)) {
            return false;
        }
        BatchGetImageRequest other = (BatchGetImageRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && hasImageIds() == other.hasImageIds() && Objects.equals(imageIds(), other.imageIds())
                && hasAcceptedMediaTypes() == other.hasAcceptedMediaTypes()
                && Objects.equals(acceptedMediaTypes(), other.acceptedMediaTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetImageRequest").add("RegistryId", registryId()).add("RepositoryName", repositoryName())
                .add("ImageIds", hasImageIds() ? imageIds() : null)
                .add("AcceptedMediaTypes", hasAcceptedMediaTypes() ? acceptedMediaTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageIds":
            return Optional.ofNullable(clazz.cast(imageIds()));
        case "acceptedMediaTypes":
            return Optional.ofNullable(clazz.cast(acceptedMediaTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("imageIds", IMAGE_IDS_FIELD);
        map.put("acceptedMediaTypes", ACCEPTED_MEDIA_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetImageRequest, T> g) {
        return obj -> g.apply((BatchGetImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetImageRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry that contains the images to describe. If you
         * do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry that contains the images to describe.
         *        If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The repository that contains the images to describe.
         * </p>
         * 
         * @param repositoryName
         *        The repository that contains the images to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * A list of image ID references that correspond to images to describe. The format of the <code>imageIds</code>
         * reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.
         * </p>
         * 
         * @param imageIds
         *        A list of image ID references that correspond to images to describe. The format of the
         *        <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(Collection<ImageIdentifier> imageIds);

        /**
         * <p>
         * A list of image ID references that correspond to images to describe. The format of the <code>imageIds</code>
         * reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.
         * </p>
         * 
         * @param imageIds
         *        A list of image ID references that correspond to images to describe. The format of the
         *        <code>imageIds</code> reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(ImageIdentifier... imageIds);

        /**
         * <p>
         * A list of image ID references that correspond to images to describe. The format of the <code>imageIds</code>
         * reference is <code>imageTag=tag</code> or <code>imageDigest=digest</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.ImageIdentifier.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecr.model.ImageIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.ImageIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #imageIds(List<ImageIdentifier>)}.
         * 
         * @param imageIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.ImageIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageIds(java.util.Collection<ImageIdentifier>)
         */
        Builder imageIds(Consumer<ImageIdentifier.Builder>... imageIds);

        /**
         * <p>
         * The accepted media types for the request.
         * </p>
         * <p>
         * Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
         * <code>application/vnd.docker.distribution.manifest.v2+json</code> |
         * <code>application/vnd.oci.image.manifest.v1+json</code>
         * </p>
         * 
         * @param acceptedMediaTypes
         *        The accepted media types for the request.</p>
         *        <p>
         *        Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
         *        <code>application/vnd.docker.distribution.manifest.v2+json</code> |
         *        <code>application/vnd.oci.image.manifest.v1+json</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedMediaTypes(Collection<String> acceptedMediaTypes);

        /**
         * <p>
         * The accepted media types for the request.
         * </p>
         * <p>
         * Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
         * <code>application/vnd.docker.distribution.manifest.v2+json</code> |
         * <code>application/vnd.oci.image.manifest.v1+json</code>
         * </p>
         * 
         * @param acceptedMediaTypes
         *        The accepted media types for the request.</p>
         *        <p>
         *        Valid values: <code>application/vnd.docker.distribution.manifest.v1+json</code> |
         *        <code>application/vnd.docker.distribution.manifest.v2+json</code> |
         *        <code>application/vnd.oci.image.manifest.v1+json</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedMediaTypes(String... acceptedMediaTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private List<ImageIdentifier> imageIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> acceptedMediaTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetImageRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            imageIds(model.imageIds);
            acceptedMediaTypes(model.acceptedMediaTypes);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final List<ImageIdentifier.Builder> getImageIds() {
            List<ImageIdentifier.Builder> result = ImageIdentifierListCopier.copyToBuilder(this.imageIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageIds(Collection<ImageIdentifier.BuilderImpl> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copyFromBuilder(imageIds);
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier... imageIds) {
            imageIds(Arrays.asList(imageIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(Consumer<ImageIdentifier.Builder>... imageIds) {
            imageIds(Stream.of(imageIds).map(c -> ImageIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAcceptedMediaTypes() {
            if (acceptedMediaTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return acceptedMediaTypes;
        }

        public final void setAcceptedMediaTypes(Collection<String> acceptedMediaTypes) {
            this.acceptedMediaTypes = MediaTypeListCopier.copy(acceptedMediaTypes);
        }

        @Override
        public final Builder acceptedMediaTypes(Collection<String> acceptedMediaTypes) {
            this.acceptedMediaTypes = MediaTypeListCopier.copy(acceptedMediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptedMediaTypes(String... acceptedMediaTypes) {
            acceptedMediaTypes(Arrays.asList(acceptedMediaTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetImageRequest build() {
            return new BatchGetImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
