/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRepositoryCreationTemplatesResponse extends EcrResponse implements
        ToCopyableBuilder<DescribeRepositoryCreationTemplatesResponse.Builder, DescribeRepositoryCreationTemplatesResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(DescribeRepositoryCreationTemplatesResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<List<RepositoryCreationTemplate>> REPOSITORY_CREATION_TEMPLATES_FIELD = SdkField
            .<List<RepositoryCreationTemplate>> builder(MarshallingType.LIST)
            .memberName("repositoryCreationTemplates")
            .getter(getter(DescribeRepositoryCreationTemplatesResponse::repositoryCreationTemplates))
            .setter(setter(Builder::repositoryCreationTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCreationTemplates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryCreationTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryCreationTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeRepositoryCreationTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_CREATION_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registryId;

    private final List<RepositoryCreationTemplate> repositoryCreationTemplates;

    private final String nextToken;

    private DescribeRepositoryCreationTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryCreationTemplates = builder.repositoryCreationTemplates;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RepositoryCreationTemplates property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRepositoryCreationTemplates() {
        return repositoryCreationTemplates != null && !(repositoryCreationTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the repository creation templates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositoryCreationTemplates} method.
     * </p>
     * 
     * @return The details of the repository creation templates.
     */
    public final List<RepositoryCreationTemplate> repositoryCreationTemplates() {
        return repositoryCreationTemplates;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeRepositoryCreationTemplates</code> request.
     * When the results of a <code>DescribeRepositoryCreationTemplates</code> request exceed <code>maxResults</code>,
     * this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no
     * more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeRepositoryCreationTemplates</code>
     *         request. When the results of a <code>DescribeRepositoryCreationTemplates</code> request exceed
     *         <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is
     *         <code>null</code> when there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositoryCreationTemplates() ? repositoryCreationTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRepositoryCreationTemplatesResponse)) {
            return false;
        }
        DescribeRepositoryCreationTemplatesResponse other = (DescribeRepositoryCreationTemplatesResponse) obj;
        return Objects.equals(registryId(), other.registryId())
                && hasRepositoryCreationTemplates() == other.hasRepositoryCreationTemplates()
                && Objects.equals(repositoryCreationTemplates(), other.repositoryCreationTemplates())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRepositoryCreationTemplatesResponse").add("RegistryId", registryId())
                .add("RepositoryCreationTemplates", hasRepositoryCreationTemplates() ? repositoryCreationTemplates() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryCreationTemplates":
            return Optional.ofNullable(clazz.cast(repositoryCreationTemplates()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("repositoryCreationTemplates", REPOSITORY_CREATION_TEMPLATES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRepositoryCreationTemplatesResponse, T> g) {
        return obj -> g.apply((DescribeRepositoryCreationTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRepositoryCreationTemplatesResponse> {
        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The details of the repository creation templates.
         * </p>
         * 
         * @param repositoryCreationTemplates
         *        The details of the repository creation templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryCreationTemplates(Collection<RepositoryCreationTemplate> repositoryCreationTemplates);

        /**
         * <p>
         * The details of the repository creation templates.
         * </p>
         * 
         * @param repositoryCreationTemplates
         *        The details of the repository creation templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryCreationTemplates(RepositoryCreationTemplate... repositoryCreationTemplates);

        /**
         * <p>
         * The details of the repository creation templates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.RepositoryCreationTemplate.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ecr.model.RepositoryCreationTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.RepositoryCreationTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #repositoryCreationTemplates(List<RepositoryCreationTemplate>)}.
         * 
         * @param repositoryCreationTemplates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.RepositoryCreationTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryCreationTemplates(java.util.Collection<RepositoryCreationTemplate>)
         */
        Builder repositoryCreationTemplates(Consumer<RepositoryCreationTemplate.Builder>... repositoryCreationTemplates);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeRepositoryCreationTemplates</code>
         * request. When the results of a <code>DescribeRepositoryCreationTemplates</code> request exceed
         * <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future
         *        <code>DescribeRepositoryCreationTemplates</code> request. When the results of a
         *        <code>DescribeRepositoryCreationTemplates</code> request exceed <code>maxResults</code>, this value
         *        can be used to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String registryId;

        private List<RepositoryCreationTemplate> repositoryCreationTemplates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRepositoryCreationTemplatesResponse model) {
            super(model);
            registryId(model.registryId);
            repositoryCreationTemplates(model.repositoryCreationTemplates);
            nextToken(model.nextToken);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final List<RepositoryCreationTemplate.Builder> getRepositoryCreationTemplates() {
            List<RepositoryCreationTemplate.Builder> result = RepositoryCreationTemplateListCopier
                    .copyToBuilder(this.repositoryCreationTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositoryCreationTemplates(
                Collection<RepositoryCreationTemplate.BuilderImpl> repositoryCreationTemplates) {
            this.repositoryCreationTemplates = RepositoryCreationTemplateListCopier.copyFromBuilder(repositoryCreationTemplates);
        }

        @Override
        public final Builder repositoryCreationTemplates(Collection<RepositoryCreationTemplate> repositoryCreationTemplates) {
            this.repositoryCreationTemplates = RepositoryCreationTemplateListCopier.copy(repositoryCreationTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryCreationTemplates(RepositoryCreationTemplate... repositoryCreationTemplates) {
            repositoryCreationTemplates(Arrays.asList(repositoryCreationTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryCreationTemplates(
                Consumer<RepositoryCreationTemplate.Builder>... repositoryCreationTemplates) {
            repositoryCreationTemplates(Stream.of(repositoryCreationTemplates)
                    .map(c -> RepositoryCreationTemplate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRepositoryCreationTemplatesResponse build() {
            return new DescribeRepositoryCreationTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
