/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePullThroughCacheRuleResponse extends EcrResponse implements
        ToCopyableBuilder<DeletePullThroughCacheRuleResponse.Builder, DeletePullThroughCacheRuleResponse> {
    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ecrRepositoryPrefix").getter(getter(DeletePullThroughCacheRuleResponse::ecrRepositoryPrefix))
            .setter(setter(Builder::ecrRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build())
            .build();

    private static final SdkField<String> UPSTREAM_REGISTRY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRegistryUrl").getter(getter(DeletePullThroughCacheRuleResponse::upstreamRegistryUrl))
            .setter(setter(Builder::upstreamRegistryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistryUrl").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DeletePullThroughCacheRuleResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(DeletePullThroughCacheRuleResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialArn").getter(getter(DeletePullThroughCacheRuleResponse::credentialArn))
            .setter(setter(Builder::credentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialArn").build()).build();

    private static final SdkField<String> CUSTOM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customRoleArn").getter(getter(DeletePullThroughCacheRuleResponse::customRoleArn))
            .setter(setter(Builder::customRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRoleArn").build()).build();

    private static final SdkField<String> UPSTREAM_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRepositoryPrefix").getter(getter(DeletePullThroughCacheRuleResponse::upstreamRepositoryPrefix))
            .setter(setter(Builder::upstreamRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRepositoryPrefix").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_REPOSITORY_PREFIX_FIELD,
            UPSTREAM_REGISTRY_URL_FIELD, CREATED_AT_FIELD, REGISTRY_ID_FIELD, CREDENTIAL_ARN_FIELD, CUSTOM_ROLE_ARN_FIELD,
            UPSTREAM_REPOSITORY_PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ecrRepositoryPrefix;

    private final String upstreamRegistryUrl;

    private final Instant createdAt;

    private final String registryId;

    private final String credentialArn;

    private final String customRoleArn;

    private final String upstreamRepositoryPrefix;

    private DeletePullThroughCacheRuleResponse(BuilderImpl builder) {
        super(builder);
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
        this.createdAt = builder.createdAt;
        this.registryId = builder.registryId;
        this.credentialArn = builder.credentialArn;
        this.customRoleArn = builder.customRoleArn;
        this.upstreamRepositoryPrefix = builder.upstreamRepositoryPrefix;
    }

    /**
     * <p>
     * The Amazon ECR repository prefix associated with the request.
     * </p>
     * 
     * @return The Amazon ECR repository prefix associated with the request.
     */
    public final String ecrRepositoryPrefix() {
        return ecrRepositoryPrefix;
    }

    /**
     * <p>
     * The upstream registry URL associated with the pull through cache rule.
     * </p>
     * 
     * @return The upstream registry URL associated with the pull through cache rule.
     */
    public final String upstreamRegistryUrl() {
        return upstreamRegistryUrl;
    }

    /**
     * <p>
     * The timestamp associated with the pull through cache rule.
     * </p>
     * 
     * @return The timestamp associated with the pull through cache rule.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the pull through
     * cache rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the pull
     *         through cache rule.
     */
    public final String credentialArn() {
        return credentialArn;
    }

    /**
     * <p>
     * The ARN of the IAM role associated with the pull through cache rule.
     * </p>
     * 
     * @return The ARN of the IAM role associated with the pull through cache rule.
     */
    public final String customRoleArn() {
        return customRoleArn;
    }

    /**
     * <p>
     * The upstream repository prefix associated with the pull through cache rule.
     * </p>
     * 
     * @return The upstream repository prefix associated with the pull through cache rule.
     */
    public final String upstreamRepositoryPrefix() {
        return upstreamRepositoryPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRegistryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(credentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(customRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRepositoryPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePullThroughCacheRuleResponse)) {
            return false;
        }
        DeletePullThroughCacheRuleResponse other = (DeletePullThroughCacheRuleResponse) obj;
        return Objects.equals(ecrRepositoryPrefix(), other.ecrRepositoryPrefix())
                && Objects.equals(upstreamRegistryUrl(), other.upstreamRegistryUrl())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(registryId(), other.registryId())
                && Objects.equals(credentialArn(), other.credentialArn())
                && Objects.equals(customRoleArn(), other.customRoleArn())
                && Objects.equals(upstreamRepositoryPrefix(), other.upstreamRepositoryPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePullThroughCacheRuleResponse").add("EcrRepositoryPrefix", ecrRepositoryPrefix())
                .add("UpstreamRegistryUrl", upstreamRegistryUrl()).add("CreatedAt", createdAt()).add("RegistryId", registryId())
                .add("CredentialArn", credentialArn()).add("CustomRoleArn", customRoleArn())
                .add("UpstreamRepositoryPrefix", upstreamRepositoryPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ecrRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(ecrRepositoryPrefix()));
        case "upstreamRegistryUrl":
            return Optional.ofNullable(clazz.cast(upstreamRegistryUrl()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "credentialArn":
            return Optional.ofNullable(clazz.cast(credentialArn()));
        case "customRoleArn":
            return Optional.ofNullable(clazz.cast(customRoleArn()));
        case "upstreamRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(upstreamRepositoryPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ecrRepositoryPrefix", ECR_REPOSITORY_PREFIX_FIELD);
        map.put("upstreamRegistryUrl", UPSTREAM_REGISTRY_URL_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("credentialArn", CREDENTIAL_ARN_FIELD);
        map.put("customRoleArn", CUSTOM_ROLE_ARN_FIELD);
        map.put("upstreamRepositoryPrefix", UPSTREAM_REPOSITORY_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletePullThroughCacheRuleResponse, T> g) {
        return obj -> g.apply((DeletePullThroughCacheRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeletePullThroughCacheRuleResponse> {
        /**
         * <p>
         * The Amazon ECR repository prefix associated with the request.
         * </p>
         * 
         * @param ecrRepositoryPrefix
         *        The Amazon ECR repository prefix associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryPrefix(String ecrRepositoryPrefix);

        /**
         * <p>
         * The upstream registry URL associated with the pull through cache rule.
         * </p>
         * 
         * @param upstreamRegistryUrl
         *        The upstream registry URL associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamRegistryUrl(String upstreamRegistryUrl);

        /**
         * <p>
         * The timestamp associated with the pull through cache rule.
         * </p>
         * 
         * @param createdAt
         *        The timestamp associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the pull
         * through cache rule.
         * </p>
         * 
         * @param credentialArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the
         *        pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialArn(String credentialArn);

        /**
         * <p>
         * The ARN of the IAM role associated with the pull through cache rule.
         * </p>
         * 
         * @param customRoleArn
         *        The ARN of the IAM role associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRoleArn(String customRoleArn);

        /**
         * <p>
         * The upstream repository prefix associated with the pull through cache rule.
         * </p>
         * 
         * @param upstreamRepositoryPrefix
         *        The upstream repository prefix associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String ecrRepositoryPrefix;

        private String upstreamRegistryUrl;

        private Instant createdAt;

        private String registryId;

        private String credentialArn;

        private String customRoleArn;

        private String upstreamRepositoryPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePullThroughCacheRuleResponse model) {
            super(model);
            ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            upstreamRegistryUrl(model.upstreamRegistryUrl);
            createdAt(model.createdAt);
            registryId(model.registryId);
            credentialArn(model.credentialArn);
            customRoleArn(model.customRoleArn);
            upstreamRepositoryPrefix(model.upstreamRepositoryPrefix);
        }

        public final String getEcrRepositoryPrefix() {
            return ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getUpstreamRegistryUrl() {
            return upstreamRegistryUrl;
        }

        public final void setUpstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
        }

        @Override
        public final Builder upstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getCredentialArn() {
            return credentialArn;
        }

        public final void setCredentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
        }

        @Override
        public final Builder credentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
            return this;
        }

        public final String getCustomRoleArn() {
            return customRoleArn;
        }

        public final void setCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
        }

        @Override
        public final Builder customRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        public final String getUpstreamRepositoryPrefix() {
            return upstreamRepositoryPrefix;
        }

        public final void setUpstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
        }

        @Override
        public final Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
            return this;
        }

        @Override
        public DeletePullThroughCacheRuleResponse build() {
            return new DeletePullThroughCacheRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
