/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAuthorizationTokenRequest extends EcrRequest implements
        ToCopyableBuilder<GetAuthorizationTokenRequest.Builder, GetAuthorizationTokenRequest> {
    private static final SdkField<List<String>> REGISTRY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("registryIds")
            .getter(getter(GetAuthorizationTokenRequest::registryIds))
            .setter(setter(Builder::registryIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> registryIds;

    private GetAuthorizationTokenRequest(BuilderImpl builder) {
        super(builder);
        this.registryIds = builder.registryIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegistryIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     *
     * @deprecated This field is deprecated. The returned authorization token can be used to access any Amazon ECR
     *             registry that the IAM principal has access to, specifying a registry ID doesn't change the
     *             permissions scope of the authorization token.
     */
    @Deprecated
    public final boolean hasRegistryIds() {
        return registryIds != null && !(registryIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services account IDs that are associated with the registries for which to get
     * AuthorizationData objects. If you do not specify a registry, the default registry is assumed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegistryIds} method.
     * </p>
     * 
     * @return A list of Amazon Web Services account IDs that are associated with the registries for which to get
     *         AuthorizationData objects. If you do not specify a registry, the default registry is assumed.
     * @deprecated This field is deprecated. The returned authorization token can be used to access any Amazon ECR
     *             registry that the IAM principal has access to, specifying a registry ID doesn't change the
     *             permissions scope of the authorization token.
     */
    @Deprecated
    public final List<String> registryIds() {
        return registryIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistryIds() ? registryIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthorizationTokenRequest)) {
            return false;
        }
        GetAuthorizationTokenRequest other = (GetAuthorizationTokenRequest) obj;
        return hasRegistryIds() == other.hasRegistryIds() && Objects.equals(registryIds(), other.registryIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAuthorizationTokenRequest").add("RegistryIds", hasRegistryIds() ? registryIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryIds":
            return Optional.ofNullable(clazz.cast(registryIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registryIds", REGISTRY_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAuthorizationTokenRequest, T> g) {
        return obj -> g.apply((GetAuthorizationTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAuthorizationTokenRequest> {
        /**
         * <p>
         * A list of Amazon Web Services account IDs that are associated with the registries for which to get
         * AuthorizationData objects. If you do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryIds
         *        A list of Amazon Web Services account IDs that are associated with the registries for which to get
         *        AuthorizationData objects. If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is deprecated. The returned authorization token can be used to access any Amazon ECR
         *             registry that the IAM principal has access to, specifying a registry ID doesn't change the
         *             permissions scope of the authorization token.
         */
        @Deprecated
        Builder registryIds(Collection<String> registryIds);

        /**
         * <p>
         * A list of Amazon Web Services account IDs that are associated with the registries for which to get
         * AuthorizationData objects. If you do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryIds
         *        A list of Amazon Web Services account IDs that are associated with the registries for which to get
         *        AuthorizationData objects. If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is deprecated. The returned authorization token can be used to access any Amazon ECR
         *             registry that the IAM principal has access to, specifying a registry ID doesn't change the
         *             permissions scope of the authorization token.
         */
        @Deprecated
        Builder registryIds(String... registryIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private List<String> registryIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthorizationTokenRequest model) {
            super(model);
            registryIds(model.registryIds);
        }

        @Deprecated
        public final Collection<String> getRegistryIds() {
            if (registryIds instanceof SdkAutoConstructList) {
                return null;
            }
            return registryIds;
        }

        @Deprecated
        public final void setRegistryIds(Collection<String> registryIds) {
            this.registryIds = GetAuthorizationTokenRegistryIdListCopier.copy(registryIds);
        }

        @Override
        @Deprecated
        public final Builder registryIds(Collection<String> registryIds) {
            this.registryIds = GetAuthorizationTokenRegistryIdListCopier.copy(registryIds);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder registryIds(String... registryIds) {
            registryIds(Arrays.asList(registryIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAuthorizationTokenRequest build() {
            return new GetAuthorizationTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
