/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.waiters;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.ecr.EcrClient;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse;
import software.amazon.awssdk.services.ecr.waiters.DefaultEcrWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface EcrWaiter
extends SdkAutoCloseable {
    default public WaiterResponse<DescribeImageScanFindingsResponse> waitUntilImageScanComplete(DescribeImageScanFindingsRequest describeImageScanFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    default public WaiterResponse<DescribeImageScanFindingsResponse> waitUntilImageScanComplete(Consumer<DescribeImageScanFindingsRequest.Builder> describeImageScanFindingsRequest) {
        return this.waitUntilImageScanComplete((DescribeImageScanFindingsRequest)((Object)((DescribeImageScanFindingsRequest.Builder)DescribeImageScanFindingsRequest.builder().applyMutation(describeImageScanFindingsRequest)).build()));
    }

    default public WaiterResponse<DescribeImageScanFindingsResponse> waitUntilImageScanComplete(DescribeImageScanFindingsRequest describeImageScanFindingsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public WaiterResponse<DescribeImageScanFindingsResponse> waitUntilImageScanComplete(Consumer<DescribeImageScanFindingsRequest.Builder> describeImageScanFindingsRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilImageScanComplete((DescribeImageScanFindingsRequest)((Object)((DescribeImageScanFindingsRequest.Builder)DescribeImageScanFindingsRequest.builder().applyMutation(describeImageScanFindingsRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public WaiterResponse<GetLifecyclePolicyPreviewResponse> waitUntilLifecyclePolicyPreviewComplete(GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest) {
        throw new UnsupportedOperationException();
    }

    default public WaiterResponse<GetLifecyclePolicyPreviewResponse> waitUntilLifecyclePolicyPreviewComplete(Consumer<GetLifecyclePolicyPreviewRequest.Builder> getLifecyclePolicyPreviewRequest) {
        return this.waitUntilLifecyclePolicyPreviewComplete((GetLifecyclePolicyPreviewRequest)((Object)((GetLifecyclePolicyPreviewRequest.Builder)GetLifecyclePolicyPreviewRequest.builder().applyMutation(getLifecyclePolicyPreviewRequest)).build()));
    }

    default public WaiterResponse<GetLifecyclePolicyPreviewResponse> waitUntilLifecyclePolicyPreviewComplete(GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public WaiterResponse<GetLifecyclePolicyPreviewResponse> waitUntilLifecyclePolicyPreviewComplete(Consumer<GetLifecyclePolicyPreviewRequest.Builder> getLifecyclePolicyPreviewRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilLifecyclePolicyPreviewComplete((GetLifecyclePolicyPreviewRequest)((Object)((GetLifecyclePolicyPreviewRequest.Builder)GetLifecyclePolicyPreviewRequest.builder().applyMutation(getLifecyclePolicyPreviewRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultEcrWaiter.builder();
    }

    public static EcrWaiter create() {
        return DefaultEcrWaiter.builder().build();
    }

    public static interface Builder {
        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(EcrClient var1);

        public EcrWaiter build();
    }
}

