/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutImageRequest extends EcrRequest implements ToCopyableBuilder<PutImageRequest.Builder, PutImageRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(PutImageRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(PutImageRequest::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> IMAGE_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageManifest").getter(getter(PutImageRequest::imageManifest)).setter(setter(Builder::imageManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageManifest").build()).build();

    private static final SdkField<String> IMAGE_MANIFEST_MEDIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageManifestMediaType").getter(getter(PutImageRequest::imageManifestMediaType))
            .setter(setter(Builder::imageManifestMediaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageManifestMediaType").build())
            .build();

    private static final SdkField<String> IMAGE_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageTag").getter(getter(PutImageRequest::imageTag)).setter(setter(Builder::imageTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTag").build()).build();

    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageDigest").getter(getter(PutImageRequest::imageDigest)).setter(setter(Builder::imageDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, IMAGE_MANIFEST_FIELD, IMAGE_MANIFEST_MEDIA_TYPE_FIELD, IMAGE_TAG_FIELD, IMAGE_DIGEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registryId;

    private final String repositoryName;

    private final String imageManifest;

    private final String imageManifestMediaType;

    private final String imageTag;

    private final String imageDigest;

    private PutImageRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageManifest = builder.imageManifest;
        this.imageManifestMediaType = builder.imageManifestMediaType;
        this.imageTag = builder.imageTag;
        this.imageDigest = builder.imageDigest;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry that contains the repository in which to put the
     * image. If you do not specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry that contains the repository in which to
     *         put the image. If you do not specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository in which to put the image.
     * </p>
     * 
     * @return The name of the repository in which to put the image.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The image manifest corresponding to the image to be uploaded.
     * </p>
     * 
     * @return The image manifest corresponding to the image to be uploaded.
     */
    public final String imageManifest() {
        return imageManifest;
    }

    /**
     * <p>
     * The media type of the image manifest. If you push an image manifest that does not contain the
     * <code>mediaType</code> field, you must specify the <code>imageManifestMediaType</code> in the request.
     * </p>
     * 
     * @return The media type of the image manifest. If you push an image manifest that does not contain the
     *         <code>mediaType</code> field, you must specify the <code>imageManifestMediaType</code> in the request.
     */
    public final String imageManifestMediaType() {
        return imageManifestMediaType;
    }

    /**
     * <p>
     * The tag to associate with the image. This parameter is required for images that use the Docker Image Manifest V2
     * Schema 2 or Open Container Initiative (OCI) formats.
     * </p>
     * 
     * @return The tag to associate with the image. This parameter is required for images that use the Docker Image
     *         Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.
     */
    public final String imageTag() {
        return imageTag;
    }

    /**
     * <p>
     * The image digest of the image manifest corresponding to the image.
     * </p>
     * 
     * @return The image digest of the image manifest corresponding to the image.
     */
    public final String imageDigest() {
        return imageDigest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(imageManifest());
        hashCode = 31 * hashCode + Objects.hashCode(imageManifestMediaType());
        hashCode = 31 * hashCode + Objects.hashCode(imageTag());
        hashCode = 31 * hashCode + Objects.hashCode(imageDigest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutImageRequest)) {
            return false;
        }
        PutImageRequest other = (PutImageRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(imageManifest(), other.imageManifest())
                && Objects.equals(imageManifestMediaType(), other.imageManifestMediaType())
                && Objects.equals(imageTag(), other.imageTag()) && Objects.equals(imageDigest(), other.imageDigest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutImageRequest").add("RegistryId", registryId()).add("RepositoryName", repositoryName())
                .add("ImageManifest", imageManifest()).add("ImageManifestMediaType", imageManifestMediaType())
                .add("ImageTag", imageTag()).add("ImageDigest", imageDigest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageManifest":
            return Optional.ofNullable(clazz.cast(imageManifest()));
        case "imageManifestMediaType":
            return Optional.ofNullable(clazz.cast(imageManifestMediaType()));
        case "imageTag":
            return Optional.ofNullable(clazz.cast(imageTag()));
        case "imageDigest":
            return Optional.ofNullable(clazz.cast(imageDigest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("imageManifest", IMAGE_MANIFEST_FIELD);
        map.put("imageManifestMediaType", IMAGE_MANIFEST_MEDIA_TYPE_FIELD);
        map.put("imageTag", IMAGE_TAG_FIELD);
        map.put("imageDigest", IMAGE_DIGEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutImageRequest, T> g) {
        return obj -> g.apply((PutImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutImageRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry that contains the repository in which to put
         * the image. If you do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry that contains the repository in which
         *        to put the image. If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository in which to put the image.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository in which to put the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The image manifest corresponding to the image to be uploaded.
         * </p>
         * 
         * @param imageManifest
         *        The image manifest corresponding to the image to be uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageManifest(String imageManifest);

        /**
         * <p>
         * The media type of the image manifest. If you push an image manifest that does not contain the
         * <code>mediaType</code> field, you must specify the <code>imageManifestMediaType</code> in the request.
         * </p>
         * 
         * @param imageManifestMediaType
         *        The media type of the image manifest. If you push an image manifest that does not contain the
         *        <code>mediaType</code> field, you must specify the <code>imageManifestMediaType</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageManifestMediaType(String imageManifestMediaType);

        /**
         * <p>
         * The tag to associate with the image. This parameter is required for images that use the Docker Image Manifest
         * V2 Schema 2 or Open Container Initiative (OCI) formats.
         * </p>
         * 
         * @param imageTag
         *        The tag to associate with the image. This parameter is required for images that use the Docker Image
         *        Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTag(String imageTag);

        /**
         * <p>
         * The image digest of the image manifest corresponding to the image.
         * </p>
         * 
         * @param imageDigest
         *        The image digest of the image manifest corresponding to the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDigest(String imageDigest);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String imageManifest;

        private String imageManifestMediaType;

        private String imageTag;

        private String imageDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(PutImageRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            imageManifest(model.imageManifest);
            imageManifestMediaType(model.imageManifestMediaType);
            imageTag(model.imageTag);
            imageDigest(model.imageDigest);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getImageManifest() {
            return imageManifest;
        }

        public final void setImageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
        }

        @Override
        public final Builder imageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
            return this;
        }

        public final String getImageManifestMediaType() {
            return imageManifestMediaType;
        }

        public final void setImageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
        }

        @Override
        public final Builder imageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
            return this;
        }

        public final String getImageTag() {
            return imageTag;
        }

        public final void setImageTag(String imageTag) {
            this.imageTag = imageTag;
        }

        @Override
        public final Builder imageTag(String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        public final String getImageDigest() {
            return imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutImageRequest build() {
            return new PutImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
