/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePullThroughCacheRuleRequest
extends EcrRequest
implements ToCopyableBuilder<Builder, UpdatePullThroughCacheRuleRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(UpdatePullThroughCacheRuleRequest.getter(UpdatePullThroughCacheRuleRequest::registryId)).setter(UpdatePullThroughCacheRuleRequest.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ecrRepositoryPrefix").getter(UpdatePullThroughCacheRuleRequest.getter(UpdatePullThroughCacheRuleRequest::ecrRepositoryPrefix)).setter(UpdatePullThroughCacheRuleRequest.setter(Builder::ecrRepositoryPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build()}).build();
    private static final SdkField<String> CREDENTIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialArn").getter(UpdatePullThroughCacheRuleRequest.getter(UpdatePullThroughCacheRuleRequest::credentialArn)).setter(UpdatePullThroughCacheRuleRequest.setter(Builder::credentialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialArn").build()}).build();
    private static final SdkField<String> CUSTOM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customRoleArn").getter(UpdatePullThroughCacheRuleRequest.getter(UpdatePullThroughCacheRuleRequest::customRoleArn)).setter(UpdatePullThroughCacheRuleRequest.setter(Builder::customRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, ECR_REPOSITORY_PREFIX_FIELD, CREDENTIAL_ARN_FIELD, CUSTOM_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePullThroughCacheRuleRequest.memberNameToFieldInitializer();
    private final String registryId;
    private final String ecrRepositoryPrefix;
    private final String credentialArn;
    private final String customRoleArn;

    private UpdatePullThroughCacheRuleRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.credentialArn = builder.credentialArn;
        this.customRoleArn = builder.customRoleArn;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String ecrRepositoryPrefix() {
        return this.ecrRepositoryPrefix;
    }

    public final String credentialArn() {
        return this.credentialArn;
    }

    public final String customRoleArn() {
        return this.customRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePullThroughCacheRuleRequest)) {
            return false;
        }
        UpdatePullThroughCacheRuleRequest other = (UpdatePullThroughCacheRuleRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.ecrRepositoryPrefix(), other.ecrRepositoryPrefix()) && Objects.equals(this.credentialArn(), other.credentialArn()) && Objects.equals(this.customRoleArn(), other.customRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePullThroughCacheRuleRequest").add("RegistryId", (Object)this.registryId()).add("EcrRepositoryPrefix", (Object)this.ecrRepositoryPrefix()).add("CredentialArn", (Object)this.credentialArn()).add("CustomRoleArn", (Object)this.customRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "ecrRepositoryPrefix": {
                return Optional.ofNullable(clazz.cast(this.ecrRepositoryPrefix()));
            }
            case "credentialArn": {
                return Optional.ofNullable(clazz.cast(this.credentialArn()));
            }
            case "customRoleArn": {
                return Optional.ofNullable(clazz.cast(this.customRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("ecrRepositoryPrefix", ECR_REPOSITORY_PREFIX_FIELD);
        map.put("credentialArn", CREDENTIAL_ARN_FIELD);
        map.put("customRoleArn", CUSTOM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePullThroughCacheRuleRequest, T> g) {
        return obj -> g.apply((UpdatePullThroughCacheRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrRequest.BuilderImpl
    implements Builder {
        private String registryId;
        private String ecrRepositoryPrefix;
        private String credentialArn;
        private String customRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePullThroughCacheRuleRequest model) {
            super(model);
            this.registryId(model.registryId);
            this.ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            this.credentialArn(model.credentialArn);
            this.customRoleArn(model.customRoleArn);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getEcrRepositoryPrefix() {
            return this.ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getCredentialArn() {
            return this.credentialArn;
        }

        public final void setCredentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
        }

        @Override
        public final Builder credentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
            return this;
        }

        public final String getCustomRoleArn() {
            return this.customRoleArn;
        }

        public final void setCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
        }

        @Override
        public final Builder customRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePullThroughCacheRuleRequest build() {
            return new UpdatePullThroughCacheRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePullThroughCacheRuleRequest> {
        public Builder registryId(String var1);

        public Builder ecrRepositoryPrefix(String var1);

        public Builder credentialArn(String var1);

        public Builder customRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

