/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.ecr.EcrAsyncClient;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse;
import software.amazon.awssdk.services.ecr.waiters.DefaultEcrAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface EcrAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeImageScanFindingsResponse>> waitUntilImageScanComplete(DescribeImageScanFindingsRequest describeImageScanFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeImageScanFindingsResponse>> waitUntilImageScanComplete(Consumer<DescribeImageScanFindingsRequest.Builder> describeImageScanFindingsRequest) {
        return this.waitUntilImageScanComplete((DescribeImageScanFindingsRequest)((Object)((DescribeImageScanFindingsRequest.Builder)DescribeImageScanFindingsRequest.builder().applyMutation(describeImageScanFindingsRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeImageScanFindingsResponse>> waitUntilImageScanComplete(DescribeImageScanFindingsRequest describeImageScanFindingsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeImageScanFindingsResponse>> waitUntilImageScanComplete(Consumer<DescribeImageScanFindingsRequest.Builder> describeImageScanFindingsRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilImageScanComplete((DescribeImageScanFindingsRequest)((Object)((DescribeImageScanFindingsRequest.Builder)DescribeImageScanFindingsRequest.builder().applyMutation(describeImageScanFindingsRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetLifecyclePolicyPreviewResponse>> waitUntilLifecyclePolicyPreviewComplete(GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetLifecyclePolicyPreviewResponse>> waitUntilLifecyclePolicyPreviewComplete(Consumer<GetLifecyclePolicyPreviewRequest.Builder> getLifecyclePolicyPreviewRequest) {
        return this.waitUntilLifecyclePolicyPreviewComplete((GetLifecyclePolicyPreviewRequest)((Object)((GetLifecyclePolicyPreviewRequest.Builder)GetLifecyclePolicyPreviewRequest.builder().applyMutation(getLifecyclePolicyPreviewRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetLifecyclePolicyPreviewResponse>> waitUntilLifecyclePolicyPreviewComplete(GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetLifecyclePolicyPreviewResponse>> waitUntilLifecyclePolicyPreviewComplete(Consumer<GetLifecyclePolicyPreviewRequest.Builder> getLifecyclePolicyPreviewRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilLifecyclePolicyPreviewComplete((GetLifecyclePolicyPreviewRequest)((Object)((GetLifecyclePolicyPreviewRequest.Builder)GetLifecyclePolicyPreviewRequest.builder().applyMutation(getLifecyclePolicyPreviewRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultEcrAsyncWaiter.builder();
    }

    public static EcrAsyncWaiter create() {
        return DefaultEcrAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(EcrAsyncClient var1);

        public EcrAsyncWaiter build();
    }
}

