/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import software.amazon.awssdk.services.ecr.model.BatchCheckLayerAvailabilityResponse;
import software.amazon.awssdk.services.ecr.model.BatchDeleteImageRequest;
import software.amazon.awssdk.services.ecr.model.BatchDeleteImageResponse;
import software.amazon.awssdk.services.ecr.model.BatchGetImageRequest;
import software.amazon.awssdk.services.ecr.model.BatchGetImageResponse;
import software.amazon.awssdk.services.ecr.model.BatchGetRepositoryScanningConfigurationRequest;
import software.amazon.awssdk.services.ecr.model.BatchGetRepositoryScanningConfigurationResponse;
import software.amazon.awssdk.services.ecr.model.CompleteLayerUploadRequest;
import software.amazon.awssdk.services.ecr.model.CompleteLayerUploadResponse;
import software.amazon.awssdk.services.ecr.model.CreatePullThroughCacheRuleRequest;
import software.amazon.awssdk.services.ecr.model.CreatePullThroughCacheRuleResponse;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryCreationTemplateRequest;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryCreationTemplateResponse;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.ecr.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.ecr.model.DeleteLifecyclePolicyRequest;
import software.amazon.awssdk.services.ecr.model.DeleteLifecyclePolicyResponse;
import software.amazon.awssdk.services.ecr.model.DeletePullThroughCacheRuleRequest;
import software.amazon.awssdk.services.ecr.model.DeletePullThroughCacheRuleResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRegistryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRegistryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryCreationTemplateRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryCreationTemplateResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.ecr.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.ecr.model.DeregisterPullTimeUpdateExclusionRequest;
import software.amazon.awssdk.services.ecr.model.DeregisterPullTimeUpdateExclusionResponse;
import software.amazon.awssdk.services.ecr.model.DescribeImageReplicationStatusRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImageReplicationStatusResponse;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse;
import software.amazon.awssdk.services.ecr.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesRequest;
import software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesResponse;
import software.amazon.awssdk.services.ecr.model.DescribeRegistryRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRegistryResponse;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesResponse;
import software.amazon.awssdk.services.ecr.model.GetAccountSettingRequest;
import software.amazon.awssdk.services.ecr.model.GetAccountSettingResponse;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.ecr.model.GetDownloadUrlForLayerRequest;
import software.amazon.awssdk.services.ecr.model.GetDownloadUrlForLayerResponse;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyResponse;
import software.amazon.awssdk.services.ecr.model.GetRegistryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.GetRegistryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.GetRegistryScanningConfigurationRequest;
import software.amazon.awssdk.services.ecr.model.GetRegistryScanningConfigurationResponse;
import software.amazon.awssdk.services.ecr.model.GetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.GetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.InitiateLayerUploadRequest;
import software.amazon.awssdk.services.ecr.model.InitiateLayerUploadResponse;
import software.amazon.awssdk.services.ecr.model.ListImageReferrersRequest;
import software.amazon.awssdk.services.ecr.model.ListImageReferrersResponse;
import software.amazon.awssdk.services.ecr.model.ListImagesRequest;
import software.amazon.awssdk.services.ecr.model.ListImagesResponse;
import software.amazon.awssdk.services.ecr.model.ListPullTimeUpdateExclusionsRequest;
import software.amazon.awssdk.services.ecr.model.ListPullTimeUpdateExclusionsResponse;
import software.amazon.awssdk.services.ecr.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ecr.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ecr.model.PutAccountSettingRequest;
import software.amazon.awssdk.services.ecr.model.PutAccountSettingResponse;
import software.amazon.awssdk.services.ecr.model.PutImageRequest;
import software.amazon.awssdk.services.ecr.model.PutImageResponse;
import software.amazon.awssdk.services.ecr.model.PutImageScanningConfigurationRequest;
import software.amazon.awssdk.services.ecr.model.PutImageScanningConfigurationResponse;
import software.amazon.awssdk.services.ecr.model.PutImageTagMutabilityRequest;
import software.amazon.awssdk.services.ecr.model.PutImageTagMutabilityResponse;
import software.amazon.awssdk.services.ecr.model.PutLifecyclePolicyRequest;
import software.amazon.awssdk.services.ecr.model.PutLifecyclePolicyResponse;
import software.amazon.awssdk.services.ecr.model.PutRegistryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.PutRegistryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.PutRegistryScanningConfigurationRequest;
import software.amazon.awssdk.services.ecr.model.PutRegistryScanningConfigurationResponse;
import software.amazon.awssdk.services.ecr.model.PutReplicationConfigurationRequest;
import software.amazon.awssdk.services.ecr.model.PutReplicationConfigurationResponse;
import software.amazon.awssdk.services.ecr.model.RegisterPullTimeUpdateExclusionRequest;
import software.amazon.awssdk.services.ecr.model.RegisterPullTimeUpdateExclusionResponse;
import software.amazon.awssdk.services.ecr.model.SetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecr.model.SetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecr.model.StartImageScanRequest;
import software.amazon.awssdk.services.ecr.model.StartImageScanResponse;
import software.amazon.awssdk.services.ecr.model.StartLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.model.StartLifecyclePolicyPreviewResponse;
import software.amazon.awssdk.services.ecr.model.TagResourceRequest;
import software.amazon.awssdk.services.ecr.model.TagResourceResponse;
import software.amazon.awssdk.services.ecr.model.UntagResourceRequest;
import software.amazon.awssdk.services.ecr.model.UntagResourceResponse;
import software.amazon.awssdk.services.ecr.model.UpdateImageStorageClassRequest;
import software.amazon.awssdk.services.ecr.model.UpdateImageStorageClassResponse;
import software.amazon.awssdk.services.ecr.model.UpdatePullThroughCacheRuleRequest;
import software.amazon.awssdk.services.ecr.model.UpdatePullThroughCacheRuleResponse;
import software.amazon.awssdk.services.ecr.model.UpdateRepositoryCreationTemplateRequest;
import software.amazon.awssdk.services.ecr.model.UpdateRepositoryCreationTemplateResponse;
import software.amazon.awssdk.services.ecr.model.UploadLayerPartRequest;
import software.amazon.awssdk.services.ecr.model.UploadLayerPartResponse;
import software.amazon.awssdk.services.ecr.model.ValidatePullThroughCacheRuleRequest;
import software.amazon.awssdk.services.ecr.model.ValidatePullThroughCacheRuleResponse;
import software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsPublisher;
import software.amazon.awssdk.services.ecr.paginators.DescribeImagesPublisher;
import software.amazon.awssdk.services.ecr.paginators.DescribePullThroughCacheRulesPublisher;
import software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesPublisher;
import software.amazon.awssdk.services.ecr.paginators.DescribeRepositoryCreationTemplatesPublisher;
import software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewPublisher;
import software.amazon.awssdk.services.ecr.paginators.ListImagesPublisher;
import software.amazon.awssdk.services.ecr.waiters.EcrAsyncWaiter;

/**
 * Service client for accessing Amazon ECR asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Amazon Elastic Container Registry</fullname>
 * <p>
 * Amazon Elastic Container Registry (Amazon ECR) is a managed container image registry service. Customers can use the
 * familiar Docker CLI, or their preferred client, to push, pull, and manage images. Amazon ECR provides a secure,
 * scalable, and reliable registry for your Docker or Open Container Initiative (OCI) images. Amazon ECR supports
 * private repositories with resource-based permissions using IAM so that specific users or Amazon EC2 instances can
 * access repositories and images.
 * </p>
 * <p>
 * Amazon ECR has service endpoints in each supported Region. For more information, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/ecr.html">Amazon ECR endpoints</a> in the <i>Amazon Web Services
 * General Reference</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EcrAsyncClient extends AwsClient {
    String SERVICE_NAME = "ecr";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.ecr";

    /**
     * <p>
     * Checks the availability of one or more image layers in a repository.
     * </p>
     * <p>
     * When an image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If
     * it has been uploaded, then the image layer is skipped.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param batchCheckLayerAvailabilityRequest
     * @return A Java Future containing the result of the BatchCheckLayerAvailability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.BatchCheckLayerAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchCheckLayerAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCheckLayerAvailabilityResponse> batchCheckLayerAvailability(
            BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the availability of one or more image layers in a repository.
     * </p>
     * <p>
     * When an image is pushed to a repository, each image layer is checked to verify if it has been uploaded before. If
     * it has been uploaded, then the image layer is skipped.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCheckLayerAvailabilityRequest.Builder}
     * avoiding the need to create one manually via {@link BatchCheckLayerAvailabilityRequest#builder()}
     * </p>
     *
     * @param batchCheckLayerAvailabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.BatchCheckLayerAvailabilityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchCheckLayerAvailability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.BatchCheckLayerAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchCheckLayerAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCheckLayerAvailabilityResponse> batchCheckLayerAvailability(
            Consumer<BatchCheckLayerAvailabilityRequest.Builder> batchCheckLayerAvailabilityRequest) {
        return batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest.builder()
                .applyMutation(batchCheckLayerAvailabilityRequest).build());
    }

    /**
     * <p>
     * Deletes a list of specified images within a repository. Images are specified with either an <code>imageTag</code>
     * or <code>imageDigest</code>.
     * </p>
     * <p>
     * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag
     * from an image, the image is deleted from your repository.
     * </p>
     * <p>
     * You can completely delete an image (and all of its tags) by specifying the image's digest in your request.
     * </p>
     *
     * @param batchDeleteImageRequest
     *        Deletes specified images within a specified repository. Images are specified with either the
     *        <code>imageTag</code> or <code>imageDigest</code>.
     * @return A Java Future containing the result of the BatchDeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.BatchDeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchDeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteImageResponse> batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a list of specified images within a repository. Images are specified with either an <code>imageTag</code>
     * or <code>imageDigest</code>.
     * </p>
     * <p>
     * You can remove a tag from an image by specifying the image's tag in your request. When you remove the last tag
     * from an image, the image is deleted from your repository.
     * </p>
     * <p>
     * You can completely delete an image (and all of its tags) by specifying the image's digest in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteImageRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDeleteImageRequest#builder()}
     * </p>
     *
     * @param batchDeleteImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.BatchDeleteImageRequest.Builder} to create a request.
     *        Deletes specified images within a specified repository. Images are specified with either the
     *        <code>imageTag</code> or <code>imageDigest</code>.
     * @return A Java Future containing the result of the BatchDeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.BatchDeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchDeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteImageResponse> batchDeleteImage(
            Consumer<BatchDeleteImageRequest.Builder> batchDeleteImageRequest) {
        return batchDeleteImage(BatchDeleteImageRequest.builder().applyMutation(batchDeleteImageRequest).build());
    }

    /**
     * <p>
     * Gets detailed information for an image. Images are specified with either an <code>imageTag</code> or
     * <code>imageDigest</code>.
     * </p>
     * <p>
     * When an image is pulled, the BatchGetImage API is called once to retrieve the image manifest.
     * </p>
     *
     * @param batchGetImageRequest
     * @return A Java Future containing the result of the BatchGetImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>UnableToGetUpstreamImageException The image or images were unable to be pulled using the pull through
     *         cache rule. This is usually caused because of an issue with the Secrets Manager secret containing the
     *         credentials for the upstream registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.BatchGetImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchGetImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetImageResponse> batchGetImage(BatchGetImageRequest batchGetImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information for an image. Images are specified with either an <code>imageTag</code> or
     * <code>imageDigest</code>.
     * </p>
     * <p>
     * When an image is pulled, the BatchGetImage API is called once to retrieve the image manifest.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetImageRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetImageRequest#builder()}
     * </p>
     *
     * @param batchGetImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.BatchGetImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>UnableToGetUpstreamImageException The image or images were unable to be pulled using the pull through
     *         cache rule. This is usually caused because of an issue with the Secrets Manager secret containing the
     *         credentials for the upstream registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.BatchGetImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchGetImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetImageResponse> batchGetImage(Consumer<BatchGetImageRequest.Builder> batchGetImageRequest) {
        return batchGetImage(BatchGetImageRequest.builder().applyMutation(batchGetImageRequest).build());
    }

    /**
     * <p>
     * Gets the scanning configuration for one or more repositories.
     * </p>
     *
     * @param batchGetRepositoryScanningConfigurationRequest
     * @return A Java Future containing the result of the BatchGetRepositoryScanningConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.BatchGetRepositoryScanningConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchGetRepositoryScanningConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRepositoryScanningConfigurationResponse> batchGetRepositoryScanningConfiguration(
            BatchGetRepositoryScanningConfigurationRequest batchGetRepositoryScanningConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the scanning configuration for one or more repositories.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchGetRepositoryScanningConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link BatchGetRepositoryScanningConfigurationRequest#builder()}
     * </p>
     *
     * @param batchGetRepositoryScanningConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.BatchGetRepositoryScanningConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchGetRepositoryScanningConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.BatchGetRepositoryScanningConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/BatchGetRepositoryScanningConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRepositoryScanningConfigurationResponse> batchGetRepositoryScanningConfiguration(
            Consumer<BatchGetRepositoryScanningConfigurationRequest.Builder> batchGetRepositoryScanningConfigurationRequest) {
        return batchGetRepositoryScanningConfiguration(BatchGetRepositoryScanningConfigurationRequest.builder()
                .applyMutation(batchGetRepositoryScanningConfigurationRequest).build());
    }

    /**
     * <p>
     * Informs Amazon ECR that the image layer upload has completed for a specified registry, repository name, and
     * upload ID. You can optionally provide a <code>sha256</code> digest of the image layer for data validation
     * purposes.
     * </p>
     * <p>
     * When an image is pushed, the CompleteLayerUpload API is called once per each new image layer to verify that the
     * upload has completed.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param completeLayerUploadRequest
     * @return A Java Future containing the result of the CompleteLayerUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>UploadNotFoundException The upload could not be found, or the specified upload ID is not valid for
     *         this repository.</li>
     *         <li>InvalidLayerException The layer digest calculation performed by Amazon ECR upon receipt of the image
     *         layer does not match the digest specified.</li>
     *         <li>LayerPartTooSmallException Layer parts must be at least 5 MiB in size.</li>
     *         <li>LayerAlreadyExistsException The image layer already exists in the associated repository.</li>
     *         <li>EmptyUploadException The specified layer upload does not contain any layer parts.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.CompleteLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CompleteLayerUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CompleteLayerUploadResponse> completeLayerUpload(
            CompleteLayerUploadRequest completeLayerUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Informs Amazon ECR that the image layer upload has completed for a specified registry, repository name, and
     * upload ID. You can optionally provide a <code>sha256</code> digest of the image layer for data validation
     * purposes.
     * </p>
     * <p>
     * When an image is pushed, the CompleteLayerUpload API is called once per each new image layer to verify that the
     * upload has completed.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteLayerUploadRequest.Builder} avoiding the
     * need to create one manually via {@link CompleteLayerUploadRequest#builder()}
     * </p>
     *
     * @param completeLayerUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.CompleteLayerUploadRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CompleteLayerUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>UploadNotFoundException The upload could not be found, or the specified upload ID is not valid for
     *         this repository.</li>
     *         <li>InvalidLayerException The layer digest calculation performed by Amazon ECR upon receipt of the image
     *         layer does not match the digest specified.</li>
     *         <li>LayerPartTooSmallException Layer parts must be at least 5 MiB in size.</li>
     *         <li>LayerAlreadyExistsException The image layer already exists in the associated repository.</li>
     *         <li>EmptyUploadException The specified layer upload does not contain any layer parts.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.CompleteLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CompleteLayerUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CompleteLayerUploadResponse> completeLayerUpload(
            Consumer<CompleteLayerUploadRequest.Builder> completeLayerUploadRequest) {
        return completeLayerUpload(CompleteLayerUploadRequest.builder().applyMutation(completeLayerUploadRequest).build());
    }

    /**
     * <p>
     * Creates a pull through cache rule. A pull through cache rule provides a way to cache images from an upstream
     * registry source in your Amazon ECR private registry. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html">Using pull through cache
     * rules</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param createPullThroughCacheRuleRequest
     * @return A Java Future containing the result of the CreatePullThroughCacheRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>PullThroughCacheRuleAlreadyExistsException A pull through cache rule with these settings already
     *         exists for the private registry.</li>
     *         <li>UnsupportedUpstreamRegistryException The specified upstream registry isn't supported.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>UnableToAccessSecretException The secret is unable to be accessed. Verify the resource permissions
     *         for the secret and try again.</li>
     *         <li>SecretNotFoundException The ARN of the secret specified in the pull through cache rule was not found.
     *         Update the pull through cache rule with a valid secret ARN and try again.</li>
     *         <li>UnableToDecryptSecretValueException The secret is accessible but is unable to be decrypted. Verify
     *         the resource permisisons and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.CreatePullThroughCacheRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreatePullThroughCacheRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePullThroughCacheRuleResponse> createPullThroughCacheRule(
            CreatePullThroughCacheRuleRequest createPullThroughCacheRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pull through cache rule. A pull through cache rule provides a way to cache images from an upstream
     * registry source in your Amazon ECR private registry. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html">Using pull through cache
     * rules</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePullThroughCacheRuleRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePullThroughCacheRuleRequest#builder()}
     * </p>
     *
     * @param createPullThroughCacheRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.CreatePullThroughCacheRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePullThroughCacheRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>PullThroughCacheRuleAlreadyExistsException A pull through cache rule with these settings already
     *         exists for the private registry.</li>
     *         <li>UnsupportedUpstreamRegistryException The specified upstream registry isn't supported.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>UnableToAccessSecretException The secret is unable to be accessed. Verify the resource permissions
     *         for the secret and try again.</li>
     *         <li>SecretNotFoundException The ARN of the secret specified in the pull through cache rule was not found.
     *         Update the pull through cache rule with a valid secret ARN and try again.</li>
     *         <li>UnableToDecryptSecretValueException The secret is accessible but is unable to be decrypted. Verify
     *         the resource permisisons and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.CreatePullThroughCacheRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreatePullThroughCacheRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePullThroughCacheRuleResponse> createPullThroughCacheRule(
            Consumer<CreatePullThroughCacheRuleRequest.Builder> createPullThroughCacheRuleRequest) {
        return createPullThroughCacheRule(CreatePullThroughCacheRuleRequest.builder()
                .applyMutation(createPullThroughCacheRuleRequest).build());
    }

    /**
     * <p>
     * Creates a repository. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR repositories</a> in
     * the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param createRepositoryRequest
     * @return A Java Future containing the result of the CreateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryAlreadyExistsException The specified repository already exists in the specified registry.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.CreateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreateRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest createRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a repository. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html">Amazon ECR repositories</a> in
     * the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRepositoryRequest#builder()}
     * </p>
     *
     * @param createRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.CreateRepositoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryAlreadyExistsException The specified repository already exists in the specified registry.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.CreateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreateRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRepositoryResponse> createRepository(
            Consumer<CreateRepositoryRequest.Builder> createRepositoryRequest) {
        return createRepository(CreateRepositoryRequest.builder().applyMutation(createRepositoryRequest).build());
    }

    /**
     * <p>
     * Creates a repository creation template. This template is used to define the settings for repositories created by
     * Amazon ECR on your behalf. For example, repositories created through pull through cache actions. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-creation-templates.html">Private
     * repository creation templates</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param createRepositoryCreationTemplateRequest
     * @return A Java Future containing the result of the CreateRepositoryCreationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>TemplateAlreadyExistsException The repository creation template already exists. Specify a unique
     *         prefix and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.CreateRepositoryCreationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreateRepositoryCreationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRepositoryCreationTemplateResponse> createRepositoryCreationTemplate(
            CreateRepositoryCreationTemplateRequest createRepositoryCreationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a repository creation template. This template is used to define the settings for repositories created by
     * Amazon ECR on your behalf. For example, repositories created through pull through cache actions. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-creation-templates.html">Private
     * repository creation templates</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRepositoryCreationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRepositoryCreationTemplateRequest#builder()}
     * </p>
     *
     * @param createRepositoryCreationTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.CreateRepositoryCreationTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateRepositoryCreationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>TemplateAlreadyExistsException The repository creation template already exists. Specify a unique
     *         prefix and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.CreateRepositoryCreationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreateRepositoryCreationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRepositoryCreationTemplateResponse> createRepositoryCreationTemplate(
            Consumer<CreateRepositoryCreationTemplateRequest.Builder> createRepositoryCreationTemplateRequest) {
        return createRepositoryCreationTemplate(CreateRepositoryCreationTemplateRequest.builder()
                .applyMutation(createRepositoryCreationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the lifecycle policy associated with the specified repository.
     * </p>
     *
     * @param deleteLifecyclePolicyRequest
     * @return A Java Future containing the result of the DeleteLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LifecyclePolicyNotFoundException The lifecycle policy could not be found, and no policy is set to the
     *         repository.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeleteLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLifecyclePolicyResponse> deleteLifecyclePolicy(
            DeleteLifecyclePolicyRequest deleteLifecyclePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the lifecycle policy associated with the specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param deleteLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DeleteLifecyclePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LifecyclePolicyNotFoundException The lifecycle policy could not be found, and no policy is set to the
     *         repository.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeleteLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLifecyclePolicyResponse> deleteLifecyclePolicy(
            Consumer<DeleteLifecyclePolicyRequest.Builder> deleteLifecyclePolicyRequest) {
        return deleteLifecyclePolicy(DeleteLifecyclePolicyRequest.builder().applyMutation(deleteLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a pull through cache rule.
     * </p>
     *
     * @param deletePullThroughCacheRuleRequest
     * @return A Java Future containing the result of the DeletePullThroughCacheRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>PullThroughCacheRuleNotFoundException The pull through cache rule was not found. Specify a valid pull
     *         through cache rule and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeletePullThroughCacheRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeletePullThroughCacheRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePullThroughCacheRuleResponse> deletePullThroughCacheRule(
            DeletePullThroughCacheRuleRequest deletePullThroughCacheRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a pull through cache rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePullThroughCacheRuleRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePullThroughCacheRuleRequest#builder()}
     * </p>
     *
     * @param deletePullThroughCacheRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DeletePullThroughCacheRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePullThroughCacheRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>PullThroughCacheRuleNotFoundException The pull through cache rule was not found. Specify a valid pull
     *         through cache rule and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeletePullThroughCacheRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeletePullThroughCacheRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePullThroughCacheRuleResponse> deletePullThroughCacheRule(
            Consumer<DeletePullThroughCacheRuleRequest.Builder> deletePullThroughCacheRuleRequest) {
        return deletePullThroughCacheRule(DeletePullThroughCacheRuleRequest.builder()
                .applyMutation(deletePullThroughCacheRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the registry permissions policy.
     * </p>
     *
     * @param deleteRegistryPolicyRequest
     * @return A Java Future containing the result of the DeleteRegistryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RegistryPolicyNotFoundException The registry doesn't have an associated registry policy.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeleteRegistryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRegistryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRegistryPolicyResponse> deleteRegistryPolicy(
            DeleteRegistryPolicyRequest deleteRegistryPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the registry permissions policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRegistryPolicyRequest#builder()}
     * </p>
     *
     * @param deleteRegistryPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DeleteRegistryPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRegistryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RegistryPolicyNotFoundException The registry doesn't have an associated registry policy.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeleteRegistryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRegistryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRegistryPolicyResponse> deleteRegistryPolicy(
            Consumer<DeleteRegistryPolicyRequest.Builder> deleteRegistryPolicyRequest) {
        return deleteRegistryPolicy(DeleteRegistryPolicyRequest.builder().applyMutation(deleteRegistryPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a repository. If the repository isn't empty, you must either delete the contents of the repository or use
     * the <code>force</code> option to delete the repository and have Amazon ECR delete all of its contents on your
     * behalf.
     * </p>
     *
     * @param deleteRepositoryRequest
     * @return A Java Future containing the result of the DeleteRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>RepositoryNotEmptyException The specified repository contains images. To delete a repository that
     *         contains images, you must force the deletion with the <code>force</code> parameter.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeleteRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a repository. If the repository isn't empty, you must either delete the contents of the repository or use
     * the <code>force</code> option to delete the repository and have Amazon ECR delete all of its contents on your
     * behalf.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRepositoryRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DeleteRepositoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>RepositoryNotEmptyException The specified repository contains images. To delete a repository that
     *         contains images, you must force the deletion with the <code>force</code> parameter.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeleteRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryResponse> deleteRepository(
            Consumer<DeleteRepositoryRequest.Builder> deleteRepositoryRequest) {
        return deleteRepository(DeleteRepositoryRequest.builder().applyMutation(deleteRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes a repository creation template.
     * </p>
     *
     * @param deleteRepositoryCreationTemplateRequest
     * @return A Java Future containing the result of the DeleteRepositoryCreationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>TemplateNotFoundException The specified repository creation template can't be found. Verify the
     *         registry ID and prefix and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeleteRepositoryCreationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryCreationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryCreationTemplateResponse> deleteRepositoryCreationTemplate(
            DeleteRepositoryCreationTemplateRequest deleteRepositoryCreationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a repository creation template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryCreationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRepositoryCreationTemplateRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryCreationTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DeleteRepositoryCreationTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRepositoryCreationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>TemplateNotFoundException The specified repository creation template can't be found. Verify the
     *         registry ID and prefix and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeleteRepositoryCreationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryCreationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryCreationTemplateResponse> deleteRepositoryCreationTemplate(
            Consumer<DeleteRepositoryCreationTemplateRequest.Builder> deleteRepositoryCreationTemplateRequest) {
        return deleteRepositoryCreationTemplate(DeleteRepositoryCreationTemplateRequest.builder()
                .applyMutation(deleteRepositoryCreationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the repository policy associated with the specified repository.
     * </p>
     *
     * @param deleteRepositoryPolicyRequest
     * @return A Java Future containing the result of the DeleteRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>RepositoryPolicyNotFoundException The specified repository and registry combination does not have an
     *         associated repository policy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeleteRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryPolicyResponse> deleteRepositoryPolicy(
            DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the repository policy associated with the specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DeleteRepositoryPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>RepositoryPolicyNotFoundException The specified repository and registry combination does not have an
     *         associated repository policy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeleteRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeleteRepositoryPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryPolicyResponse> deleteRepositoryPolicy(
            Consumer<DeleteRepositoryPolicyRequest.Builder> deleteRepositoryPolicyRequest) {
        return deleteRepositoryPolicy(DeleteRepositoryPolicyRequest.builder().applyMutation(deleteRepositoryPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Removes a principal from the pull time update exclusion list for a registry. Once removed, Amazon ECR will resume
     * updating the pull time if the specified principal pulls an image.
     * </p>
     *
     * @param deregisterPullTimeUpdateExclusionRequest
     * @return A Java Future containing the result of the DeregisterPullTimeUpdateExclusion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ExclusionNotFoundException The specified pull time update exclusion was not found.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeregisterPullTimeUpdateExclusion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeregisterPullTimeUpdateExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterPullTimeUpdateExclusionResponse> deregisterPullTimeUpdateExclusion(
            DeregisterPullTimeUpdateExclusionRequest deregisterPullTimeUpdateExclusionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a principal from the pull time update exclusion list for a registry. Once removed, Amazon ECR will resume
     * updating the pull time if the specified principal pulls an image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterPullTimeUpdateExclusionRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterPullTimeUpdateExclusionRequest#builder()}
     * </p>
     *
     * @param deregisterPullTimeUpdateExclusionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DeregisterPullTimeUpdateExclusionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeregisterPullTimeUpdateExclusion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ExclusionNotFoundException The specified pull time update exclusion was not found.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DeregisterPullTimeUpdateExclusion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DeregisterPullTimeUpdateExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterPullTimeUpdateExclusionResponse> deregisterPullTimeUpdateExclusion(
            Consumer<DeregisterPullTimeUpdateExclusionRequest.Builder> deregisterPullTimeUpdateExclusionRequest) {
        return deregisterPullTimeUpdateExclusion(DeregisterPullTimeUpdateExclusionRequest.builder()
                .applyMutation(deregisterPullTimeUpdateExclusionRequest).build());
    }

    /**
     * <p>
     * Returns the replication status for a specified image.
     * </p>
     *
     * @param describeImageReplicationStatusRequest
     * @return A Java Future containing the result of the DescribeImageReplicationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeImageReplicationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImageReplicationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeImageReplicationStatusResponse> describeImageReplicationStatus(
            DescribeImageReplicationStatusRequest describeImageReplicationStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the replication status for a specified image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageReplicationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeImageReplicationStatusRequest#builder()}
     * </p>
     *
     * @param describeImageReplicationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribeImageReplicationStatusRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeImageReplicationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeImageReplicationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImageReplicationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeImageReplicationStatusResponse> describeImageReplicationStatus(
            Consumer<DescribeImageReplicationStatusRequest.Builder> describeImageReplicationStatusRequest) {
        return describeImageReplicationStatus(DescribeImageReplicationStatusRequest.builder()
                .applyMutation(describeImageReplicationStatusRequest).build());
    }

    /**
     * <p>
     * Returns the scan findings for the specified image.
     * </p>
     *
     * @param describeImageScanFindingsRequest
     * @return A Java Future containing the result of the DescribeImageScanFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>ScanNotFoundException The specified image scan could not be found. Ensure that image scanning is
     *         enabled on the repository and try again.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeImageScanFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImageScanFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeImageScanFindingsResponse> describeImageScanFindings(
            DescribeImageScanFindingsRequest describeImageScanFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the scan findings for the specified image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageScanFindingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeImageScanFindingsRequest#builder()}
     * </p>
     *
     * @param describeImageScanFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeImageScanFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>ScanNotFoundException The specified image scan could not be found. Ensure that image scanning is
     *         enabled on the repository and try again.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeImageScanFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImageScanFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeImageScanFindingsResponse> describeImageScanFindings(
            Consumer<DescribeImageScanFindingsRequest.Builder> describeImageScanFindingsRequest) {
        return describeImageScanFindings(DescribeImageScanFindingsRequest.builder()
                .applyMutation(describeImageScanFindingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeImageScanFindings(software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsPublisher publisher = client.describeImageScanFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsPublisher publisher = client.describeImageScanFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImageScanFindings(software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeImageScanFindingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>ScanNotFoundException The specified image scan could not be found. Ensure that image scanning is
     *         enabled on the repository and try again.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeImageScanFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImageScanFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageScanFindingsPublisher describeImageScanFindingsPaginator(
            DescribeImageScanFindingsRequest describeImageScanFindingsRequest) {
        return new DescribeImageScanFindingsPublisher(this, describeImageScanFindingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeImageScanFindings(software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsPublisher publisher = client.describeImageScanFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImageScanFindingsPublisher publisher = client.describeImageScanFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImageScanFindings(software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageScanFindingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeImageScanFindingsRequest#builder()}
     * </p>
     *
     * @param describeImageScanFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>ScanNotFoundException The specified image scan could not be found. Ensure that image scanning is
     *         enabled on the repository and try again.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeImageScanFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImageScanFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeImageScanFindingsPublisher describeImageScanFindingsPaginator(
            Consumer<DescribeImageScanFindingsRequest.Builder> describeImageScanFindingsRequest) {
        return describeImageScanFindingsPaginator(DescribeImageScanFindingsRequest.builder()
                .applyMutation(describeImageScanFindingsRequest).build());
    }

    /**
     * <p>
     * Returns metadata about the images in a repository.
     * </p>
     * <note>
     * <p>
     * Starting with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size. Therefore,
     * Docker might return a larger image than the image shown in the Amazon Web Services Management Console.
     * </p>
     * </note> <important>
     * <p>
     * The new version of Amazon ECR <i>Basic Scanning</i> doesn't use the
     * <a>ImageDetail&#36imageScanFindingsSummary</a> and <a>ImageDetail&#36imageScanStatus</a> attributes from the API
     * response to return scan results. Use the <a>DescribeImageScanFindings</a> API instead. For more information about
     * Amazon Web Services native basic scanning, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html"> Scan images for software
     * vulnerabilities in Amazon ECR</a>.
     * </p>
     * </important>
     *
     * @param describeImagesRequest
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeImagesResponse> describeImages(DescribeImagesRequest describeImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about the images in a repository.
     * </p>
     * <note>
     * <p>
     * Starting with Docker version 1.9, the Docker client compresses image layers before pushing them to a V2 Docker
     * registry. The output of the <code>docker images</code> command shows the uncompressed image size. Therefore,
     * Docker might return a larger image than the image shown in the Amazon Web Services Management Console.
     * </p>
     * </note> <important>
     * <p>
     * The new version of Amazon ECR <i>Basic Scanning</i> doesn't use the
     * <a>ImageDetail&#36imageScanFindingsSummary</a> and <a>ImageDetail&#36imageScanStatus</a> attributes from the API
     * response to return scan results. Use the <a>DescribeImageScanFindings</a> API instead. For more information about
     * Amazon Web Services native basic scanning, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html"> Scan images for software
     * vulnerabilities in Amazon ECR</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribeImagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeImagesResponse> describeImages(Consumer<DescribeImagesRequest.Builder> describeImagesRequest) {
        return describeImages(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #describeImages(software.amazon.awssdk.services.ecr.model.DescribeImagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImagesPublisher publisher = client.describeImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImagesPublisher publisher = client.describeImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.DescribeImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.DescribeImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.ecr.model.DescribeImagesRequest)} operation.</b>
     * </p>
     *
     * @param describeImagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesPublisher describeImagesPaginator(DescribeImagesRequest describeImagesRequest) {
        return new DescribeImagesPublisher(this, describeImagesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #describeImages(software.amazon.awssdk.services.ecr.model.DescribeImagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImagesPublisher publisher = client.describeImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeImagesPublisher publisher = client.describeImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.DescribeImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.DescribeImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.ecr.model.DescribeImagesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribeImagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesPublisher describeImagesPaginator(Consumer<DescribeImagesRequest.Builder> describeImagesRequest) {
        return describeImagesPaginator(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * Returns the pull through cache rules for a registry.
     * </p>
     *
     * @param describePullThroughCacheRulesRequest
     * @return A Java Future containing the result of the DescribePullThroughCacheRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>PullThroughCacheRuleNotFoundException The pull through cache rule was not found. Specify a valid pull
     *         through cache rule and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribePullThroughCacheRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribePullThroughCacheRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePullThroughCacheRulesResponse> describePullThroughCacheRules(
            DescribePullThroughCacheRulesRequest describePullThroughCacheRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the pull through cache rules for a registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePullThroughCacheRulesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePullThroughCacheRulesRequest#builder()}
     * </p>
     *
     * @param describePullThroughCacheRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePullThroughCacheRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>PullThroughCacheRuleNotFoundException The pull through cache rule was not found. Specify a valid pull
     *         through cache rule and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribePullThroughCacheRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribePullThroughCacheRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePullThroughCacheRulesResponse> describePullThroughCacheRules(
            Consumer<DescribePullThroughCacheRulesRequest.Builder> describePullThroughCacheRulesRequest) {
        return describePullThroughCacheRules(DescribePullThroughCacheRulesRequest.builder()
                .applyMutation(describePullThroughCacheRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePullThroughCacheRules(software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribePullThroughCacheRulesPublisher publisher = client.describePullThroughCacheRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribePullThroughCacheRulesPublisher publisher = client.describePullThroughCacheRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePullThroughCacheRules(software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePullThroughCacheRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>PullThroughCacheRuleNotFoundException The pull through cache rule was not found. Specify a valid pull
     *         through cache rule and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribePullThroughCacheRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribePullThroughCacheRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePullThroughCacheRulesPublisher describePullThroughCacheRulesPaginator(
            DescribePullThroughCacheRulesRequest describePullThroughCacheRulesRequest) {
        return new DescribePullThroughCacheRulesPublisher(this, describePullThroughCacheRulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePullThroughCacheRules(software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribePullThroughCacheRulesPublisher publisher = client.describePullThroughCacheRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribePullThroughCacheRulesPublisher publisher = client.describePullThroughCacheRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePullThroughCacheRules(software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePullThroughCacheRulesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePullThroughCacheRulesRequest#builder()}
     * </p>
     *
     * @param describePullThroughCacheRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>PullThroughCacheRuleNotFoundException The pull through cache rule was not found. Specify a valid pull
     *         through cache rule and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribePullThroughCacheRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribePullThroughCacheRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePullThroughCacheRulesPublisher describePullThroughCacheRulesPaginator(
            Consumer<DescribePullThroughCacheRulesRequest.Builder> describePullThroughCacheRulesRequest) {
        return describePullThroughCacheRulesPaginator(DescribePullThroughCacheRulesRequest.builder()
                .applyMutation(describePullThroughCacheRulesRequest).build());
    }

    /**
     * <p>
     * Describes the settings for a registry. The replication configuration for a repository can be created or updated
     * with the <a>PutReplicationConfiguration</a> API action.
     * </p>
     *
     * @param describeRegistryRequest
     * @return A Java Future containing the result of the DescribeRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRegistryResponse> describeRegistry(DescribeRegistryRequest describeRegistryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the settings for a registry. The replication configuration for a repository can be created or updated
     * with the <a>PutReplicationConfiguration</a> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistryRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeRegistryRequest#builder()}
     * </p>
     *
     * @param describeRegistryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribeRegistryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRegistryResponse> describeRegistry(
            Consumer<DescribeRegistryRequest.Builder> describeRegistryRequest) {
        return describeRegistry(DescribeRegistryRequest.builder().applyMutation(describeRegistryRequest).build());
    }

    /**
     * <p>
     * Describes image repositories in a registry.
     * </p>
     *
     * @param describeRepositoriesRequest
     * @return A Java Future containing the result of the DescribeRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRepositoriesResponse> describeRepositories(
            DescribeRepositoriesRequest describeRepositoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes image repositories in a registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRepositoriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRepositoriesRequest#builder()}
     * </p>
     *
     * @param describeRepositoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRepositoriesResponse> describeRepositories(
            Consumer<DescribeRepositoriesRequest.Builder> describeRepositoriesRequest) {
        return describeRepositories(DescribeRepositoriesRequest.builder().applyMutation(describeRepositoriesRequest).build());
    }

    /**
     * <p>
     * Describes image repositories in a registry.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRepositoriesResponse> describeRepositories() {
        return describeRepositories(DescribeRepositoriesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesPublisher publisher = client.describeRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesPublisher publisher = client.describeRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRepositoriesPublisher describeRepositoriesPaginator() {
        return describeRepositoriesPaginator(DescribeRepositoriesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesPublisher publisher = client.describeRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesPublisher publisher = client.describeRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRepositoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRepositoriesPublisher describeRepositoriesPaginator(DescribeRepositoriesRequest describeRepositoriesRequest) {
        return new DescribeRepositoriesPublisher(this, describeRepositoriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesPublisher publisher = client.describeRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoriesPublisher publisher = client.describeRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositories(software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRepositoriesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRepositoriesRequest#builder()}
     * </p>
     *
     * @param describeRepositoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositories" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRepositoriesPublisher describeRepositoriesPaginator(
            Consumer<DescribeRepositoriesRequest.Builder> describeRepositoriesRequest) {
        return describeRepositoriesPaginator(DescribeRepositoriesRequest.builder().applyMutation(describeRepositoriesRequest)
                .build());
    }

    /**
     * <p>
     * Returns details about the repository creation templates in a registry. The <code>prefixes</code> request
     * parameter can be used to return the details for a specific repository creation template.
     * </p>
     *
     * @param describeRepositoryCreationTemplatesRequest
     * @return A Java Future containing the result of the DescribeRepositoryCreationTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRepositoryCreationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositoryCreationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRepositoryCreationTemplatesResponse> describeRepositoryCreationTemplates(
            DescribeRepositoryCreationTemplatesRequest describeRepositoryCreationTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the repository creation templates in a registry. The <code>prefixes</code> request
     * parameter can be used to return the details for a specific repository creation template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRepositoryCreationTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRepositoryCreationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeRepositoryCreationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRepositoryCreationTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRepositoryCreationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositoryCreationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRepositoryCreationTemplatesResponse> describeRepositoryCreationTemplates(
            Consumer<DescribeRepositoryCreationTemplatesRequest.Builder> describeRepositoryCreationTemplatesRequest) {
        return describeRepositoryCreationTemplates(DescribeRepositoryCreationTemplatesRequest.builder()
                .applyMutation(describeRepositoryCreationTemplatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRepositoryCreationTemplates(software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoryCreationTemplatesPublisher publisher = client.describeRepositoryCreationTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoryCreationTemplatesPublisher publisher = client.describeRepositoryCreationTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositoryCreationTemplates(software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRepositoryCreationTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRepositoryCreationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositoryCreationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRepositoryCreationTemplatesPublisher describeRepositoryCreationTemplatesPaginator(
            DescribeRepositoryCreationTemplatesRequest describeRepositoryCreationTemplatesRequest) {
        return new DescribeRepositoryCreationTemplatesPublisher(this, describeRepositoryCreationTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRepositoryCreationTemplates(software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoryCreationTemplatesPublisher publisher = client.describeRepositoryCreationTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.DescribeRepositoryCreationTemplatesPublisher publisher = client.describeRepositoryCreationTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRepositoryCreationTemplates(software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRepositoryCreationTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRepositoryCreationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeRepositoryCreationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.DescribeRepositoryCreationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/DescribeRepositoryCreationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRepositoryCreationTemplatesPublisher describeRepositoryCreationTemplatesPaginator(
            Consumer<DescribeRepositoryCreationTemplatesRequest.Builder> describeRepositoryCreationTemplatesRequest) {
        return describeRepositoryCreationTemplatesPaginator(DescribeRepositoryCreationTemplatesRequest.builder()
                .applyMutation(describeRepositoryCreationTemplatesRequest).build());
    }

    /**
     * <p>
     * Retrieves the account setting value for the specified setting name.
     * </p>
     *
     * @param getAccountSettingRequest
     * @return A Java Future containing the result of the GetAccountSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetAccountSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAccountSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingResponse> getAccountSetting(GetAccountSettingRequest getAccountSettingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the account setting value for the specified setting name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccountSettingRequest#builder()}
     * </p>
     *
     * @param getAccountSettingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.GetAccountSettingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAccountSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetAccountSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAccountSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingResponse> getAccountSetting(
            Consumer<GetAccountSettingRequest.Builder> getAccountSettingRequest) {
        return getAccountSetting(GetAccountSettingRequest.builder().applyMutation(getAccountSettingRequest).build());
    }

    /**
     * <p>
     * Retrieves an authorization token. An authorization token represents your IAM authentication credentials and can
     * be used to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid
     * for 12 hours.
     * </p>
     * <p>
     * The <code>authorizationToken</code> returned is a base64 encoded string that can be decoded and used in a
     * <code>docker login</code> command to authenticate to a registry. The CLI offers an
     * <code>get-login-password</code> command that simplifies the login process. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html#registry_auth">Registry
     * authentication</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param getAuthorizationTokenRequest
     * @return A Java Future containing the result of the GetAuthorizationToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetAuthorizationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAuthorizationToken" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAuthorizationTokenResponse> getAuthorizationToken(
            GetAuthorizationTokenRequest getAuthorizationTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an authorization token. An authorization token represents your IAM authentication credentials and can
     * be used to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid
     * for 12 hours.
     * </p>
     * <p>
     * The <code>authorizationToken</code> returned is a base64 encoded string that can be decoded and used in a
     * <code>docker login</code> command to authenticate to a registry. The CLI offers an
     * <code>get-login-password</code> command that simplifies the login process. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html#registry_auth">Registry
     * authentication</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthorizationTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetAuthorizationTokenRequest#builder()}
     * </p>
     *
     * @param getAuthorizationTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAuthorizationToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetAuthorizationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAuthorizationToken" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAuthorizationTokenResponse> getAuthorizationToken(
            Consumer<GetAuthorizationTokenRequest.Builder> getAuthorizationTokenRequest) {
        return getAuthorizationToken(GetAuthorizationTokenRequest.builder().applyMutation(getAuthorizationTokenRequest).build());
    }

    /**
     * <p>
     * Retrieves an authorization token. An authorization token represents your IAM authentication credentials and can
     * be used to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid
     * for 12 hours.
     * </p>
     * <p>
     * The <code>authorizationToken</code> returned is a base64 encoded string that can be decoded and used in a
     * <code>docker login</code> command to authenticate to a registry. The CLI offers an
     * <code>get-login-password</code> command that simplifies the login process. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html#registry_auth">Registry
     * authentication</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the GetAuthorizationToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetAuthorizationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetAuthorizationToken" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAuthorizationTokenResponse> getAuthorizationToken() {
        return getAuthorizationToken(GetAuthorizationTokenRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can only get URLs for image
     * layers that are referenced in an image.
     * </p>
     * <p>
     * When an image is pulled, the GetDownloadUrlForLayer API is called once per image layer that is not already
     * cached.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param getDownloadUrlForLayerRequest
     * @return A Java Future containing the result of the GetDownloadUrlForLayer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>LayersNotFoundException The specified layers could not be found, or the specified layer is not valid
     *         for this repository.</li>
     *         <li>LayerInaccessibleException The specified layer is not available because it is not associated with an
     *         image. Unassociated image layers may be cleaned up at any time.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>UnableToGetUpstreamLayerException There was an issue getting the upstream layer matching the pull
     *         through cache rule.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetDownloadUrlForLayer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetDownloadUrlForLayer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDownloadUrlForLayerResponse> getDownloadUrlForLayer(
            GetDownloadUrlForLayerRequest getDownloadUrlForLayerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can only get URLs for image
     * layers that are referenced in an image.
     * </p>
     * <p>
     * When an image is pulled, the GetDownloadUrlForLayer API is called once per image layer that is not already
     * cached.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDownloadUrlForLayerRequest.Builder} avoiding the
     * need to create one manually via {@link GetDownloadUrlForLayerRequest#builder()}
     * </p>
     *
     * @param getDownloadUrlForLayerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.GetDownloadUrlForLayerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDownloadUrlForLayer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>LayersNotFoundException The specified layers could not be found, or the specified layer is not valid
     *         for this repository.</li>
     *         <li>LayerInaccessibleException The specified layer is not available because it is not associated with an
     *         image. Unassociated image layers may be cleaned up at any time.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>UnableToGetUpstreamLayerException There was an issue getting the upstream layer matching the pull
     *         through cache rule.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetDownloadUrlForLayer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetDownloadUrlForLayer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDownloadUrlForLayerResponse> getDownloadUrlForLayer(
            Consumer<GetDownloadUrlForLayerRequest.Builder> getDownloadUrlForLayerRequest) {
        return getDownloadUrlForLayer(GetDownloadUrlForLayerRequest.builder().applyMutation(getDownloadUrlForLayerRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the lifecycle policy for the specified repository.
     * </p>
     *
     * @param getLifecyclePolicyRequest
     * @return A Java Future containing the result of the GetLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LifecyclePolicyNotFoundException The lifecycle policy could not be found, and no policy is set to the
     *         repository.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLifecyclePolicyResponse> getLifecyclePolicy(GetLifecyclePolicyRequest getLifecyclePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the lifecycle policy for the specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param getLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LifecyclePolicyNotFoundException The lifecycle policy could not be found, and no policy is set to the
     *         repository.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLifecyclePolicyResponse> getLifecyclePolicy(
            Consumer<GetLifecyclePolicyRequest.Builder> getLifecyclePolicyRequest) {
        return getLifecyclePolicy(GetLifecyclePolicyRequest.builder().applyMutation(getLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the results of the lifecycle policy preview request for the specified repository.
     * </p>
     *
     * @param getLifecyclePolicyPreviewRequest
     * @return A Java Future containing the result of the GetLifecyclePolicyPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LifecyclePolicyPreviewNotFoundException There is no dry run for this repository.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetLifecyclePolicyPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicyPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLifecyclePolicyPreviewResponse> getLifecyclePolicyPreview(
            GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the results of the lifecycle policy preview request for the specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLifecyclePolicyPreviewRequest.Builder} avoiding
     * the need to create one manually via {@link GetLifecyclePolicyPreviewRequest#builder()}
     * </p>
     *
     * @param getLifecyclePolicyPreviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLifecyclePolicyPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LifecyclePolicyPreviewNotFoundException There is no dry run for this repository.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetLifecyclePolicyPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicyPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLifecyclePolicyPreviewResponse> getLifecyclePolicyPreview(
            Consumer<GetLifecyclePolicyPreviewRequest.Builder> getLifecyclePolicyPreviewRequest) {
        return getLifecyclePolicyPreview(GetLifecyclePolicyPreviewRequest.builder()
                .applyMutation(getLifecyclePolicyPreviewRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getLifecyclePolicyPreview(software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewPublisher publisher = client.getLifecyclePolicyPreviewPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewPublisher publisher = client.getLifecyclePolicyPreviewPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLifecyclePolicyPreview(software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest)}
     * operation.</b>
     * </p>
     *
     * @param getLifecyclePolicyPreviewRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LifecyclePolicyPreviewNotFoundException There is no dry run for this repository.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetLifecyclePolicyPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicyPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLifecyclePolicyPreviewPublisher getLifecyclePolicyPreviewPaginator(
            GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest) {
        return new GetLifecyclePolicyPreviewPublisher(this, getLifecyclePolicyPreviewRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getLifecyclePolicyPreview(software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewPublisher publisher = client.getLifecyclePolicyPreviewPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.GetLifecyclePolicyPreviewPublisher publisher = client.getLifecyclePolicyPreviewPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLifecyclePolicyPreview(software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLifecyclePolicyPreviewRequest.Builder} avoiding
     * the need to create one manually via {@link GetLifecyclePolicyPreviewRequest#builder()}
     * </p>
     *
     * @param getLifecyclePolicyPreviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LifecyclePolicyPreviewNotFoundException There is no dry run for this repository.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetLifecyclePolicyPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetLifecyclePolicyPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLifecyclePolicyPreviewPublisher getLifecyclePolicyPreviewPaginator(
            Consumer<GetLifecyclePolicyPreviewRequest.Builder> getLifecyclePolicyPreviewRequest) {
        return getLifecyclePolicyPreviewPaginator(GetLifecyclePolicyPreviewRequest.builder()
                .applyMutation(getLifecyclePolicyPreviewRequest).build());
    }

    /**
     * <p>
     * Retrieves the permissions policy for a registry.
     * </p>
     *
     * @param getRegistryPolicyRequest
     * @return A Java Future containing the result of the GetRegistryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RegistryPolicyNotFoundException The registry doesn't have an associated registry policy.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetRegistryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRegistryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRegistryPolicyResponse> getRegistryPolicy(GetRegistryPolicyRequest getRegistryPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the permissions policy for a registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegistryPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetRegistryPolicyRequest#builder()}
     * </p>
     *
     * @param getRegistryPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.GetRegistryPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRegistryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RegistryPolicyNotFoundException The registry doesn't have an associated registry policy.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetRegistryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRegistryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRegistryPolicyResponse> getRegistryPolicy(
            Consumer<GetRegistryPolicyRequest.Builder> getRegistryPolicyRequest) {
        return getRegistryPolicy(GetRegistryPolicyRequest.builder().applyMutation(getRegistryPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the scanning configuration for a registry.
     * </p>
     *
     * @param getRegistryScanningConfigurationRequest
     * @return A Java Future containing the result of the GetRegistryScanningConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetRegistryScanningConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRegistryScanningConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRegistryScanningConfigurationResponse> getRegistryScanningConfiguration(
            GetRegistryScanningConfigurationRequest getRegistryScanningConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the scanning configuration for a registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegistryScanningConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetRegistryScanningConfigurationRequest#builder()}
     * </p>
     *
     * @param getRegistryScanningConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.GetRegistryScanningConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRegistryScanningConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetRegistryScanningConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRegistryScanningConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRegistryScanningConfigurationResponse> getRegistryScanningConfiguration(
            Consumer<GetRegistryScanningConfigurationRequest.Builder> getRegistryScanningConfigurationRequest) {
        return getRegistryScanningConfiguration(GetRegistryScanningConfigurationRequest.builder()
                .applyMutation(getRegistryScanningConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the repository policy for the specified repository.
     * </p>
     *
     * @param getRepositoryPolicyRequest
     * @return A Java Future containing the result of the GetRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>RepositoryPolicyNotFoundException The specified repository and registry combination does not have an
     *         associated repository policy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRepositoryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRepositoryPolicyResponse> getRepositoryPolicy(
            GetRepositoryPolicyRequest getRepositoryPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the repository policy for the specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param getRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.GetRepositoryPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>RepositoryPolicyNotFoundException The specified repository and registry combination does not have an
     *         associated repository policy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.GetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/GetRepositoryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRepositoryPolicyResponse> getRepositoryPolicy(
            Consumer<GetRepositoryPolicyRequest.Builder> getRepositoryPolicyRequest) {
        return getRepositoryPolicy(GetRepositoryPolicyRequest.builder().applyMutation(getRepositoryPolicyRequest).build());
    }

    /**
     * <p>
     * Notifies Amazon ECR that you intend to upload an image layer.
     * </p>
     * <p>
     * When an image is pushed, the InitiateLayerUpload API is called once per image layer that has not already been
     * uploaded. Whether or not an image layer has been uploaded is determined by the BatchCheckLayerAvailability API
     * action.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param initiateLayerUploadRequest
     * @return A Java Future containing the result of the InitiateLayerUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.InitiateLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/InitiateLayerUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitiateLayerUploadResponse> initiateLayerUpload(
            InitiateLayerUploadRequest initiateLayerUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Notifies Amazon ECR that you intend to upload an image layer.
     * </p>
     * <p>
     * When an image is pushed, the InitiateLayerUpload API is called once per image layer that has not already been
     * uploaded. Whether or not an image layer has been uploaded is determined by the BatchCheckLayerAvailability API
     * action.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateLayerUploadRequest.Builder} avoiding the
     * need to create one manually via {@link InitiateLayerUploadRequest#builder()}
     * </p>
     *
     * @param initiateLayerUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.InitiateLayerUploadRequest.Builder} to create a request.
     * @return A Java Future containing the result of the InitiateLayerUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.InitiateLayerUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/InitiateLayerUpload" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitiateLayerUploadResponse> initiateLayerUpload(
            Consumer<InitiateLayerUploadRequest.Builder> initiateLayerUploadRequest) {
        return initiateLayerUpload(InitiateLayerUploadRequest.builder().applyMutation(initiateLayerUploadRequest).build());
    }

    /**
     * <p>
     * Lists the artifacts associated with a specified subject image.
     * </p>
     *
     * @param listImageReferrersRequest
     * @return A Java Future containing the result of the ListImageReferrers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ListImageReferrers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImageReferrers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImageReferrersResponse> listImageReferrers(ListImageReferrersRequest listImageReferrersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the artifacts associated with a specified subject image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImageReferrersRequest.Builder} avoiding the
     * need to create one manually via {@link ListImageReferrersRequest#builder()}
     * </p>
     *
     * @param listImageReferrersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.ListImageReferrersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListImageReferrers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ListImageReferrers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImageReferrers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImageReferrersResponse> listImageReferrers(
            Consumer<ListImageReferrersRequest.Builder> listImageReferrersRequest) {
        return listImageReferrers(ListImageReferrersRequest.builder().applyMutation(listImageReferrersRequest).build());
    }

    /**
     * <p>
     * Lists all the image IDs for the specified repository.
     * </p>
     * <p>
     * You can filter images based on whether or not they are tagged by using the <code>tagStatus</code> filter and
     * specifying either <code>TAGGED</code>, <code>UNTAGGED</code> or <code>ANY</code>. For example, you can filter
     * your results to return only <code>UNTAGGED</code> images and then pipe that result to a <a>BatchDeleteImage</a>
     * operation to delete them. Or, you can filter your results to return only <code>TAGGED</code> images to list all
     * of the tags in your repository.
     * </p>
     *
     * @param listImagesRequest
     * @return A Java Future containing the result of the ListImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImagesResponse> listImages(ListImagesRequest listImagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the image IDs for the specified repository.
     * </p>
     * <p>
     * You can filter images based on whether or not they are tagged by using the <code>tagStatus</code> filter and
     * specifying either <code>TAGGED</code>, <code>UNTAGGED</code> or <code>ANY</code>. For example, you can filter
     * your results to return only <code>UNTAGGED</code> images and then pipe that result to a <a>BatchDeleteImage</a>
     * operation to delete them. Or, you can filter your results to return only <code>TAGGED</code> images to list all
     * of the tags in your repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListImagesRequest#builder()}
     * </p>
     *
     * @param listImagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.ListImagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImagesResponse> listImages(Consumer<ListImagesRequest.Builder> listImagesRequest) {
        return listImages(ListImagesRequest.builder().applyMutation(listImagesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.ecr.model.ListImagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.ListImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.ListImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.ecr.model.ListImagesRequest)} operation.</b>
     * </p>
     *
     * @param listImagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesPublisher listImagesPaginator(ListImagesRequest listImagesRequest) {
        return new ListImagesPublisher(this, listImagesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listImages(software.amazon.awssdk.services.ecr.model.ListImagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ecr.paginators.ListImagesPublisher publisher = client.listImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ecr.model.ListImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ecr.model.ListImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImages(software.amazon.awssdk.services.ecr.model.ListImagesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListImagesRequest#builder()}
     * </p>
     *
     * @param listImagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.ListImagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ListImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListImages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImagesPublisher listImagesPaginator(Consumer<ListImagesRequest.Builder> listImagesRequest) {
        return listImagesPaginator(ListImagesRequest.builder().applyMutation(listImagesRequest).build());
    }

    /**
     * <p>
     * Lists the IAM principals that are excluded from having their image pull times recorded.
     * </p>
     *
     * @param listPullTimeUpdateExclusionsRequest
     * @return A Java Future containing the result of the ListPullTimeUpdateExclusions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ListPullTimeUpdateExclusions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListPullTimeUpdateExclusions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPullTimeUpdateExclusionsResponse> listPullTimeUpdateExclusions(
            ListPullTimeUpdateExclusionsRequest listPullTimeUpdateExclusionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the IAM principals that are excluded from having their image pull times recorded.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPullTimeUpdateExclusionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPullTimeUpdateExclusionsRequest#builder()}
     * </p>
     *
     * @param listPullTimeUpdateExclusionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.ListPullTimeUpdateExclusionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPullTimeUpdateExclusions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ListPullTimeUpdateExclusions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListPullTimeUpdateExclusions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPullTimeUpdateExclusionsResponse> listPullTimeUpdateExclusions(
            Consumer<ListPullTimeUpdateExclusionsRequest.Builder> listPullTimeUpdateExclusionsRequest) {
        return listPullTimeUpdateExclusions(ListPullTimeUpdateExclusionsRequest.builder()
                .applyMutation(listPullTimeUpdateExclusionsRequest).build());
    }

    /**
     * <p>
     * List the tags for an Amazon ECR resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for an Amazon ECR resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Allows you to change the basic scan type version or registry policy scope.
     * </p>
     *
     * @param putAccountSettingRequest
     * @return A Java Future containing the result of the PutAccountSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutAccountSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutAccountSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAccountSettingResponse> putAccountSetting(PutAccountSettingRequest putAccountSettingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to change the basic scan type version or registry policy scope.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountSettingRequest.Builder} avoiding the need
     * to create one manually via {@link PutAccountSettingRequest#builder()}
     * </p>
     *
     * @param putAccountSettingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.PutAccountSettingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutAccountSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutAccountSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutAccountSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAccountSettingResponse> putAccountSetting(
            Consumer<PutAccountSettingRequest.Builder> putAccountSettingRequest) {
        return putAccountSetting(PutAccountSettingRequest.builder().applyMutation(putAccountSettingRequest).build());
    }

    /**
     * <p>
     * Creates or updates the image manifest and tags associated with an image.
     * </p>
     * <p>
     * When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or
     * update the image manifest and the tags associated with the image.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param putImageRequest
     * @return A Java Future containing the result of the PutImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageAlreadyExistsException The specified image has already been pushed, and there were no changes to
     *         the manifest or image tag after the last push.</li>
     *         <li>LayersNotFoundException The specified layers could not be found, or the specified layer is not valid
     *         for this repository.</li>
     *         <li>ReferencedImagesNotFoundException The manifest list is referencing an image that does not exist.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>ImageTagAlreadyExistsException The specified image is tagged with a tag that already exists. The
     *         repository is configured for tag immutability.</li>
     *         <li>ImageDigestDoesNotMatchException The specified image digest does not match the digest that Amazon ECR
     *         calculated for the image.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutImageResponse> putImage(PutImageRequest putImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the image manifest and tags associated with an image.
     * </p>
     * <p>
     * When an image is pushed and all new image layers have been uploaded, the PutImage API is called once to create or
     * update the image manifest and the tags associated with the image.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImageRequest.Builder} avoiding the need to
     * create one manually via {@link PutImageRequest#builder()}
     * </p>
     *
     * @param putImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.PutImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageAlreadyExistsException The specified image has already been pushed, and there were no changes to
     *         the manifest or image tag after the last push.</li>
     *         <li>LayersNotFoundException The specified layers could not be found, or the specified layer is not valid
     *         for this repository.</li>
     *         <li>ReferencedImagesNotFoundException The manifest list is referencing an image that does not exist.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>ImageTagAlreadyExistsException The specified image is tagged with a tag that already exists. The
     *         repository is configured for tag immutability.</li>
     *         <li>ImageDigestDoesNotMatchException The specified image digest does not match the digest that Amazon ECR
     *         calculated for the image.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutImageResponse> putImage(Consumer<PutImageRequest.Builder> putImageRequest) {
        return putImage(PutImageRequest.builder().applyMutation(putImageRequest).build());
    }

    /**
     * <important>
     * <p>
     * The <code>PutImageScanningConfiguration</code> API is being deprecated, in favor of specifying the image scanning
     * configuration at the registry level. For more information, see <a>PutRegistryScanningConfiguration</a>.
     * </p>
     * </important>
     * <p>
     * Updates the image scanning configuration for the specified repository.
     * </p>
     *
     * @param putImageScanningConfigurationRequest
     * @return A Java Future containing the result of the PutImageScanningConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutImageScanningConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImageScanningConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutImageScanningConfigurationResponse> putImageScanningConfiguration(
            PutImageScanningConfigurationRequest putImageScanningConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * The <code>PutImageScanningConfiguration</code> API is being deprecated, in favor of specifying the image scanning
     * configuration at the registry level. For more information, see <a>PutRegistryScanningConfiguration</a>.
     * </p>
     * </important>
     * <p>
     * Updates the image scanning configuration for the specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImageScanningConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutImageScanningConfigurationRequest#builder()}
     * </p>
     *
     * @param putImageScanningConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.PutImageScanningConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutImageScanningConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutImageScanningConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImageScanningConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutImageScanningConfigurationResponse> putImageScanningConfiguration(
            Consumer<PutImageScanningConfigurationRequest.Builder> putImageScanningConfigurationRequest) {
        return putImageScanningConfiguration(PutImageScanningConfigurationRequest.builder()
                .applyMutation(putImageScanningConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the image tag mutability settings for the specified repository. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html">Image tag mutability</a>
     * in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param putImageTagMutabilityRequest
     * @return A Java Future containing the result of the PutImageTagMutability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutImageTagMutability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImageTagMutability" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutImageTagMutabilityResponse> putImageTagMutability(
            PutImageTagMutabilityRequest putImageTagMutabilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the image tag mutability settings for the specified repository. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html">Image tag mutability</a>
     * in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutImageTagMutabilityRequest.Builder} avoiding the
     * need to create one manually via {@link PutImageTagMutabilityRequest#builder()}
     * </p>
     *
     * @param putImageTagMutabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.PutImageTagMutabilityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutImageTagMutability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutImageTagMutability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutImageTagMutability" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutImageTagMutabilityResponse> putImageTagMutability(
            Consumer<PutImageTagMutabilityRequest.Builder> putImageTagMutabilityRequest) {
        return putImageTagMutability(PutImageTagMutabilityRequest.builder().applyMutation(putImageTagMutabilityRequest).build());
    }

    /**
     * <p>
     * Creates or updates the lifecycle policy for the specified repository. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html">Lifecycle policy
     * template</a>.
     * </p>
     *
     * @param putLifecyclePolicyRequest
     * @return A Java Future containing the result of the PutLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutLifecyclePolicyResponse> putLifecyclePolicy(PutLifecyclePolicyRequest putLifecyclePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the lifecycle policy for the specified repository. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html">Lifecycle policy
     * template</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param putLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.PutLifecyclePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutLifecyclePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutLifecyclePolicyResponse> putLifecyclePolicy(
            Consumer<PutLifecyclePolicyRequest.Builder> putLifecyclePolicyRequest) {
        return putLifecyclePolicy(PutLifecyclePolicyRequest.builder().applyMutation(putLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Creates or updates the permissions policy for your registry.
     * </p>
     * <p>
     * A registry policy is used to specify permissions for another Amazon Web Services account and is used when
     * configuring cross-account replication. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry permissions</a>
     * in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param putRegistryPolicyRequest
     * @return A Java Future containing the result of the PutRegistryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutRegistryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutRegistryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutRegistryPolicyResponse> putRegistryPolicy(PutRegistryPolicyRequest putRegistryPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the permissions policy for your registry.
     * </p>
     * <p>
     * A registry policy is used to specify permissions for another Amazon Web Services account and is used when
     * configuring cross-account replication. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html">Registry permissions</a>
     * in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRegistryPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutRegistryPolicyRequest#builder()}
     * </p>
     *
     * @param putRegistryPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.PutRegistryPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutRegistryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutRegistryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutRegistryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutRegistryPolicyResponse> putRegistryPolicy(
            Consumer<PutRegistryPolicyRequest.Builder> putRegistryPolicyRequest) {
        return putRegistryPolicy(PutRegistryPolicyRequest.builder().applyMutation(putRegistryPolicyRequest).build());
    }

    /**
     * <p>
     * Creates or updates the scanning configuration for your private registry.
     * </p>
     *
     * @param putRegistryScanningConfigurationRequest
     * @return A Java Future containing the result of the PutRegistryScanningConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>BlockedByOrganizationPolicyException The operation did not succeed because the account is managed by
     *         a organization policy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutRegistryScanningConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutRegistryScanningConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRegistryScanningConfigurationResponse> putRegistryScanningConfiguration(
            PutRegistryScanningConfigurationRequest putRegistryScanningConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the scanning configuration for your private registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRegistryScanningConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutRegistryScanningConfigurationRequest#builder()}
     * </p>
     *
     * @param putRegistryScanningConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.PutRegistryScanningConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutRegistryScanningConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>BlockedByOrganizationPolicyException The operation did not succeed because the account is managed by
     *         a organization policy.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutRegistryScanningConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutRegistryScanningConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRegistryScanningConfigurationResponse> putRegistryScanningConfiguration(
            Consumer<PutRegistryScanningConfigurationRequest.Builder> putRegistryScanningConfigurationRequest) {
        return putRegistryScanningConfiguration(PutRegistryScanningConfigurationRequest.builder()
                .applyMutation(putRegistryScanningConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates or updates the replication configuration for a registry. The existing replication configuration for a
     * repository can be retrieved with the <a>DescribeRegistry</a> API action. The first time the
     * PutReplicationConfiguration API is called, a service-linked IAM role is created in your account for the
     * replication process. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/using-service-linked-roles.html">Using
     * service-linked roles for Amazon ECR</a> in the <i>Amazon Elastic Container Registry User Guide</i>. For more
     * information on the custom role for replication, see <a href=
     * "https://docs.aws.amazon.com/AmazonECR/latest/userguide/replication-creation-templates.html#roles-creatingrole-user-console"
     * >Creating an IAM role for replication</a>.
     * </p>
     * <note>
     * <p>
     * When configuring cross-account replication, the destination account must grant the source account permission to
     * replicate. This permission is controlled using a registry permissions policy. For more information, see
     * <a>PutRegistryPolicy</a>.
     * </p>
     * </note>
     *
     * @param putReplicationConfigurationRequest
     * @return A Java Future containing the result of the PutReplicationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutReplicationConfigurationResponse> putReplicationConfiguration(
            PutReplicationConfigurationRequest putReplicationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the replication configuration for a registry. The existing replication configuration for a
     * repository can be retrieved with the <a>DescribeRegistry</a> API action. The first time the
     * PutReplicationConfiguration API is called, a service-linked IAM role is created in your account for the
     * replication process. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/using-service-linked-roles.html">Using
     * service-linked roles for Amazon ECR</a> in the <i>Amazon Elastic Container Registry User Guide</i>. For more
     * information on the custom role for replication, see <a href=
     * "https://docs.aws.amazon.com/AmazonECR/latest/userguide/replication-creation-templates.html#roles-creatingrole-user-console"
     * >Creating an IAM role for replication</a>.
     * </p>
     * <note>
     * <p>
     * When configuring cross-account replication, the destination account must grant the source account permission to
     * replicate. This permission is controlled using a registry permissions policy. For more information, see
     * <a>PutRegistryPolicy</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param putReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.PutReplicationConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutReplicationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.PutReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/PutReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutReplicationConfigurationResponse> putReplicationConfiguration(
            Consumer<PutReplicationConfigurationRequest.Builder> putReplicationConfigurationRequest) {
        return putReplicationConfiguration(PutReplicationConfigurationRequest.builder()
                .applyMutation(putReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Adds an IAM principal to the pull time update exclusion list for a registry. Amazon ECR will not record the pull
     * time if an excluded principal pulls an image.
     * </p>
     *
     * @param registerPullTimeUpdateExclusionRequest
     * @return A Java Future containing the result of the RegisterPullTimeUpdateExclusion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ExclusionAlreadyExistsException The specified pull time update exclusion already exists for the
     *         registry.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.RegisterPullTimeUpdateExclusion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/RegisterPullTimeUpdateExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterPullTimeUpdateExclusionResponse> registerPullTimeUpdateExclusion(
            RegisterPullTimeUpdateExclusionRequest registerPullTimeUpdateExclusionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an IAM principal to the pull time update exclusion list for a registry. Amazon ECR will not record the pull
     * time if an excluded principal pulls an image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterPullTimeUpdateExclusionRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterPullTimeUpdateExclusionRequest#builder()}
     * </p>
     *
     * @param registerPullTimeUpdateExclusionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.RegisterPullTimeUpdateExclusionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RegisterPullTimeUpdateExclusion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ExclusionAlreadyExistsException The specified pull time update exclusion already exists for the
     *         registry.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.RegisterPullTimeUpdateExclusion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/RegisterPullTimeUpdateExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterPullTimeUpdateExclusionResponse> registerPullTimeUpdateExclusion(
            Consumer<RegisterPullTimeUpdateExclusionRequest.Builder> registerPullTimeUpdateExclusionRequest) {
        return registerPullTimeUpdateExclusion(RegisterPullTimeUpdateExclusionRequest.builder()
                .applyMutation(registerPullTimeUpdateExclusionRequest).build());
    }

    /**
     * <p>
     * Applies a repository policy to the specified repository to control access permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html">Amazon ECR Repository
     * policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param setRepositoryPolicyRequest
     * @return A Java Future containing the result of the SetRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.SetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/SetRepositoryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetRepositoryPolicyResponse> setRepositoryPolicy(
            SetRepositoryPolicyRequest setRepositoryPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a repository policy to the specified repository to control access permissions. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html">Amazon ECR Repository
     * policies</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetRepositoryPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link SetRepositoryPolicyRequest#builder()}
     * </p>
     *
     * @param setRepositoryPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.SetRepositoryPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SetRepositoryPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.SetRepositoryPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/SetRepositoryPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetRepositoryPolicyResponse> setRepositoryPolicy(
            Consumer<SetRepositoryPolicyRequest.Builder> setRepositoryPolicyRequest) {
        return setRepositoryPolicy(SetRepositoryPolicyRequest.builder().applyMutation(setRepositoryPolicyRequest).build());
    }

    /**
     * <p>
     * Starts a basic image vulnerability scan.
     * </p>
     * <p>
     * A basic image scan can only be started once per 24 hours on an individual image. This limit includes if an image
     * was scanned on initial push. You can start up to 100,000 basic scans per 24 hours. This limit includes both scans
     * on initial push and scans initiated by the StartImageScan API. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning-basic.html">Basic scanning</a> in the
     * <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     *
     * @param startImageScanRequest
     * @return A Java Future containing the result of the StartImageScan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>UnsupportedImageTypeException The image is of a type that cannot be scanned.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>ImageArchivedException The specified image is archived and cannot be scanned.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.StartImageScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/StartImageScan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImageScanResponse> startImageScan(StartImageScanRequest startImageScanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a basic image vulnerability scan.
     * </p>
     * <p>
     * A basic image scan can only be started once per 24 hours on an individual image. This limit includes if an image
     * was scanned on initial push. You can start up to 100,000 basic scans per 24 hours. This limit includes both scans
     * on initial push and scans initiated by the StartImageScan API. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning-basic.html">Basic scanning</a> in the
     * <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImageScanRequest.Builder} avoiding the need to
     * create one manually via {@link StartImageScanRequest#builder()}
     * </p>
     *
     * @param startImageScanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.StartImageScanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartImageScan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>UnsupportedImageTypeException The image is of a type that cannot be scanned.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>ImageArchivedException The specified image is archived and cannot be scanned.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.StartImageScan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/StartImageScan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImageScanResponse> startImageScan(Consumer<StartImageScanRequest.Builder> startImageScanRequest) {
        return startImageScan(StartImageScanRequest.builder().applyMutation(startImageScanRequest).build());
    }

    /**
     * <p>
     * Starts a preview of a lifecycle policy for the specified repository. This allows you to see the results before
     * associating the lifecycle policy with the repository.
     * </p>
     *
     * @param startLifecyclePolicyPreviewRequest
     * @return A Java Future containing the result of the StartLifecyclePolicyPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LifecyclePolicyNotFoundException The lifecycle policy could not be found, and no policy is set to the
     *         repository.</li>
     *         <li>LifecyclePolicyPreviewInProgressException The previous lifecycle policy preview request has not
     *         completed. Wait and try again.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.StartLifecyclePolicyPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/StartLifecyclePolicyPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartLifecyclePolicyPreviewResponse> startLifecyclePolicyPreview(
            StartLifecyclePolicyPreviewRequest startLifecyclePolicyPreviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a preview of a lifecycle policy for the specified repository. This allows you to see the results before
     * associating the lifecycle policy with the repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartLifecyclePolicyPreviewRequest.Builder}
     * avoiding the need to create one manually via {@link StartLifecyclePolicyPreviewRequest#builder()}
     * </p>
     *
     * @param startLifecyclePolicyPreviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.StartLifecyclePolicyPreviewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartLifecyclePolicyPreview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>LifecyclePolicyNotFoundException The lifecycle policy could not be found, and no policy is set to the
     *         repository.</li>
     *         <li>LifecyclePolicyPreviewInProgressException The previous lifecycle policy preview request has not
     *         completed. Wait and try again.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.StartLifecyclePolicyPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/StartLifecyclePolicyPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartLifecyclePolicyPreviewResponse> startLifecyclePolicyPreview(
            Consumer<StartLifecyclePolicyPreviewRequest.Builder> startLifecyclePolicyPreviewRequest) {
        return startLifecyclePolicyPreview(StartLifecyclePolicyPreviewRequest.builder()
                .applyMutation(startLifecyclePolicyPreviewRequest).build());
    }

    /**
     * <p>
     * Adds specified tags to a resource with the specified ARN. Existing tags on a resource are not changed if they are
     * not specified in the request parameters.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds specified tags to a resource with the specified ARN. Existing tags on a resource are not changed if they are
     * not specified in the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidTagParameterException An invalid parameter has been specified. Tag keys can have a maximum
     *         character length of 128 characters, and tag values can have a maximum length of 256 characters.</li>
     *         <li>TooManyTagsException The list of tags on the repository is over the limit. The maximum number of tags
     *         that can be applied to a repository is 50.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Transitions an image between storage classes. You can transition images from Amazon ECR standard storage class to
     * Amazon ECR archival storage class for long-term storage, or restore archived images back to Amazon ECR standard.
     * </p>
     *
     * @param updateImageStorageClassRequest
     * @return A Java Future containing the result of the UpdateImageStorageClass operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>ImageStorageClassUpdateNotSupportedException The requested image storage class update is not
     *         supported.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.UpdateImageStorageClass
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UpdateImageStorageClass" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateImageStorageClassResponse> updateImageStorageClass(
            UpdateImageStorageClassRequest updateImageStorageClassRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transitions an image between storage classes. You can transition images from Amazon ECR standard storage class to
     * Amazon ECR archival storage class for long-term storage, or restore archived images back to Amazon ECR standard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateImageStorageClassRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateImageStorageClassRequest#builder()}
     * </p>
     *
     * @param updateImageStorageClassRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.UpdateImageStorageClassRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateImageStorageClass operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ImageNotFoundException The image requested does not exist in the specified repository.</li>
     *         <li>ImageStorageClassUpdateNotSupportedException The requested image storage class update is not
     *         supported.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.UpdateImageStorageClass
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UpdateImageStorageClass" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateImageStorageClassResponse> updateImageStorageClass(
            Consumer<UpdateImageStorageClassRequest.Builder> updateImageStorageClassRequest) {
        return updateImageStorageClass(UpdateImageStorageClassRequest.builder().applyMutation(updateImageStorageClassRequest)
                .build());
    }

    /**
     * <p>
     * Updates an existing pull through cache rule.
     * </p>
     *
     * @param updatePullThroughCacheRuleRequest
     * @return A Java Future containing the result of the UpdatePullThroughCacheRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>UnableToAccessSecretException The secret is unable to be accessed. Verify the resource permissions
     *         for the secret and try again.</li>
     *         <li>PullThroughCacheRuleNotFoundException The pull through cache rule was not found. Specify a valid pull
     *         through cache rule and try again.</li>
     *         <li>SecretNotFoundException The ARN of the secret specified in the pull through cache rule was not found.
     *         Update the pull through cache rule with a valid secret ARN and try again.</li>
     *         <li>UnableToDecryptSecretValueException The secret is accessible but is unable to be decrypted. Verify
     *         the resource permisisons and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.UpdatePullThroughCacheRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UpdatePullThroughCacheRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullThroughCacheRuleResponse> updatePullThroughCacheRule(
            UpdatePullThroughCacheRuleRequest updatePullThroughCacheRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing pull through cache rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePullThroughCacheRuleRequest.Builder} avoiding
     * the need to create one manually via {@link UpdatePullThroughCacheRuleRequest#builder()}
     * </p>
     *
     * @param updatePullThroughCacheRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.UpdatePullThroughCacheRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePullThroughCacheRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>UnableToAccessSecretException The secret is unable to be accessed. Verify the resource permissions
     *         for the secret and try again.</li>
     *         <li>PullThroughCacheRuleNotFoundException The pull through cache rule was not found. Specify a valid pull
     *         through cache rule and try again.</li>
     *         <li>SecretNotFoundException The ARN of the secret specified in the pull through cache rule was not found.
     *         Update the pull through cache rule with a valid secret ARN and try again.</li>
     *         <li>UnableToDecryptSecretValueException The secret is accessible but is unable to be decrypted. Verify
     *         the resource permisisons and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.UpdatePullThroughCacheRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UpdatePullThroughCacheRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullThroughCacheRuleResponse> updatePullThroughCacheRule(
            Consumer<UpdatePullThroughCacheRuleRequest.Builder> updatePullThroughCacheRuleRequest) {
        return updatePullThroughCacheRule(UpdatePullThroughCacheRuleRequest.builder()
                .applyMutation(updatePullThroughCacheRuleRequest).build());
    }

    /**
     * <p>
     * Updates an existing repository creation template.
     * </p>
     *
     * @param updateRepositoryCreationTemplateRequest
     * @return A Java Future containing the result of the UpdateRepositoryCreationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>TemplateNotFoundException The specified repository creation template can't be found. Verify the
     *         registry ID and prefix and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.UpdateRepositoryCreationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UpdateRepositoryCreationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRepositoryCreationTemplateResponse> updateRepositoryCreationTemplate(
            UpdateRepositoryCreationTemplateRequest updateRepositoryCreationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing repository creation template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRepositoryCreationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRepositoryCreationTemplateRequest#builder()}
     * </p>
     *
     * @param updateRepositoryCreationTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.UpdateRepositoryCreationTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateRepositoryCreationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>TemplateNotFoundException The specified repository creation template can't be found. Verify the
     *         registry ID and prefix and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.UpdateRepositoryCreationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UpdateRepositoryCreationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRepositoryCreationTemplateResponse> updateRepositoryCreationTemplate(
            Consumer<UpdateRepositoryCreationTemplateRequest.Builder> updateRepositoryCreationTemplateRequest) {
        return updateRepositoryCreationTemplate(UpdateRepositoryCreationTemplateRequest.builder()
                .applyMutation(updateRepositoryCreationTemplateRequest).build());
    }

    /**
     * <p>
     * Uploads an image layer part to Amazon ECR.
     * </p>
     * <p>
     * When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can
     * be 20971520 bytes (or about 20MB). The UploadLayerPart API is called once per each new image layer part.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note>
     *
     * @param uploadLayerPartRequest
     * @return A Java Future containing the result of the UploadLayerPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidLayerPartException The layer part size is not valid, or the first byte specified is not
     *         consecutive to the last byte of a previous layer part upload.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>UploadNotFoundException The upload could not be found, or the specified upload ID is not valid for
     *         this repository.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.UploadLayerPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UploadLayerPart" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UploadLayerPartResponse> uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads an image layer part to Amazon ECR.
     * </p>
     * <p>
     * When an image is pushed, each new image layer is uploaded in parts. The maximum size of each image layer part can
     * be 20971520 bytes (or about 20MB). The UploadLayerPart API is called once per each new image layer part.
     * </p>
     * <note>
     * <p>
     * This operation is used by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
     * images. In most cases, you should use the <code>docker</code> CLI to pull, tag, and push images.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadLayerPartRequest.Builder} avoiding the need
     * to create one manually via {@link UploadLayerPartRequest#builder()}
     * </p>
     *
     * @param uploadLayerPartRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.UploadLayerPartRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UploadLayerPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>InvalidLayerPartException The layer part size is not valid, or the first byte specified is not
     *         consecutive to the last byte of a previous layer part upload.</li>
     *         <li>RepositoryNotFoundException The specified repository could not be found. Check the spelling of the
     *         specified repository and ensure that you are performing operations on the correct registry.</li>
     *         <li>UploadNotFoundException The upload could not be found, or the specified upload ID is not valid for
     *         this repository.</li>
     *         <li>LimitExceededException The operation did not succeed because it would have exceeded a service limit
     *         for your account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/service-quotas.html">Amazon ECR service
     *         quotas</a> in the Amazon Elastic Container Registry User Guide.</li>
     *         <li>KmsException The operation failed due to a KMS exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.UploadLayerPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/UploadLayerPart" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UploadLayerPartResponse> uploadLayerPart(
            Consumer<UploadLayerPartRequest.Builder> uploadLayerPartRequest) {
        return uploadLayerPart(UploadLayerPartRequest.builder().applyMutation(uploadLayerPartRequest).build());
    }

    /**
     * <p>
     * Validates an existing pull through cache rule for an upstream registry that requires authentication. This will
     * retrieve the contents of the Amazon Web Services Secrets Manager secret, verify the syntax, and then validate
     * that authentication to the upstream registry is successful.
     * </p>
     *
     * @param validatePullThroughCacheRuleRequest
     * @return A Java Future containing the result of the ValidatePullThroughCacheRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>PullThroughCacheRuleNotFoundException The pull through cache rule was not found. Specify a valid pull
     *         through cache rule and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ValidatePullThroughCacheRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ValidatePullThroughCacheRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidatePullThroughCacheRuleResponse> validatePullThroughCacheRule(
            ValidatePullThroughCacheRuleRequest validatePullThroughCacheRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates an existing pull through cache rule for an upstream registry that requires authentication. This will
     * retrieve the contents of the Amazon Web Services Secrets Manager secret, verify the syntax, and then validate
     * that authentication to the upstream registry is successful.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidatePullThroughCacheRuleRequest.Builder}
     * avoiding the need to create one manually via {@link ValidatePullThroughCacheRuleRequest#builder()}
     * </p>
     *
     * @param validatePullThroughCacheRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ecr.model.ValidatePullThroughCacheRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ValidatePullThroughCacheRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServerException These errors are usually caused by a server-side issue.</li>
     *         <li>InvalidParameterException The specified parameter is invalid. Review the available parameters for the
     *         API request.</li>
     *         <li>ValidationException There was an exception validating this request.</li>
     *         <li>PullThroughCacheRuleNotFoundException The pull through cache rule was not found. Specify a valid pull
     *         through cache rule and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EcrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EcrAsyncClient.ValidatePullThroughCacheRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/ValidatePullThroughCacheRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidatePullThroughCacheRuleResponse> validatePullThroughCacheRule(
            Consumer<ValidatePullThroughCacheRuleRequest.Builder> validatePullThroughCacheRuleRequest) {
        return validatePullThroughCacheRule(ValidatePullThroughCacheRuleRequest.builder()
                .applyMutation(validatePullThroughCacheRuleRequest).build());
    }

    /**
     * Create an instance of {@link EcrAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link EcrAsyncWaiter}
     */
    default EcrAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default EcrServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link EcrAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EcrAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EcrAsyncClient}.
     */
    static EcrAsyncClientBuilder builder() {
        return new DefaultEcrAsyncClientBuilder();
    }
}
