/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an artifact associated with a subject image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageReferrer implements SdkPojo, Serializable, ToCopyableBuilder<ImageReferrer.Builder, ImageReferrer> {
    private static final SdkField<String> DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("digest")
            .getter(getter(ImageReferrer::digest)).setter(setter(Builder::digest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("digest").build()).build();

    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaType").getter(getter(ImageReferrer::mediaType)).setter(setter(Builder::mediaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaType").build()).build();

    private static final SdkField<String> ARTIFACT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("artifactType").getter(getter(ImageReferrer::artifactType)).setter(setter(Builder::artifactType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactType").build()).build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("size")
            .getter(getter(ImageReferrer::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()).build();

    private static final SdkField<Map<String, String>> ANNOTATIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("annotations")
            .getter(getter(ImageReferrer::annotations))
            .setter(setter(Builder::annotations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ARTIFACT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("artifactStatus").getter(getter(ImageReferrer::artifactStatusAsString))
            .setter(setter(Builder::artifactStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIGEST_FIELD,
            MEDIA_TYPE_FIELD, ARTIFACT_TYPE_FIELD, SIZE_FIELD, ANNOTATIONS_FIELD, ARTIFACT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String digest;

    private final String mediaType;

    private final String artifactType;

    private final Long size;

    private final Map<String, String> annotations;

    private final String artifactStatus;

    private ImageReferrer(BuilderImpl builder) {
        this.digest = builder.digest;
        this.mediaType = builder.mediaType;
        this.artifactType = builder.artifactType;
        this.size = builder.size;
        this.annotations = builder.annotations;
        this.artifactStatus = builder.artifactStatus;
    }

    /**
     * <p>
     * The digest of the artifact manifest.
     * </p>
     * 
     * @return The digest of the artifact manifest.
     */
    public final String digest() {
        return digest;
    }

    /**
     * <p>
     * The media type of the artifact manifest.
     * </p>
     * 
     * @return The media type of the artifact manifest.
     */
    public final String mediaType() {
        return mediaType;
    }

    /**
     * <p>
     * A string identifying the type of artifact.
     * </p>
     * 
     * @return A string identifying the type of artifact.
     */
    public final String artifactType() {
        return artifactType;
    }

    /**
     * <p>
     * The size, in bytes, of the artifact.
     * </p>
     * 
     * @return The size, in bytes, of the artifact.
     */
    public final Long size() {
        return size;
    }

    /**
     * For responses, this returns true if the service returned a value for the Annotations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnnotations() {
        return annotations != null && !(annotations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of annotations associated with the artifact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnnotations} method.
     * </p>
     * 
     * @return A map of annotations associated with the artifact.
     */
    public final Map<String, String> annotations() {
        return annotations;
    }

    /**
     * <p>
     * The status of the artifact. Valid values are <code>ACTIVE</code>, <code>ARCHIVED</code>, or
     * <code>ACTIVATING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #artifactStatus}
     * will return {@link ArtifactStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #artifactStatusAsString}.
     * </p>
     * 
     * @return The status of the artifact. Valid values are <code>ACTIVE</code>, <code>ARCHIVED</code>, or
     *         <code>ACTIVATING</code>.
     * @see ArtifactStatus
     */
    public final ArtifactStatus artifactStatus() {
        return ArtifactStatus.fromValue(artifactStatus);
    }

    /**
     * <p>
     * The status of the artifact. Valid values are <code>ACTIVE</code>, <code>ARCHIVED</code>, or
     * <code>ACTIVATING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #artifactStatus}
     * will return {@link ArtifactStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #artifactStatusAsString}.
     * </p>
     * 
     * @return The status of the artifact. Valid values are <code>ACTIVE</code>, <code>ARCHIVED</code>, or
     *         <code>ACTIVATING</code>.
     * @see ArtifactStatus
     */
    public final String artifactStatusAsString() {
        return artifactStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(digest());
        hashCode = 31 * hashCode + Objects.hashCode(mediaType());
        hashCode = 31 * hashCode + Objects.hashCode(artifactType());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnnotations() ? annotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(artifactStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageReferrer)) {
            return false;
        }
        ImageReferrer other = (ImageReferrer) obj;
        return Objects.equals(digest(), other.digest()) && Objects.equals(mediaType(), other.mediaType())
                && Objects.equals(artifactType(), other.artifactType()) && Objects.equals(size(), other.size())
                && hasAnnotations() == other.hasAnnotations() && Objects.equals(annotations(), other.annotations())
                && Objects.equals(artifactStatusAsString(), other.artifactStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageReferrer").add("Digest", digest()).add("MediaType", mediaType())
                .add("ArtifactType", artifactType()).add("Size", size())
                .add("Annotations", hasAnnotations() ? annotations() : null).add("ArtifactStatus", artifactStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "digest":
            return Optional.ofNullable(clazz.cast(digest()));
        case "mediaType":
            return Optional.ofNullable(clazz.cast(mediaType()));
        case "artifactType":
            return Optional.ofNullable(clazz.cast(artifactType()));
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        case "annotations":
            return Optional.ofNullable(clazz.cast(annotations()));
        case "artifactStatus":
            return Optional.ofNullable(clazz.cast(artifactStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("digest", DIGEST_FIELD);
        map.put("mediaType", MEDIA_TYPE_FIELD);
        map.put("artifactType", ARTIFACT_TYPE_FIELD);
        map.put("size", SIZE_FIELD);
        map.put("annotations", ANNOTATIONS_FIELD);
        map.put("artifactStatus", ARTIFACT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageReferrer, T> g) {
        return obj -> g.apply((ImageReferrer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageReferrer> {
        /**
         * <p>
         * The digest of the artifact manifest.
         * </p>
         * 
         * @param digest
         *        The digest of the artifact manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digest(String digest);

        /**
         * <p>
         * The media type of the artifact manifest.
         * </p>
         * 
         * @param mediaType
         *        The media type of the artifact manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaType(String mediaType);

        /**
         * <p>
         * A string identifying the type of artifact.
         * </p>
         * 
         * @param artifactType
         *        A string identifying the type of artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactType(String artifactType);

        /**
         * <p>
         * The size, in bytes, of the artifact.
         * </p>
         * 
         * @param size
         *        The size, in bytes, of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);

        /**
         * <p>
         * A map of annotations associated with the artifact.
         * </p>
         * 
         * @param annotations
         *        A map of annotations associated with the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(Map<String, String> annotations);

        /**
         * <p>
         * The status of the artifact. Valid values are <code>ACTIVE</code>, <code>ARCHIVED</code>, or
         * <code>ACTIVATING</code>.
         * </p>
         * 
         * @param artifactStatus
         *        The status of the artifact. Valid values are <code>ACTIVE</code>, <code>ARCHIVED</code>, or
         *        <code>ACTIVATING</code>.
         * @see ArtifactStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactStatus
         */
        Builder artifactStatus(String artifactStatus);

        /**
         * <p>
         * The status of the artifact. Valid values are <code>ACTIVE</code>, <code>ARCHIVED</code>, or
         * <code>ACTIVATING</code>.
         * </p>
         * 
         * @param artifactStatus
         *        The status of the artifact. Valid values are <code>ACTIVE</code>, <code>ARCHIVED</code>, or
         *        <code>ACTIVATING</code>.
         * @see ArtifactStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactStatus
         */
        Builder artifactStatus(ArtifactStatus artifactStatus);
    }

    static final class BuilderImpl implements Builder {
        private String digest;

        private String mediaType;

        private String artifactType;

        private Long size;

        private Map<String, String> annotations = DefaultSdkAutoConstructMap.getInstance();

        private String artifactStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageReferrer model) {
            digest(model.digest);
            mediaType(model.mediaType);
            artifactType(model.artifactType);
            size(model.size);
            annotations(model.annotations);
            artifactStatus(model.artifactStatus);
        }

        public final String getDigest() {
            return digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final String getMediaType() {
            return mediaType;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final String getArtifactType() {
            return artifactType;
        }

        public final void setArtifactType(String artifactType) {
            this.artifactType = artifactType;
        }

        @Override
        public final Builder artifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        public final Long getSize() {
            return size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final Map<String, String> getAnnotations() {
            if (annotations instanceof SdkAutoConstructMap) {
                return null;
            }
            return annotations;
        }

        public final void setAnnotations(Map<String, String> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
        }

        @Override
        public final Builder annotations(Map<String, String> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
            return this;
        }

        public final String getArtifactStatus() {
            return artifactStatus;
        }

        public final void setArtifactStatus(String artifactStatus) {
            this.artifactStatus = artifactStatus;
        }

        @Override
        public final Builder artifactStatus(String artifactStatus) {
            this.artifactStatus = artifactStatus;
            return this;
        }

        @Override
        public final Builder artifactStatus(ArtifactStatus artifactStatus) {
            this.artifactStatus(artifactStatus == null ? null : artifactStatus.toString());
            return this;
        }

        @Override
        public ImageReferrer build() {
            return new ImageReferrer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
