/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageTagsRequest extends EcrPublicRequest implements
        ToCopyableBuilder<DescribeImageTagsRequest.Builder, DescribeImageTagsRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(DescribeImageTagsRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(DescribeImageTagsRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeImageTagsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeImageTagsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeImageTagsRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The AWS account ID associated with the public registry that contains the repository in which to describe images.
     * If you do not specify a registry, the default public registry is assumed.
     * </p>
     * 
     * @return The AWS account ID associated with the public registry that contains the repository in which to describe
     *         images. If you do not specify a registry, the default public registry is assumed.
     */
    public String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository that contains the image tag details to describe.
     * </p>
     * 
     * @return The name of the repository that contains the image tag details to describe.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeImageTags</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code>
     * when there are no more results to return. This option cannot be used when you specify images with
     * <code>imageIds</code>.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>DescribeImageTags</code>
     *         request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     *         This value is <code>null</code> when there are no more results to return. This option cannot be used when
     *         you specify images with <code>imageIds</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of repository results returned by <code>DescribeImageTags</code> in paginated output. When
     * this parameter is used, <code>DescribeImageTags</code> only returns <code>maxResults</code> results in a single
     * page along with a <code>nextToken</code> response element. The remaining results of the initial request can be
     * seen by sending another <code>DescribeImageTags</code> request with the returned <code>nextToken</code> value.
     * This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeImageTags</code> returns
     * up to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when you specify
     * images with <code>imageIds</code>.
     * </p>
     * 
     * @return The maximum number of repository results returned by <code>DescribeImageTags</code> in paginated output.
     *         When this parameter is used, <code>DescribeImageTags</code> only returns <code>maxResults</code> results
     *         in a single page along with a <code>nextToken</code> response element. The remaining results of the
     *         initial request can be seen by sending another <code>DescribeImageTags</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then
     *         <code>DescribeImageTags</code> returns up to 100 results and a <code>nextToken</code> value, if
     *         applicable. This option cannot be used when you specify images with <code>imageIds</code>.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageTagsRequest)) {
            return false;
        }
        DescribeImageTagsRequest other = (DescribeImageTagsRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeImageTagsRequest").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageTagsRequest, T> g) {
        return obj -> g.apply((DescribeImageTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageTagsRequest> {
        /**
         * <p>
         * The AWS account ID associated with the public registry that contains the repository in which to describe
         * images. If you do not specify a registry, the default public registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The AWS account ID associated with the public registry that contains the repository in which to
         *        describe images. If you do not specify a registry, the default public registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository that contains the image tag details to describe.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the image tag details to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeImageTags</code> request
         * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * <code>null</code> when there are no more results to return. This option cannot be used when you specify
         * images with <code>imageIds</code>.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>DescribeImageTags</code>
         *        request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return. This option cannot be
         *        used when you specify images with <code>imageIds</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of repository results returned by <code>DescribeImageTags</code> in paginated output. When
         * this parameter is used, <code>DescribeImageTags</code> only returns <code>maxResults</code> results in a
         * single page along with a <code>nextToken</code> response element. The remaining results of the initial
         * request can be seen by sending another <code>DescribeImageTags</code> request with the returned
         * <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then
         * <code>DescribeImageTags</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.
         * This option cannot be used when you specify images with <code>imageIds</code>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of repository results returned by <code>DescribeImageTags</code> in paginated
         *        output. When this parameter is used, <code>DescribeImageTags</code> only returns
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        The remaining results of the initial request can be seen by sending another
         *        <code>DescribeImageTags</code> request with the returned <code>nextToken</code> value. This value can
         *        be between 1 and 1000. If this parameter is not used, then <code>DescribeImageTags</code> returns up
         *        to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when you
         *        specify images with <code>imageIds</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrPublicRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageTagsRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getRegistryId() {
            return registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImageTagsRequest build() {
            return new DescribeImageTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
