/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the image tag details for an image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageTagDetail implements SdkPojo, Serializable, ToCopyableBuilder<ImageTagDetail.Builder, ImageTagDetail> {
    private static final SdkField<String> IMAGE_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageTag").getter(getter(ImageTagDetail::imageTag)).setter(setter(Builder::imageTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTag").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ImageTagDetail::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<ReferencedImageDetail> IMAGE_DETAIL_FIELD = SdkField
            .<ReferencedImageDetail> builder(MarshallingType.SDK_POJO).memberName("imageDetail")
            .getter(getter(ImageTagDetail::imageDetail)).setter(setter(Builder::imageDetail))
            .constructor(ReferencedImageDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_TAG_FIELD,
            CREATED_AT_FIELD, IMAGE_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String imageTag;

    private final Instant createdAt;

    private final ReferencedImageDetail imageDetail;

    private ImageTagDetail(BuilderImpl builder) {
        this.imageTag = builder.imageTag;
        this.createdAt = builder.createdAt;
        this.imageDetail = builder.imageDetail;
    }

    /**
     * <p>
     * The tag associated with the image.
     * </p>
     * 
     * @return The tag associated with the image.
     */
    public String imageTag() {
        return imageTag;
    }

    /**
     * <p>
     * The time stamp indicating when the image tag was created.
     * </p>
     * 
     * @return The time stamp indicating when the image tag was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * An object that describes the details of an image.
     * </p>
     * 
     * @return An object that describes the details of an image.
     */
    public ReferencedImageDetail imageDetail() {
        return imageDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageTag());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(imageDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageTagDetail)) {
            return false;
        }
        ImageTagDetail other = (ImageTagDetail) obj;
        return Objects.equals(imageTag(), other.imageTag()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(imageDetail(), other.imageDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImageTagDetail").add("ImageTag", imageTag()).add("CreatedAt", createdAt())
                .add("ImageDetail", imageDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageTag":
            return Optional.ofNullable(clazz.cast(imageTag()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "imageDetail":
            return Optional.ofNullable(clazz.cast(imageDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageTagDetail, T> g) {
        return obj -> g.apply((ImageTagDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageTagDetail> {
        /**
         * <p>
         * The tag associated with the image.
         * </p>
         * 
         * @param imageTag
         *        The tag associated with the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTag(String imageTag);

        /**
         * <p>
         * The time stamp indicating when the image tag was created.
         * </p>
         * 
         * @param createdAt
         *        The time stamp indicating when the image tag was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * An object that describes the details of an image.
         * </p>
         * 
         * @param imageDetail
         *        An object that describes the details of an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDetail(ReferencedImageDetail imageDetail);

        /**
         * <p>
         * An object that describes the details of an image.
         * </p>
         * This is a convenience that creates an instance of the {@link ReferencedImageDetail.Builder} avoiding the need
         * to create one manually via {@link ReferencedImageDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReferencedImageDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #imageDetail(ReferencedImageDetail)}.
         * 
         * @param imageDetail
         *        a consumer that will call methods on {@link ReferencedImageDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageDetail(ReferencedImageDetail)
         */
        default Builder imageDetail(Consumer<ReferencedImageDetail.Builder> imageDetail) {
            return imageDetail(ReferencedImageDetail.builder().applyMutation(imageDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String imageTag;

        private Instant createdAt;

        private ReferencedImageDetail imageDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageTagDetail model) {
            imageTag(model.imageTag);
            createdAt(model.createdAt);
            imageDetail(model.imageDetail);
        }

        public final String getImageTag() {
            return imageTag;
        }

        @Override
        public final Builder imageTag(String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        public final void setImageTag(String imageTag) {
            this.imageTag = imageTag;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ReferencedImageDetail.Builder getImageDetail() {
            return imageDetail != null ? imageDetail.toBuilder() : null;
        }

        @Override
        public final Builder imageDetail(ReferencedImageDetail imageDetail) {
            this.imageDetail = imageDetail;
            return this;
        }

        public final void setImageDetail(ReferencedImageDetail.BuilderImpl imageDetail) {
            this.imageDetail = imageDetail != null ? imageDetail.build() : null;
        }

        @Override
        public ImageTagDetail build() {
            return new ImageTagDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
