/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadLayerPartResponse extends EcrPublicResponse implements
        ToCopyableBuilder<UploadLayerPartResponse.Builder, UploadLayerPartResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(UploadLayerPartResponse::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(UploadLayerPartResponse::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(UploadLayerPartResponse::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final SdkField<Long> LAST_BYTE_RECEIVED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastByteReceived").getter(getter(UploadLayerPartResponse::lastByteReceived))
            .setter(setter(Builder::lastByteReceived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastByteReceived").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, UPLOAD_ID_FIELD, LAST_BYTE_RECEIVED_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final String uploadId;

    private final Long lastByteReceived;

    private UploadLayerPartResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.lastByteReceived = builder.lastByteReceived;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The repository name associated with the request.
     * </p>
     * 
     * @return The repository name associated with the request.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The upload ID associated with the request.
     * </p>
     * 
     * @return The upload ID associated with the request.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * The integer value of the last byte received in the request.
     * </p>
     * 
     * @return The integer value of the last byte received in the request.
     */
    public Long lastByteReceived() {
        return lastByteReceived;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(lastByteReceived());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadLayerPartResponse)) {
            return false;
        }
        UploadLayerPartResponse other = (UploadLayerPartResponse) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(uploadId(), other.uploadId()) && Objects.equals(lastByteReceived(), other.lastByteReceived());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UploadLayerPartResponse").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("UploadId", uploadId()).add("LastByteReceived", lastByteReceived())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "lastByteReceived":
            return Optional.ofNullable(clazz.cast(lastByteReceived()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadLayerPartResponse, T> g) {
        return obj -> g.apply((UploadLayerPartResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicResponse.Builder, SdkPojo, CopyableBuilder<Builder, UploadLayerPartResponse> {
        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The repository name associated with the request.
         * </p>
         * 
         * @param repositoryName
         *        The repository name associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The upload ID associated with the request.
         * </p>
         * 
         * @param uploadId
         *        The upload ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The integer value of the last byte received in the request.
         * </p>
         * 
         * @param lastByteReceived
         *        The integer value of the last byte received in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastByteReceived(Long lastByteReceived);
    }

    static final class BuilderImpl extends EcrPublicResponse.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String uploadId;

        private Long lastByteReceived;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadLayerPartResponse model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            uploadId(model.uploadId);
            lastByteReceived(model.lastByteReceived);
        }

        public final String getRegistryId() {
            return registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Long getLastByteReceived() {
            return lastByteReceived;
        }

        @Override
        public final Builder lastByteReceived(Long lastByteReceived) {
            this.lastByteReceived = lastByteReceived;
            return this;
        }

        public final void setLastByteReceived(Long lastByteReceived) {
            this.lastByteReceived = lastByteReceived;
        }

        @Override
        public UploadLayerPartResponse build() {
            return new UploadLayerPartResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
