/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicResponse;
import software.amazon.awssdk.services.ecrpublic.model.Registry;
import software.amazon.awssdk.services.ecrpublic.model.RegistryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRegistriesResponse
extends EcrPublicResponse
implements ToCopyableBuilder<Builder, DescribeRegistriesResponse> {
    private static final SdkField<List<Registry>> REGISTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("registries").getter(DescribeRegistriesResponse.getter(DescribeRegistriesResponse::registries)).setter(DescribeRegistriesResponse.setter(Builder::registries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Registry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeRegistriesResponse.getter(DescribeRegistriesResponse::nextToken)).setter(DescribeRegistriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Registry> registries;
    private final String nextToken;

    private DescribeRegistriesResponse(BuilderImpl builder) {
        super(builder);
        this.registries = builder.registries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasRegistries() {
        return this.registries != null && !(this.registries instanceof SdkAutoConstructList);
    }

    public List<Registry> registries() {
        return this.registries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistries() ? this.registries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistriesResponse)) {
            return false;
        }
        DescribeRegistriesResponse other = (DescribeRegistriesResponse)((Object)obj);
        return this.hasRegistries() == other.hasRegistries() && Objects.equals(this.registries(), other.registries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRegistriesResponse").add("Registries", this.hasRegistries() ? this.registries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registries": {
                return Optional.ofNullable(clazz.cast(this.registries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistriesResponse, T> g) {
        return obj -> g.apply((DescribeRegistriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrPublicResponse.BuilderImpl
    implements Builder {
        private List<Registry> registries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistriesResponse model) {
            super(model);
            this.registries(model.registries);
            this.nextToken(model.nextToken);
        }

        public final Collection<Registry.Builder> getRegistries() {
            if (this.registries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.registries != null ? (Collection)this.registries.stream().map(Registry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder registries(Collection<Registry> registries) {
            this.registries = RegistryListCopier.copy(registries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(Registry ... registries) {
            this.registries(Arrays.asList(registries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(Consumer<Registry.Builder> ... registries) {
            this.registries(Stream.of(registries).map(c -> (Registry)((Registry.Builder)Registry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegistries(Collection<Registry.BuilderImpl> registries) {
            this.registries = RegistryListCopier.copyFromBuilder(registries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRegistriesResponse build() {
            return new DescribeRegistriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrPublicResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRegistriesResponse> {
        public Builder registries(Collection<Registry> var1);

        public Builder registries(Registry ... var1);

        public Builder registries(Consumer<Registry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

