/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecrpublic.model.ImageTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageDetail> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(ImageDetail.getter(ImageDetail::registryId)).setter(ImageDetail.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(ImageDetail.getter(ImageDetail::repositoryName)).setter(ImageDetail.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageDigest").getter(ImageDetail.getter(ImageDetail::imageDigest)).setter(ImageDetail.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()}).build();
    private static final SdkField<List<String>> IMAGE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageTags").getter(ImageDetail.getter(ImageDetail::imageTags)).setter(ImageDetail.setter(Builder::imageTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> IMAGE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("imageSizeInBytes").getter(ImageDetail.getter(ImageDetail::imageSizeInBytes)).setter(ImageDetail.setter(Builder::imageSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSizeInBytes").build()}).build();
    private static final SdkField<Instant> IMAGE_PUSHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("imagePushedAt").getter(ImageDetail.getter(ImageDetail::imagePushedAt)).setter(ImageDetail.setter(Builder::imagePushedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePushedAt").build()}).build();
    private static final SdkField<String> IMAGE_MANIFEST_MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageManifestMediaType").getter(ImageDetail.getter(ImageDetail::imageManifestMediaType)).setter(ImageDetail.setter(Builder::imageManifestMediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageManifestMediaType").build()}).build();
    private static final SdkField<String> ARTIFACT_MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("artifactMediaType").getter(ImageDetail.getter(ImageDetail::artifactMediaType)).setter(ImageDetail.setter(Builder::artifactMediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactMediaType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, IMAGE_DIGEST_FIELD, IMAGE_TAGS_FIELD, IMAGE_SIZE_IN_BYTES_FIELD, IMAGE_PUSHED_AT_FIELD, IMAGE_MANIFEST_MEDIA_TYPE_FIELD, ARTIFACT_MEDIA_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String registryId;
    private final String repositoryName;
    private final String imageDigest;
    private final List<String> imageTags;
    private final Long imageSizeInBytes;
    private final Instant imagePushedAt;
    private final String imageManifestMediaType;
    private final String artifactMediaType;

    private ImageDetail(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageDigest = builder.imageDigest;
        this.imageTags = builder.imageTags;
        this.imageSizeInBytes = builder.imageSizeInBytes;
        this.imagePushedAt = builder.imagePushedAt;
        this.imageManifestMediaType = builder.imageManifestMediaType;
        this.artifactMediaType = builder.artifactMediaType;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String imageDigest() {
        return this.imageDigest;
    }

    public boolean hasImageTags() {
        return this.imageTags != null && !(this.imageTags instanceof SdkAutoConstructList);
    }

    public List<String> imageTags() {
        return this.imageTags;
    }

    public Long imageSizeInBytes() {
        return this.imageSizeInBytes;
    }

    public Instant imagePushedAt() {
        return this.imagePushedAt;
    }

    public String imageManifestMediaType() {
        return this.imageManifestMediaType;
    }

    public String artifactMediaType() {
        return this.artifactMediaType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageTags() ? this.imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePushedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageManifestMediaType());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactMediaType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageDetail)) {
            return false;
        }
        ImageDetail other = (ImageDetail)obj;
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageDigest(), other.imageDigest()) && this.hasImageTags() == other.hasImageTags() && Objects.equals(this.imageTags(), other.imageTags()) && Objects.equals(this.imageSizeInBytes(), other.imageSizeInBytes()) && Objects.equals(this.imagePushedAt(), other.imagePushedAt()) && Objects.equals(this.imageManifestMediaType(), other.imageManifestMediaType()) && Objects.equals(this.artifactMediaType(), other.artifactMediaType());
    }

    public String toString() {
        return ToString.builder((String)"ImageDetail").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("ImageDigest", (Object)this.imageDigest()).add("ImageTags", this.hasImageTags() ? this.imageTags() : null).add("ImageSizeInBytes", (Object)this.imageSizeInBytes()).add("ImagePushedAt", (Object)this.imagePushedAt()).add("ImageManifestMediaType", (Object)this.imageManifestMediaType()).add("ArtifactMediaType", (Object)this.artifactMediaType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "imageTags": {
                return Optional.ofNullable(clazz.cast(this.imageTags()));
            }
            case "imageSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.imageSizeInBytes()));
            }
            case "imagePushedAt": {
                return Optional.ofNullable(clazz.cast(this.imagePushedAt()));
            }
            case "imageManifestMediaType": {
                return Optional.ofNullable(clazz.cast(this.imageManifestMediaType()));
            }
            case "artifactMediaType": {
                return Optional.ofNullable(clazz.cast(this.artifactMediaType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageDetail, T> g) {
        return obj -> g.apply((ImageDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String imageDigest;
        private List<String> imageTags = DefaultSdkAutoConstructList.getInstance();
        private Long imageSizeInBytes;
        private Instant imagePushedAt;
        private String imageManifestMediaType;
        private String artifactMediaType;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageDetail model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageDigest(model.imageDigest);
            this.imageTags(model.imageTags);
            this.imageSizeInBytes(model.imageSizeInBytes);
            this.imagePushedAt(model.imagePushedAt);
            this.imageManifestMediaType(model.imageManifestMediaType);
            this.artifactMediaType(model.artifactMediaType);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final Collection<String> getImageTags() {
            if (this.imageTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageTags;
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String ... imageTags) {
            this.imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
        }

        public final Long getImageSizeInBytes() {
            return this.imageSizeInBytes;
        }

        @Override
        public final Builder imageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
            return this;
        }

        public final void setImageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
        }

        public final Instant getImagePushedAt() {
            return this.imagePushedAt;
        }

        @Override
        public final Builder imagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
            return this;
        }

        public final void setImagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
        }

        public final String getImageManifestMediaType() {
            return this.imageManifestMediaType;
        }

        @Override
        public final Builder imageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
            return this;
        }

        public final void setImageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
        }

        public final String getArtifactMediaType() {
            return this.artifactMediaType;
        }

        @Override
        public final Builder artifactMediaType(String artifactMediaType) {
            this.artifactMediaType = artifactMediaType;
            return this;
        }

        public final void setArtifactMediaType(String artifactMediaType) {
            this.artifactMediaType = artifactMediaType;
        }

        public ImageDetail build() {
            return new ImageDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageDetail> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageDigest(String var1);

        public Builder imageTags(Collection<String> var1);

        public Builder imageTags(String ... var1);

        public Builder imageSizeInBytes(Long var1);

        public Builder imagePushedAt(Instant var1);

        public Builder imageManifestMediaType(String var1);

        public Builder artifactMediaType(String var1);
    }
}

