/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRegistriesResponse extends EcrPublicResponse implements
        ToCopyableBuilder<DescribeRegistriesResponse.Builder, DescribeRegistriesResponse> {
    private static final SdkField<List<Registry>> REGISTRIES_FIELD = SdkField
            .<List<Registry>> builder(MarshallingType.LIST)
            .memberName("registries")
            .getter(getter(DescribeRegistriesResponse::registries))
            .setter(setter(Builder::registries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Registry> builder(MarshallingType.SDK_POJO)
                                            .constructor(Registry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeRegistriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Registry> registries;

    private final String nextToken;

    private DescribeRegistriesResponse(BuilderImpl builder) {
        super(builder);
        this.registries = builder.registries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Registries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRegistries() {
        return registries != null && !(registries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object containing the details for a public registry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegistries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object containing the details for a public registry.
     */
    public List<Registry> registries() {
        return registries;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request. When the
     * results of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can be used to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request. When
     *         the results of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can
     *         be used to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistries() ? registries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegistriesResponse)) {
            return false;
        }
        DescribeRegistriesResponse other = (DescribeRegistriesResponse) obj;
        return hasRegistries() == other.hasRegistries() && Objects.equals(registries(), other.registries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRegistriesResponse").add("Registries", hasRegistries() ? registries() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registries":
            return Optional.ofNullable(clazz.cast(registries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegistriesResponse, T> g) {
        return obj -> g.apply((DescribeRegistriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRegistriesResponse> {
        /**
         * <p>
         * An object containing the details for a public registry.
         * </p>
         * 
         * @param registries
         *        An object containing the details for a public registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registries(Collection<Registry> registries);

        /**
         * <p>
         * An object containing the details for a public registry.
         * </p>
         * 
         * @param registries
         *        An object containing the details for a public registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registries(Registry... registries);

        /**
         * <p>
         * An object containing the details for a public registry.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Registry>.Builder} avoiding the need to
         * create one manually via {@link List<Registry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Registry>.Builder#build()} is called immediately and its
         * result is passed to {@link #registries(List<Registry>)}.
         * 
         * @param registries
         *        a consumer that will call methods on {@link List<Registry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registries(List<Registry>)
         */
        Builder registries(Consumer<Registry.Builder>... registries);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request. When the
         * results of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this value can be used
         * to retrieve the next page of results. This value is <code>null</code> when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeRepositories</code> request.
         *        When the results of a <code>DescribeRepositories</code> request exceed <code>maxResults</code>, this
         *        value can be used to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcrPublicResponse.BuilderImpl implements Builder {
        private List<Registry> registries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegistriesResponse model) {
            super(model);
            registries(model.registries);
            nextToken(model.nextToken);
        }

        public final Collection<Registry.Builder> getRegistries() {
            if (registries instanceof SdkAutoConstructList) {
                return null;
            }
            return registries != null ? registries.stream().map(Registry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder registries(Collection<Registry> registries) {
            this.registries = RegistryListCopier.copy(registries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(Registry... registries) {
            registries(Arrays.asList(registries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(Consumer<Registry.Builder>... registries) {
            registries(Stream.of(registries).map(c -> Registry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegistries(Collection<Registry.BuilderImpl> registries) {
            this.registries = RegistryListCopier.copyFromBuilder(registries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRegistriesResponse build() {
            return new DescribeRegistriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
