/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCheckLayerAvailabilityResponse extends EcrPublicResponse implements
        ToCopyableBuilder<BatchCheckLayerAvailabilityResponse.Builder, BatchCheckLayerAvailabilityResponse> {
    private static final SdkField<List<Layer>> LAYERS_FIELD = SdkField
            .<List<Layer>> builder(MarshallingType.LIST)
            .memberName("layers")
            .getter(getter(BatchCheckLayerAvailabilityResponse::layers))
            .setter(setter(Builder::layers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Layer> builder(MarshallingType.SDK_POJO)
                                            .constructor(Layer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LayerFailure>> FAILURES_FIELD = SdkField
            .<List<LayerFailure>> builder(MarshallingType.LIST)
            .memberName("failures")
            .getter(getter(BatchCheckLayerAvailabilityResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LayerFailure> builder(MarshallingType.SDK_POJO)
                                            .constructor(LayerFailure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYERS_FIELD, FAILURES_FIELD));

    private final List<Layer> layers;

    private final List<LayerFailure> failures;

    private BatchCheckLayerAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.layers = builder.layers;
        this.failures = builder.failures;
    }

    /**
     * Returns true if the Layers property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLayers() {
        return layers != null && !(layers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of image layer objects corresponding to the image layer references in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLayers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of image layer objects corresponding to the image layer references in the request.
     */
    public final List<Layer> layers() {
        return layers;
    }

    /**
     * Returns true if the Failures property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any failures associated with the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailures()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any failures associated with the call.
     */
    public final List<LayerFailure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLayers() ? layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCheckLayerAvailabilityResponse)) {
            return false;
        }
        BatchCheckLayerAvailabilityResponse other = (BatchCheckLayerAvailabilityResponse) obj;
        return hasLayers() == other.hasLayers() && Objects.equals(layers(), other.layers())
                && hasFailures() == other.hasFailures() && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCheckLayerAvailabilityResponse").add("Layers", hasLayers() ? layers() : null)
                .add("Failures", hasFailures() ? failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "layers":
            return Optional.ofNullable(clazz.cast(layers()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCheckLayerAvailabilityResponse, T> g) {
        return obj -> g.apply((BatchCheckLayerAvailabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCheckLayerAvailabilityResponse> {
        /**
         * <p>
         * A list of image layer objects corresponding to the image layer references in the request.
         * </p>
         * 
         * @param layers
         *        A list of image layer objects corresponding to the image layer references in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<Layer> layers);

        /**
         * <p>
         * A list of image layer objects corresponding to the image layer references in the request.
         * </p>
         * 
         * @param layers
         *        A list of image layer objects corresponding to the image layer references in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Layer... layers);

        /**
         * <p>
         * A list of image layer objects corresponding to the image layer references in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Layer>.Builder} avoiding the need to create
         * one manually via {@link List<Layer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Layer>.Builder#build()} is called immediately and its result
         * is passed to {@link #layers(List<Layer>)}.
         * 
         * @param layers
         *        a consumer that will call methods on {@link List<Layer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layers(List<Layer>)
         */
        Builder layers(Consumer<Layer.Builder>... layers);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<LayerFailure> failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(LayerFailure... failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LayerFailure>.Builder} avoiding the need to
         * create one manually via {@link List<LayerFailure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LayerFailure>.Builder#build()} is called immediately and its
         * result is passed to {@link #failures(List<LayerFailure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link List<LayerFailure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(List<LayerFailure>)
         */
        Builder failures(Consumer<LayerFailure.Builder>... failures);
    }

    static final class BuilderImpl extends EcrPublicResponse.BuilderImpl implements Builder {
        private List<Layer> layers = DefaultSdkAutoConstructList.getInstance();

        private List<LayerFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCheckLayerAvailabilityResponse model) {
            super(model);
            layers(model.layers);
            failures(model.failures);
        }

        public final List<Layer.Builder> getLayers() {
            List<Layer.Builder> result = LayerListCopier.copyToBuilder(this.layers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<Layer.Builder>... layers) {
            layers(Stream.of(layers).map(c -> Layer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayerListCopier.copyFromBuilder(layers);
        }

        public final List<LayerFailure.Builder> getFailures() {
            List<LayerFailure.Builder> result = LayerFailureListCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder failures(Collection<LayerFailure> failures) {
            this.failures = LayerFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(LayerFailure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<LayerFailure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> LayerFailure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailures(Collection<LayerFailure.BuilderImpl> failures) {
            this.failures = LayerFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public BatchCheckLayerAvailabilityResponse build() {
            return new BatchCheckLayerAvailabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
