/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a public registry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Registry implements SdkPojo, Serializable, ToCopyableBuilder<Registry.Builder, Registry> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(Registry::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REGISTRY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryArn").getter(getter(Registry::registryArn)).setter(setter(Builder::registryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryArn").build()).build();

    private static final SdkField<String> REGISTRY_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryUri").getter(getter(Registry::registryUri)).setter(setter(Builder::registryUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryUri").build()).build();

    private static final SdkField<Boolean> VERIFIED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("verified").getter(getter(Registry::verified)).setter(setter(Builder::verified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verified").build()).build();

    private static final SdkField<List<RegistryAlias>> ALIASES_FIELD = SdkField
            .<List<RegistryAlias>> builder(MarshallingType.LIST)
            .memberName("aliases")
            .getter(getter(Registry::aliases))
            .setter(setter(Builder::aliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistryAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistryAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REGISTRY_ARN_FIELD, REGISTRY_URI_FIELD, VERIFIED_FIELD, ALIASES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String registryId;

    private final String registryArn;

    private final String registryUri;

    private final Boolean verified;

    private final List<RegistryAlias> aliases;

    private Registry(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.registryArn = builder.registryArn;
        this.registryUri = builder.registryUri;
        this.verified = builder.verified;
        this.aliases = builder.aliases;
    }

    /**
     * <p>
     * The AWS account ID associated with the registry. If you do not specify a registry, the default public registry is
     * assumed.
     * </p>
     * 
     * @return The AWS account ID associated with the registry. If you do not specify a registry, the default public
     *         registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the public registry.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the public registry.
     */
    public final String registryArn() {
        return registryArn;
    }

    /**
     * <p>
     * The URI of a public registry. The URI contains a universal prefix and the registry alias.
     * </p>
     * 
     * @return The URI of a public registry. The URI contains a universal prefix and the registry alias.
     */
    public final String registryUri() {
        return registryUri;
    }

    /**
     * <p>
     * Whether the account is verified. This indicates whether the account is an AWS Marketplace vendor. If an account
     * is verified, each public repository will received a verified account badge on the Amazon ECR Public Gallery.
     * </p>
     * 
     * @return Whether the account is verified. This indicates whether the account is an AWS Marketplace vendor. If an
     *         account is verified, each public repository will received a verified account badge on the Amazon ECR
     *         Public Gallery.
     */
    public final Boolean verified() {
        return verified;
    }

    /**
     * Returns true if the Aliases property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAliases() {
        return aliases != null && !(aliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects representing the aliases for a public registry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAliases()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects representing the aliases for a public registry.
     */
    public final List<RegistryAlias> aliases() {
        return aliases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(registryArn());
        hashCode = 31 * hashCode + Objects.hashCode(registryUri());
        hashCode = 31 * hashCode + Objects.hashCode(verified());
        hashCode = 31 * hashCode + Objects.hashCode(hasAliases() ? aliases() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Registry)) {
            return false;
        }
        Registry other = (Registry) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(registryArn(), other.registryArn())
                && Objects.equals(registryUri(), other.registryUri()) && Objects.equals(verified(), other.verified())
                && hasAliases() == other.hasAliases() && Objects.equals(aliases(), other.aliases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Registry").add("RegistryId", registryId()).add("RegistryArn", registryArn())
                .add("RegistryUri", registryUri()).add("Verified", verified()).add("Aliases", hasAliases() ? aliases() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "registryArn":
            return Optional.ofNullable(clazz.cast(registryArn()));
        case "registryUri":
            return Optional.ofNullable(clazz.cast(registryUri()));
        case "verified":
            return Optional.ofNullable(clazz.cast(verified()));
        case "aliases":
            return Optional.ofNullable(clazz.cast(aliases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Registry, T> g) {
        return obj -> g.apply((Registry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Registry> {
        /**
         * <p>
         * The AWS account ID associated with the registry. If you do not specify a registry, the default public
         * registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The AWS account ID associated with the registry. If you do not specify a registry, the default public
         *        registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the public registry.
         * </p>
         * 
         * @param registryArn
         *        The Amazon Resource Name (ARN) of the public registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryArn(String registryArn);

        /**
         * <p>
         * The URI of a public registry. The URI contains a universal prefix and the registry alias.
         * </p>
         * 
         * @param registryUri
         *        The URI of a public registry. The URI contains a universal prefix and the registry alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryUri(String registryUri);

        /**
         * <p>
         * Whether the account is verified. This indicates whether the account is an AWS Marketplace vendor. If an
         * account is verified, each public repository will received a verified account badge on the Amazon ECR Public
         * Gallery.
         * </p>
         * 
         * @param verified
         *        Whether the account is verified. This indicates whether the account is an AWS Marketplace vendor. If
         *        an account is verified, each public repository will received a verified account badge on the Amazon
         *        ECR Public Gallery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verified(Boolean verified);

        /**
         * <p>
         * An array of objects representing the aliases for a public registry.
         * </p>
         * 
         * @param aliases
         *        An array of objects representing the aliases for a public registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Collection<RegistryAlias> aliases);

        /**
         * <p>
         * An array of objects representing the aliases for a public registry.
         * </p>
         * 
         * @param aliases
         *        An array of objects representing the aliases for a public registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(RegistryAlias... aliases);

        /**
         * <p>
         * An array of objects representing the aliases for a public registry.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RegistryAlias>.Builder} avoiding the need
         * to create one manually via {@link List<RegistryAlias>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RegistryAlias>.Builder#build()} is called immediately and
         * its result is passed to {@link #aliases(List<RegistryAlias>)}.
         * 
         * @param aliases
         *        a consumer that will call methods on {@link List<RegistryAlias>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(List<RegistryAlias>)
         */
        Builder aliases(Consumer<RegistryAlias.Builder>... aliases);
    }

    static final class BuilderImpl implements Builder {
        private String registryId;

        private String registryArn;

        private String registryUri;

        private Boolean verified;

        private List<RegistryAlias> aliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Registry model) {
            registryId(model.registryId);
            registryArn(model.registryArn);
            registryUri(model.registryUri);
            verified(model.verified);
            aliases(model.aliases);
        }

        public final String getRegistryId() {
            return registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRegistryArn() {
            return registryArn;
        }

        @Override
        public final Builder registryArn(String registryArn) {
            this.registryArn = registryArn;
            return this;
        }

        public final void setRegistryArn(String registryArn) {
            this.registryArn = registryArn;
        }

        public final String getRegistryUri() {
            return registryUri;
        }

        @Override
        public final Builder registryUri(String registryUri) {
            this.registryUri = registryUri;
            return this;
        }

        public final void setRegistryUri(String registryUri) {
            this.registryUri = registryUri;
        }

        public final Boolean getVerified() {
            return verified;
        }

        @Override
        public final Builder verified(Boolean verified) {
            this.verified = verified;
            return this;
        }

        public final void setVerified(Boolean verified) {
            this.verified = verified;
        }

        public final List<RegistryAlias.Builder> getAliases() {
            List<RegistryAlias.Builder> result = RegistryAliasListCopier.copyToBuilder(this.aliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder aliases(Collection<RegistryAlias> aliases) {
            this.aliases = RegistryAliasListCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(RegistryAlias... aliases) {
            aliases(Arrays.asList(aliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Consumer<RegistryAlias.Builder>... aliases) {
            aliases(Stream.of(aliases).map(c -> RegistryAlias.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAliases(Collection<RegistryAlias.BuilderImpl> aliases) {
            this.aliases = RegistryAliasListCopier.copyFromBuilder(aliases);
        }

        @Override
        public Registry build() {
            return new Registry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
