/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing the catalog data for a repository. This data is publicly visible in the Amazon ECR Public
 * Gallery.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryCatalogDataInput implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryCatalogDataInput.Builder, RepositoryCatalogDataInput> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RepositoryCatalogDataInput::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("architectures")
            .getter(getter(RepositoryCatalogDataInput::architectures))
            .setter(setter(Builder::architectures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OPERATING_SYSTEMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("operatingSystems")
            .getter(getter(RepositoryCatalogDataInput::operatingSystems))
            .setter(setter(Builder::operatingSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SdkBytes> LOGO_IMAGE_BLOB_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("logoImageBlob").getter(getter(RepositoryCatalogDataInput::logoImageBlob))
            .setter(setter(Builder::logoImageBlob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logoImageBlob").build()).build();

    private static final SdkField<String> ABOUT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aboutText").getter(getter(RepositoryCatalogDataInput::aboutText)).setter(setter(Builder::aboutText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aboutText").build()).build();

    private static final SdkField<String> USAGE_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageText").getter(getter(RepositoryCatalogDataInput::usageText)).setter(setter(Builder::usageText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ARCHITECTURES_FIELD, OPERATING_SYSTEMS_FIELD, LOGO_IMAGE_BLOB_FIELD, ABOUT_TEXT_FIELD, USAGE_TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final List<String> architectures;

    private final List<String> operatingSystems;

    private final SdkBytes logoImageBlob;

    private final String aboutText;

    private final String usageText;

    private RepositoryCatalogDataInput(BuilderImpl builder) {
        this.description = builder.description;
        this.architectures = builder.architectures;
        this.operatingSystems = builder.operatingSystems;
        this.logoImageBlob = builder.logoImageBlob;
        this.aboutText = builder.aboutText;
        this.usageText = builder.usageText;
    }

    /**
     * <p>
     * A short description of the contents of the repository. This text appears in both the image details and also when
     * searching for repositories on the Amazon ECR Public Gallery.
     * </p>
     * 
     * @return A short description of the contents of the repository. This text appears in both the image details and
     *         also when searching for repositories on the Amazon ECR Public Gallery.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Architectures property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasArchitectures() {
        return architectures != null && !(architectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The system architecture that the images in the repository are compatible with. On the Amazon ECR Public Gallery,
     * the following supported architectures will appear as badges on the repository and are used as search filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Linux</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Windows</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If an unsupported tag is added to your repository catalog data, it will be associated with the repository and can
     * be retrieved using the API but will not be discoverable in the Amazon ECR Public Gallery.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArchitectures()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The system architecture that the images in the repository are compatible with. On the Amazon ECR Public
     *         Gallery, the following supported architectures will appear as badges on the repository and are used as
     *         search filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Linux</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Windows</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If an unsupported tag is added to your repository catalog data, it will be associated with the repository
     *         and can be retrieved using the API but will not be discoverable in the Amazon ECR Public Gallery.
     *         </p>
     */
    public final List<String> architectures() {
        return architectures;
    }

    /**
     * Returns true if the OperatingSystems property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOperatingSystems() {
        return operatingSystems != null && !(operatingSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The operating systems that the images in the repository are compatible with. On the Amazon ECR Public Gallery,
     * the following supported operating systems will appear as badges on the repository and are used as search filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ARM</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARM 64</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x86</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>x86-64</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If an unsupported tag is added to your repository catalog data, it will be associated with the repository and can
     * be retrieved using the API but will not be discoverable in the Amazon ECR Public Gallery.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOperatingSystems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The operating systems that the images in the repository are compatible with. On the Amazon ECR Public
     *         Gallery, the following supported operating systems will appear as badges on the repository and are used
     *         as search filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ARM</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARM 64</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>x86</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>x86-64</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If an unsupported tag is added to your repository catalog data, it will be associated with the repository
     *         and can be retrieved using the API but will not be discoverable in the Amazon ECR Public Gallery.
     *         </p>
     */
    public final List<String> operatingSystems() {
        return operatingSystems;
    }

    /**
     * <p>
     * The base64-encoded repository logo payload.
     * </p>
     * <note>
     * <p>
     * The repository logo is only publicly visible in the Amazon ECR Public Gallery for verified accounts.
     * </p>
     * </note>
     * 
     * @return The base64-encoded repository logo payload.</p> <note>
     *         <p>
     *         The repository logo is only publicly visible in the Amazon ECR Public Gallery for verified accounts.
     *         </p>
     */
    public final SdkBytes logoImageBlob() {
        return logoImageBlob;
    }

    /**
     * <p>
     * A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public
     * Gallery. The text must be in markdown format.
     * </p>
     * 
     * @return A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public
     *         Gallery. The text must be in markdown format.
     */
    public final String aboutText() {
        return aboutText;
    }

    /**
     * <p>
     * Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon ECR
     * Public Gallery. The usage text provides context, support information, and additional usage details for users of
     * the repository. The text must be in markdown format.
     * </p>
     * 
     * @return Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon
     *         ECR Public Gallery. The usage text provides context, support information, and additional usage details
     *         for users of the repository. The text must be in markdown format.
     */
    public final String usageText() {
        return usageText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasArchitectures() ? architectures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOperatingSystems() ? operatingSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logoImageBlob());
        hashCode = 31 * hashCode + Objects.hashCode(aboutText());
        hashCode = 31 * hashCode + Objects.hashCode(usageText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryCatalogDataInput)) {
            return false;
        }
        RepositoryCatalogDataInput other = (RepositoryCatalogDataInput) obj;
        return Objects.equals(description(), other.description()) && hasArchitectures() == other.hasArchitectures()
                && Objects.equals(architectures(), other.architectures()) && hasOperatingSystems() == other.hasOperatingSystems()
                && Objects.equals(operatingSystems(), other.operatingSystems())
                && Objects.equals(logoImageBlob(), other.logoImageBlob()) && Objects.equals(aboutText(), other.aboutText())
                && Objects.equals(usageText(), other.usageText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryCatalogDataInput").add("Description", description())
                .add("Architectures", hasArchitectures() ? architectures() : null)
                .add("OperatingSystems", hasOperatingSystems() ? operatingSystems() : null).add("LogoImageBlob", logoImageBlob())
                .add("AboutText", aboutText()).add("UsageText", usageText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "architectures":
            return Optional.ofNullable(clazz.cast(architectures()));
        case "operatingSystems":
            return Optional.ofNullable(clazz.cast(operatingSystems()));
        case "logoImageBlob":
            return Optional.ofNullable(clazz.cast(logoImageBlob()));
        case "aboutText":
            return Optional.ofNullable(clazz.cast(aboutText()));
        case "usageText":
            return Optional.ofNullable(clazz.cast(usageText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryCatalogDataInput, T> g) {
        return obj -> g.apply((RepositoryCatalogDataInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryCatalogDataInput> {
        /**
         * <p>
         * A short description of the contents of the repository. This text appears in both the image details and also
         * when searching for repositories on the Amazon ECR Public Gallery.
         * </p>
         * 
         * @param description
         *        A short description of the contents of the repository. This text appears in both the image details and
         *        also when searching for repositories on the Amazon ECR Public Gallery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The system architecture that the images in the repository are compatible with. On the Amazon ECR Public
         * Gallery, the following supported architectures will appear as badges on the repository and are used as search
         * filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Linux</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Windows</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If an unsupported tag is added to your repository catalog data, it will be associated with the repository and
         * can be retrieved using the API but will not be discoverable in the Amazon ECR Public Gallery.
         * </p>
         * </note>
         * 
         * @param architectures
         *        The system architecture that the images in the repository are compatible with. On the Amazon ECR
         *        Public Gallery, the following supported architectures will appear as badges on the repository and are
         *        used as search filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Linux</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Windows</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If an unsupported tag is added to your repository catalog data, it will be associated with the
         *        repository and can be retrieved using the API but will not be discoverable in the Amazon ECR Public
         *        Gallery.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(Collection<String> architectures);

        /**
         * <p>
         * The system architecture that the images in the repository are compatible with. On the Amazon ECR Public
         * Gallery, the following supported architectures will appear as badges on the repository and are used as search
         * filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Linux</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Windows</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If an unsupported tag is added to your repository catalog data, it will be associated with the repository and
         * can be retrieved using the API but will not be discoverable in the Amazon ECR Public Gallery.
         * </p>
         * </note>
         * 
         * @param architectures
         *        The system architecture that the images in the repository are compatible with. On the Amazon ECR
         *        Public Gallery, the following supported architectures will appear as badges on the repository and are
         *        used as search filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Linux</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Windows</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If an unsupported tag is added to your repository catalog data, it will be associated with the
         *        repository and can be retrieved using the API but will not be discoverable in the Amazon ECR Public
         *        Gallery.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(String... architectures);

        /**
         * <p>
         * The operating systems that the images in the repository are compatible with. On the Amazon ECR Public
         * Gallery, the following supported operating systems will appear as badges on the repository and are used as
         * search filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ARM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARM 64</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>x86</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>x86-64</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If an unsupported tag is added to your repository catalog data, it will be associated with the repository and
         * can be retrieved using the API but will not be discoverable in the Amazon ECR Public Gallery.
         * </p>
         * </note>
         * 
         * @param operatingSystems
         *        The operating systems that the images in the repository are compatible with. On the Amazon ECR Public
         *        Gallery, the following supported operating systems will appear as badges on the repository and are
         *        used as search filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ARM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARM 64</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>x86</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>x86-64</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If an unsupported tag is added to your repository catalog data, it will be associated with the
         *        repository and can be retrieved using the API but will not be discoverable in the Amazon ECR Public
         *        Gallery.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystems(Collection<String> operatingSystems);

        /**
         * <p>
         * The operating systems that the images in the repository are compatible with. On the Amazon ECR Public
         * Gallery, the following supported operating systems will appear as badges on the repository and are used as
         * search filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ARM</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARM 64</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>x86</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>x86-64</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If an unsupported tag is added to your repository catalog data, it will be associated with the repository and
         * can be retrieved using the API but will not be discoverable in the Amazon ECR Public Gallery.
         * </p>
         * </note>
         * 
         * @param operatingSystems
         *        The operating systems that the images in the repository are compatible with. On the Amazon ECR Public
         *        Gallery, the following supported operating systems will appear as badges on the repository and are
         *        used as search filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ARM</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARM 64</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>x86</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>x86-64</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If an unsupported tag is added to your repository catalog data, it will be associated with the
         *        repository and can be retrieved using the API but will not be discoverable in the Amazon ECR Public
         *        Gallery.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystems(String... operatingSystems);

        /**
         * <p>
         * The base64-encoded repository logo payload.
         * </p>
         * <note>
         * <p>
         * The repository logo is only publicly visible in the Amazon ECR Public Gallery for verified accounts.
         * </p>
         * </note>
         * 
         * @param logoImageBlob
         *        The base64-encoded repository logo payload.</p> <note>
         *        <p>
         *        The repository logo is only publicly visible in the Amazon ECR Public Gallery for verified accounts.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoImageBlob(SdkBytes logoImageBlob);

        /**
         * <p>
         * A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR Public
         * Gallery. The text must be in markdown format.
         * </p>
         * 
         * @param aboutText
         *        A detailed description of the contents of the repository. It is publicly visible in the Amazon ECR
         *        Public Gallery. The text must be in markdown format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aboutText(String aboutText);

        /**
         * <p>
         * Detailed information on how to use the contents of the repository. It is publicly visible in the Amazon ECR
         * Public Gallery. The usage text provides context, support information, and additional usage details for users
         * of the repository. The text must be in markdown format.
         * </p>
         * 
         * @param usageText
         *        Detailed information on how to use the contents of the repository. It is publicly visible in the
         *        Amazon ECR Public Gallery. The usage text provides context, support information, and additional usage
         *        details for users of the repository. The text must be in markdown format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageText(String usageText);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();

        private List<String> operatingSystems = DefaultSdkAutoConstructList.getInstance();

        private SdkBytes logoImageBlob;

        private String aboutText;

        private String usageText;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryCatalogDataInput model) {
            description(model.description);
            architectures(model.architectures);
            operatingSystems(model.operatingSystems);
            logoImageBlob(model.logoImageBlob);
            aboutText(model.aboutText);
            usageText(model.usageText);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getArchitectures() {
            if (architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return architectures;
        }

        @Override
        public final Builder architectures(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(String... architectures) {
            architectures(Arrays.asList(architectures));
            return this;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
        }

        public final Collection<String> getOperatingSystems() {
            if (operatingSystems instanceof SdkAutoConstructList) {
                return null;
            }
            return operatingSystems;
        }

        @Override
        public final Builder operatingSystems(Collection<String> operatingSystems) {
            this.operatingSystems = OperatingSystemListCopier.copy(operatingSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(String... operatingSystems) {
            operatingSystems(Arrays.asList(operatingSystems));
            return this;
        }

        public final void setOperatingSystems(Collection<String> operatingSystems) {
            this.operatingSystems = OperatingSystemListCopier.copy(operatingSystems);
        }

        public final ByteBuffer getLogoImageBlob() {
            return logoImageBlob == null ? null : logoImageBlob.asByteBuffer();
        }

        @Override
        public final Builder logoImageBlob(SdkBytes logoImageBlob) {
            this.logoImageBlob = logoImageBlob;
            return this;
        }

        public final void setLogoImageBlob(ByteBuffer logoImageBlob) {
            logoImageBlob(logoImageBlob == null ? null : SdkBytes.fromByteBuffer(logoImageBlob));
        }

        public final String getAboutText() {
            return aboutText;
        }

        @Override
        public final Builder aboutText(String aboutText) {
            this.aboutText = aboutText;
            return this;
        }

        public final void setAboutText(String aboutText) {
            this.aboutText = aboutText;
        }

        public final String getUsageText() {
            return usageText;
        }

        @Override
        public final Builder usageText(String usageText) {
            this.usageText = usageText;
            return this;
        }

        public final void setUsageText(String usageText) {
            this.usageText = usageText;
        }

        @Override
        public RepositoryCatalogDataInput build() {
            return new RepositoryCatalogDataInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
