/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The layer part size is not valid, or the first byte specified is not consecutive to the last byte of a previous layer
 * part upload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidLayerPartException extends EcrPublicException implements
        ToCopyableBuilder<InvalidLayerPartException.Builder, InvalidLayerPartException> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(InvalidLayerPartException::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(InvalidLayerPartException::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(InvalidLayerPartException::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final SdkField<Long> LAST_VALID_BYTE_RECEIVED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastValidByteReceived").getter(getter(InvalidLayerPartException::lastValidByteReceived))
            .setter(setter(Builder::lastValidByteReceived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastValidByteReceived").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, UPLOAD_ID_FIELD, LAST_VALID_BYTE_RECEIVED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String registryId;

    private final String repositoryName;

    private final String uploadId;

    private final Long lastValidByteReceived;

    private InvalidLayerPartException(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.lastValidByteReceived = builder.lastValidByteReceived;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The AWS account ID associated with the layer part.
     * </p>
     * 
     * @return The AWS account ID associated with the layer part.
     */
    public String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The upload ID associated with the layer part.
     * </p>
     * 
     * @return The upload ID associated with the layer part.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * The position of the last byte of the layer part.
     * </p>
     * 
     * @return The position of the last byte of the layer part.
     */
    public Long lastValidByteReceived() {
        return lastValidByteReceived;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidLayerPartException, T> g) {
        return obj -> g.apply((InvalidLayerPartException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidLayerPartException>, EcrPublicException.Builder {
        /**
         * <p>
         * The AWS account ID associated with the layer part.
         * </p>
         * 
         * @param registryId
         *        The AWS account ID associated with the layer part.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The upload ID associated with the layer part.
         * </p>
         * 
         * @param uploadId
         *        The upload ID associated with the layer part.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The position of the last byte of the layer part.
         * </p>
         * 
         * @param lastValidByteReceived
         *        The position of the last byte of the layer part.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastValidByteReceived(Long lastValidByteReceived);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends EcrPublicException.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String uploadId;

        private Long lastValidByteReceived;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidLayerPartException model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            uploadId(model.uploadId);
            lastValidByteReceived(model.lastValidByteReceived);
        }

        public final String getRegistryId() {
            return registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Long getLastValidByteReceived() {
            return lastValidByteReceived;
        }

        @Override
        public final Builder lastValidByteReceived(Long lastValidByteReceived) {
            this.lastValidByteReceived = lastValidByteReceived;
            return this;
        }

        public final void setLastValidByteReceived(Long lastValidByteReceived) {
            this.lastValidByteReceived = lastValidByteReceived;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidLayerPartException build() {
            return new InvalidLayerPartException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
