/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImagesResponse extends EcrPublicResponse implements
        ToCopyableBuilder<DescribeImagesResponse.Builder, DescribeImagesResponse> {
    private static final SdkField<List<ImageDetail>> IMAGE_DETAILS_FIELD = SdkField
            .<List<ImageDetail>> builder(MarshallingType.LIST)
            .memberName("imageDetails")
            .getter(getter(DescribeImagesResponse::imageDetails))
            .setter(setter(Builder::imageDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeImagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_DETAILS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ImageDetail> imageDetails;

    private final String nextToken;

    private DescribeImagesResponse(BuilderImpl builder) {
        super(builder);
        this.imageDetails = builder.imageDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImageDetails() {
        return imageDetails != null && !(imageDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>ImageDetail</a> objects that contain data about the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageDetails} method.
     * </p>
     * 
     * @return A list of <a>ImageDetail</a> objects that contain data about the image.
     */
    public final List<ImageDetail> imageDetails() {
        return imageDetails;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeImages</code> request. When the results of
     * a <code>DescribeImages</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next
     * page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeImages</code> request. When the
     *         results of a <code>DescribeImages</code> request exceed <code>maxResults</code>, this value can be used
     *         to retrieve the next page of results. This value is <code>null</code> when there are no more results to
     *         return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImageDetails() ? imageDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResponse)) {
            return false;
        }
        DescribeImagesResponse other = (DescribeImagesResponse) obj;
        return hasImageDetails() == other.hasImageDetails() && Objects.equals(imageDetails(), other.imageDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImagesResponse").add("ImageDetails", hasImageDetails() ? imageDetails() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageDetails":
            return Optional.ofNullable(clazz.cast(imageDetails()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagesResponse, T> g) {
        return obj -> g.apply((DescribeImagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImagesResponse> {
        /**
         * <p>
         * A list of <a>ImageDetail</a> objects that contain data about the image.
         * </p>
         * 
         * @param imageDetails
         *        A list of <a>ImageDetail</a> objects that contain data about the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDetails(Collection<ImageDetail> imageDetails);

        /**
         * <p>
         * A list of <a>ImageDetail</a> objects that contain data about the image.
         * </p>
         * 
         * @param imageDetails
         *        A list of <a>ImageDetail</a> objects that contain data about the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDetails(ImageDetail... imageDetails);

        /**
         * <p>
         * A list of <a>ImageDetail</a> objects that contain data about the image.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecrpublic.model.ImageDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecrpublic.model.ImageDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecrpublic.model.ImageDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #imageDetails(List<ImageDetail>)}.
         * 
         * @param imageDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecrpublic.model.ImageDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageDetails(java.util.Collection<ImageDetail>)
         */
        Builder imageDetails(Consumer<ImageDetail.Builder>... imageDetails);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeImages</code> request. When the results
         * of a <code>DescribeImages</code> request exceed <code>maxResults</code>, this value can be used to retrieve
         * the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeImages</code> request. When the
         *        results of a <code>DescribeImages</code> request exceed <code>maxResults</code>, this value can be
         *        used to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcrPublicResponse.BuilderImpl implements Builder {
        private List<ImageDetail> imageDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesResponse model) {
            super(model);
            imageDetails(model.imageDetails);
            nextToken(model.nextToken);
        }

        public final List<ImageDetail.Builder> getImageDetails() {
            List<ImageDetail.Builder> result = ImageDetailListCopier.copyToBuilder(this.imageDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageDetails(Collection<ImageDetail.BuilderImpl> imageDetails) {
            this.imageDetails = ImageDetailListCopier.copyFromBuilder(imageDetails);
        }

        @Override
        public final Builder imageDetails(Collection<ImageDetail> imageDetails) {
            this.imageDetails = ImageDetailListCopier.copy(imageDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageDetails(ImageDetail... imageDetails) {
            imageDetails(Arrays.asList(imageDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageDetails(Consumer<ImageDetail.Builder>... imageDetails) {
            imageDetails(Stream.of(imageDetails).map(c -> ImageDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeImagesResponse build() {
            return new DescribeImagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
