/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Repository implements SdkPojo, Serializable, ToCopyableBuilder<Repository.Builder, Repository> {
    private static final SdkField<String> REPOSITORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryArn").getter(getter(Repository::repositoryArn)).setter(setter(Builder::repositoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryArn").build()).build();

    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(Repository::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(Repository::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> REPOSITORY_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryUri").getter(getter(Repository::repositoryUri)).setter(setter(Builder::repositoryUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryUri").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Repository::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ARN_FIELD,
            REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, REPOSITORY_URI_FIELD, CREATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryArn;

    private final String registryId;

    private final String repositoryName;

    private final String repositoryUri;

    private final Instant createdAt;

    private Repository(BuilderImpl builder) {
        this.repositoryArn = builder.repositoryArn;
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.repositoryUri = builder.repositoryUri;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the <code>arn:aws:ecr</code>
     * namespace, followed by the region of the repository, AWS account ID of the repository owner, repository
     * namespace, and repository name. For example, <code>arn:aws:ecr:region:012345678910:repository/test</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the
     *         <code>arn:aws:ecr</code> namespace, followed by the region of the repository, AWS account ID of the
     *         repository owner, repository namespace, and repository name. For example,
     *         <code>arn:aws:ecr:region:012345678910:repository/test</code>.
     */
    public final String repositoryArn() {
        return repositoryArn;
    }

    /**
     * <p>
     * The AWS account ID associated with the public registry that contains the repository.
     * </p>
     * 
     * @return The AWS account ID associated with the public registry that contains the repository.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The URI for the repository. You can use this URI for container image <code>push</code> and <code>pull</code>
     * operations.
     * </p>
     * 
     * @return The URI for the repository. You can use this URI for container image <code>push</code> and
     *         <code>pull</code> operations.
     */
    public final String repositoryUri() {
        return repositoryUri;
    }

    /**
     * <p>
     * The date and time, in JavaScript date format, when the repository was created.
     * </p>
     * 
     * @return The date and time, in JavaScript date format, when the repository was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryUri());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Repository)) {
            return false;
        }
        Repository other = (Repository) obj;
        return Objects.equals(repositoryArn(), other.repositoryArn()) && Objects.equals(registryId(), other.registryId())
                && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(repositoryUri(), other.repositoryUri()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Repository").add("RepositoryArn", repositoryArn()).add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("RepositoryUri", repositoryUri()).add("CreatedAt", createdAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryArn":
            return Optional.ofNullable(clazz.cast(repositoryArn()));
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "repositoryUri":
            return Optional.ofNullable(clazz.cast(repositoryUri()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Repository, T> g) {
        return obj -> g.apply((Repository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Repository> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the <code>arn:aws:ecr</code>
         * namespace, followed by the region of the repository, AWS account ID of the repository owner, repository
         * namespace, and repository name. For example, <code>arn:aws:ecr:region:012345678910:repository/test</code>.
         * </p>
         * 
         * @param repositoryArn
         *        The Amazon Resource Name (ARN) that identifies the repository. The ARN contains the
         *        <code>arn:aws:ecr</code> namespace, followed by the region of the repository, AWS account ID of the
         *        repository owner, repository namespace, and repository name. For example,
         *        <code>arn:aws:ecr:region:012345678910:repository/test</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryArn(String repositoryArn);

        /**
         * <p>
         * The AWS account ID associated with the public registry that contains the repository.
         * </p>
         * 
         * @param registryId
         *        The AWS account ID associated with the public registry that contains the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The URI for the repository. You can use this URI for container image <code>push</code> and <code>pull</code>
         * operations.
         * </p>
         * 
         * @param repositoryUri
         *        The URI for the repository. You can use this URI for container image <code>push</code> and
         *        <code>pull</code> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryUri(String repositoryUri);

        /**
         * <p>
         * The date and time, in JavaScript date format, when the repository was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time, in JavaScript date format, when the repository was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryArn;

        private String registryId;

        private String repositoryName;

        private String repositoryUri;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Repository model) {
            repositoryArn(model.repositoryArn);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            repositoryUri(model.repositoryUri);
            createdAt(model.createdAt);
        }

        public final String getRepositoryArn() {
            return repositoryArn;
        }

        public final void setRepositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
        }

        @Override
        @Transient
        public final Builder repositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
            return this;
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        @Transient
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryUri() {
            return repositoryUri;
        }

        public final void setRepositoryUri(String repositoryUri) {
            this.repositoryUri = repositoryUri;
        }

        @Override
        @Transient
        public final Builder repositoryUri(String repositoryUri) {
            this.repositoryUri = repositoryUri;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public Repository build() {
            return new Repository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
