/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImagesRequest extends EcrPublicRequest implements
        ToCopyableBuilder<DescribeImagesRequest.Builder, DescribeImagesRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(DescribeImagesRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(DescribeImagesRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<List<ImageIdentifier>> IMAGE_IDS_FIELD = SdkField
            .<List<ImageIdentifier>> builder(MarshallingType.LIST)
            .memberName("imageIds")
            .getter(getter(DescribeImagesRequest::imageIds))
            .setter(setter(Builder::imageIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeImagesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeImagesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, IMAGE_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final List<ImageIdentifier> imageIds;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeImagesRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageIds = builder.imageIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The AWS account ID associated with the public registry that contains the repository in which to describe images.
     * If you do not specify a registry, the default public registry is assumed.
     * </p>
     * 
     * @return The AWS account ID associated with the public registry that contains the repository in which to describe
     *         images. If you do not specify a registry, the default public registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The repository that contains the images to describe.
     * </p>
     * 
     * @return The repository that contains the images to describe.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImageIds() {
        return imageIds != null && !(imageIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of image IDs for the requested repository.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageIds} method.
     * </p>
     * 
     * @return The list of image IDs for the requested repository.
     */
    public final List<ImageIdentifier> imageIds() {
        return imageIds;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeImages</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code>
     * when there are no more results to return. This option cannot be used when you specify images with
     * <code>imageIds</code>.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>DescribeImages</code> request
     *         where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. This value
     *         is <code>null</code> when there are no more results to return. This option cannot be used when you
     *         specify images with <code>imageIds</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of repository results returned by <code>DescribeImages</code> in paginated output. When this
     * parameter is used, <code>DescribeImages</code> only returns <code>maxResults</code> results in a single page
     * along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>DescribeImages</code> request with the returned <code>nextToken</code> value. This value
     * can be between 1 and 1000. If this parameter is not used, then <code>DescribeImages</code> returns up to 100
     * results and a <code>nextToken</code> value, if applicable. This option cannot be used when you specify images
     * with <code>imageIds</code>.
     * </p>
     * 
     * @return The maximum number of repository results returned by <code>DescribeImages</code> in paginated output.
     *         When this parameter is used, <code>DescribeImages</code> only returns <code>maxResults</code> results in
     *         a single page along with a <code>nextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>DescribeImages</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used, then
     *         <code>DescribeImages</code> returns up to 100 results and a <code>nextToken</code> value, if applicable.
     *         This option cannot be used when you specify images with <code>imageIds</code>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(hasImageIds() ? imageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesRequest)) {
            return false;
        }
        DescribeImagesRequest other = (DescribeImagesRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && hasImageIds() == other.hasImageIds() && Objects.equals(imageIds(), other.imageIds())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImagesRequest").add("RegistryId", registryId()).add("RepositoryName", repositoryName())
                .add("ImageIds", hasImageIds() ? imageIds() : null).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageIds":
            return Optional.ofNullable(clazz.cast(imageIds()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagesRequest, T> g) {
        return obj -> g.apply((DescribeImagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImagesRequest> {
        /**
         * <p>
         * The AWS account ID associated with the public registry that contains the repository in which to describe
         * images. If you do not specify a registry, the default public registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The AWS account ID associated with the public registry that contains the repository in which to
         *        describe images. If you do not specify a registry, the default public registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The repository that contains the images to describe.
         * </p>
         * 
         * @param repositoryName
         *        The repository that contains the images to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The list of image IDs for the requested repository.
         * </p>
         * 
         * @param imageIds
         *        The list of image IDs for the requested repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(Collection<ImageIdentifier> imageIds);

        /**
         * <p>
         * The list of image IDs for the requested repository.
         * </p>
         * 
         * @param imageIds
         *        The list of image IDs for the requested repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(ImageIdentifier... imageIds);

        /**
         * <p>
         * The list of image IDs for the requested repository.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecrpublic.model.ImageIdentifier.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ecrpublic.model.ImageIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecrpublic.model.ImageIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #imageIds(List<ImageIdentifier>)}.
         * 
         * @param imageIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecrpublic.model.ImageIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageIds(java.util.Collection<ImageIdentifier>)
         */
        Builder imageIds(Consumer<ImageIdentifier.Builder>... imageIds);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeImages</code> request where
         * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
         * from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * <code>null</code> when there are no more results to return. This option cannot be used when you specify
         * images with <code>imageIds</code>.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>DescribeImages</code>
         *        request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return. This option cannot be
         *        used when you specify images with <code>imageIds</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of repository results returned by <code>DescribeImages</code> in paginated output. When
         * this parameter is used, <code>DescribeImages</code> only returns <code>maxResults</code> results in a single
         * page along with a <code>nextToken</code> response element. The remaining results of the initial request can
         * be seen by sending another <code>DescribeImages</code> request with the returned <code>nextToken</code>
         * value. This value can be between 1 and 1000. If this parameter is not used, then <code>DescribeImages</code>
         * returns up to 100 results and a <code>nextToken</code> value, if applicable. This option cannot be used when
         * you specify images with <code>imageIds</code>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of repository results returned by <code>DescribeImages</code> in paginated output.
         *        When this parameter is used, <code>DescribeImages</code> only returns <code>maxResults</code> results
         *        in a single page along with a <code>nextToken</code> response element. The remaining results of the
         *        initial request can be seen by sending another <code>DescribeImages</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not used,
         *        then <code>DescribeImages</code> returns up to 100 results and a <code>nextToken</code> value, if
         *        applicable. This option cannot be used when you specify images with <code>imageIds</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrPublicRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private List<ImageIdentifier> imageIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            imageIds(model.imageIds);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final List<ImageIdentifier.Builder> getImageIds() {
            List<ImageIdentifier.Builder> result = ImageIdentifierListCopier.copyToBuilder(this.imageIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageIds(Collection<ImageIdentifier.BuilderImpl> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copyFromBuilder(imageIds);
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier... imageIds) {
            imageIds(Arrays.asList(imageIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(Consumer<ImageIdentifier.Builder>... imageIds) {
            imageIds(Stream.of(imageIds).map(c -> ImageIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImagesRequest build() {
            return new DescribeImagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
