/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An authorization token data object that corresponds to a public registry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizationData implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthorizationData.Builder, AuthorizationData> {
    private static final SdkField<String> AUTHORIZATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizationToken").getter(getter(AuthorizationData::authorizationToken))
            .setter(setter(Builder::authorizationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationToken").build())
            .build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresAt").getter(getter(AuthorizationData::expiresAt)).setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_TOKEN_FIELD,
            EXPIRES_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authorizationToken;

    private final Instant expiresAt;

    private AuthorizationData(BuilderImpl builder) {
        this.authorizationToken = builder.authorizationToken;
        this.expiresAt = builder.expiresAt;
    }

    /**
     * <p>
     * A base64-encoded string that contains authorization data for a public Amazon ECR registry. When the string is
     * decoded, it is presented in the format <code>user:password</code> for public registry authentication using
     * <code>docker login</code>.
     * </p>
     * 
     * @return A base64-encoded string that contains authorization data for a public Amazon ECR registry. When the
     *         string is decoded, it is presented in the format <code>user:password</code> for public registry
     *         authentication using <code>docker login</code>.
     */
    public final String authorizationToken() {
        return authorizationToken;
    }

    /**
     * <p>
     * The Unix time in seconds and milliseconds when the authorization token expires. Authorization tokens are valid
     * for 12 hours.
     * </p>
     * 
     * @return The Unix time in seconds and milliseconds when the authorization token expires. Authorization tokens are
     *         valid for 12 hours.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationToken());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationData)) {
            return false;
        }
        AuthorizationData other = (AuthorizationData) obj;
        return Objects.equals(authorizationToken(), other.authorizationToken()) && Objects.equals(expiresAt(), other.expiresAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizationData").add("AuthorizationToken", authorizationToken())
                .add("ExpiresAt", expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizationToken":
            return Optional.ofNullable(clazz.cast(authorizationToken()));
        case "expiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationData, T> g) {
        return obj -> g.apply((AuthorizationData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthorizationData> {
        /**
         * <p>
         * A base64-encoded string that contains authorization data for a public Amazon ECR registry. When the string is
         * decoded, it is presented in the format <code>user:password</code> for public registry authentication using
         * <code>docker login</code>.
         * </p>
         * 
         * @param authorizationToken
         *        A base64-encoded string that contains authorization data for a public Amazon ECR registry. When the
         *        string is decoded, it is presented in the format <code>user:password</code> for public registry
         *        authentication using <code>docker login</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationToken(String authorizationToken);

        /**
         * <p>
         * The Unix time in seconds and milliseconds when the authorization token expires. Authorization tokens are
         * valid for 12 hours.
         * </p>
         * 
         * @param expiresAt
         *        The Unix time in seconds and milliseconds when the authorization token expires. Authorization tokens
         *        are valid for 12 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);
    }

    static final class BuilderImpl implements Builder {
        private String authorizationToken;

        private Instant expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationData model) {
            authorizationToken(model.authorizationToken);
            expiresAt(model.expiresAt);
        }

        public final String getAuthorizationToken() {
            return authorizationToken;
        }

        public final void setAuthorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
        }

        @Override
        public final Builder authorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public AuthorizationData build() {
            return new AuthorizationData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
