/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRepositoryCatalogDataRequest extends EcrPublicRequest implements
        ToCopyableBuilder<PutRepositoryCatalogDataRequest.Builder, PutRepositoryCatalogDataRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(PutRepositoryCatalogDataRequest::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(PutRepositoryCatalogDataRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<RepositoryCatalogDataInput> CATALOG_DATA_FIELD = SdkField
            .<RepositoryCatalogDataInput> builder(MarshallingType.SDK_POJO).memberName("catalogData")
            .getter(getter(PutRepositoryCatalogDataRequest::catalogData)).setter(setter(Builder::catalogData))
            .constructor(RepositoryCatalogDataInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, CATALOG_DATA_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final RepositoryCatalogDataInput catalogData;

    private PutRepositoryCatalogDataRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.catalogData = builder.catalogData;
    }

    /**
     * <p>
     * The AWS account ID associated with the public registry the repository is in. If you do not specify a registry,
     * the default public registry is assumed.
     * </p>
     * 
     * @return The AWS account ID associated with the public registry the repository is in. If you do not specify a
     *         registry, the default public registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository to create or update the catalog data for.
     * </p>
     * 
     * @return The name of the repository to create or update the catalog data for.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * An object containing the catalog data for a repository. This data is publicly visible in the Amazon ECR Public
     * Gallery.
     * </p>
     * 
     * @return An object containing the catalog data for a repository. This data is publicly visible in the Amazon ECR
     *         Public Gallery.
     */
    public final RepositoryCatalogDataInput catalogData() {
        return catalogData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(catalogData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRepositoryCatalogDataRequest)) {
            return false;
        }
        PutRepositoryCatalogDataRequest other = (PutRepositoryCatalogDataRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(catalogData(), other.catalogData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRepositoryCatalogDataRequest").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("CatalogData", catalogData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "catalogData":
            return Optional.ofNullable(clazz.cast(catalogData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRepositoryCatalogDataRequest, T> g) {
        return obj -> g.apply((PutRepositoryCatalogDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutRepositoryCatalogDataRequest> {
        /**
         * <p>
         * The AWS account ID associated with the public registry the repository is in. If you do not specify a
         * registry, the default public registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The AWS account ID associated with the public registry the repository is in. If you do not specify a
         *        registry, the default public registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository to create or update the catalog data for.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository to create or update the catalog data for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * An object containing the catalog data for a repository. This data is publicly visible in the Amazon ECR
         * Public Gallery.
         * </p>
         * 
         * @param catalogData
         *        An object containing the catalog data for a repository. This data is publicly visible in the Amazon
         *        ECR Public Gallery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogData(RepositoryCatalogDataInput catalogData);

        /**
         * <p>
         * An object containing the catalog data for a repository. This data is publicly visible in the Amazon ECR
         * Public Gallery.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepositoryCatalogDataInput.Builder}
         * avoiding the need to create one manually via {@link RepositoryCatalogDataInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RepositoryCatalogDataInput.Builder#build()} is called immediately
         * and its result is passed to {@link #catalogData(RepositoryCatalogDataInput)}.
         * 
         * @param catalogData
         *        a consumer that will call methods on {@link RepositoryCatalogDataInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogData(RepositoryCatalogDataInput)
         */
        default Builder catalogData(Consumer<RepositoryCatalogDataInput.Builder> catalogData) {
            return catalogData(RepositoryCatalogDataInput.builder().applyMutation(catalogData).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrPublicRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private RepositoryCatalogDataInput catalogData;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRepositoryCatalogDataRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            catalogData(model.catalogData);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final RepositoryCatalogDataInput.Builder getCatalogData() {
            return catalogData != null ? catalogData.toBuilder() : null;
        }

        public final void setCatalogData(RepositoryCatalogDataInput.BuilderImpl catalogData) {
            this.catalogData = catalogData != null ? catalogData.build() : null;
        }

        @Override
        public final Builder catalogData(RepositoryCatalogDataInput catalogData) {
            this.catalogData = catalogData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRepositoryCatalogDataRequest build() {
            return new PutRepositoryCatalogDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
